/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.io.json.JsonObject;
import com.oracle.coherence.io.json.genson.GenericType;
import com.oracle.coherence.io.json.genson.Genson;
import com.oracle.coherence.io.json.genson.GensonBuilder;
import com.oracle.coherence.io.json.genson.JsonBindingException;
import com.oracle.coherence.io.json.genson.Modifier;
import com.oracle.coherence.io.json.genson.convert.NullConverterFactory;
import com.oracle.coherence.io.json.genson.datetime.JavaDateTimeBundle;
import com.oracle.coherence.io.json.genson.ext.GensonBundle;
import com.oracle.coherence.io.json.genson.ext.jsonb.JsonbBundle;
import com.oracle.coherence.io.json.genson.ext.jsr353.JSR353Bundle;
import com.oracle.coherence.io.json.genson.reflect.EvolvableHandler;
import com.oracle.coherence.io.json.genson.reflect.VisibilityFilter;
import com.oracle.coherence.io.json.genson.stream.ValueType;
import com.oracle.coherence.io.json.internal.ClassConverter;
import com.oracle.coherence.io.json.internal.ComparableConverter;
import com.oracle.coherence.io.json.internal.EnumConverter;
import com.oracle.coherence.io.json.internal.GensonServiceBundle;
import com.oracle.coherence.io.json.internal.InetAddressConverter;
import com.oracle.coherence.io.json.internal.InetSocketAddressConverter;
import com.oracle.coherence.io.json.internal.JsonObjectConverter;
import com.oracle.coherence.io.json.internal.MapConverter;
import com.oracle.coherence.io.json.internal.MathContextConverter;
import com.oracle.coherence.io.json.internal.MissingClassConverter;
import com.oracle.coherence.io.json.internal.RoundingModeConverter;
import com.oracle.coherence.io.json.internal.SerializationGate;
import com.oracle.coherence.io.json.internal.SerializationSupportConverter;
import com.oracle.coherence.io.json.internal.ThrowableConverter;
import com.oracle.coherence.io.json.internal.VersionableSerializer;
import com.tangosol.coherence.config.Config;
import com.tangosol.io.ByteArrayReadBuffer;
import com.tangosol.io.ByteArrayWriteBuffer;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.Serializer;
import com.tangosol.io.WrapperDataInputStream;
import com.tangosol.io.WrapperDataOutputStream;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.Base;
import com.tangosol.util.Versionable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.math.MathContext;
import java.math.RoundingMode;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;

@Named(value="json")
@ApplicationScoped
public class JsonSerializer
implements Serializer,
ClassLoaderAware {
    private static final GenericType<Object> OBJECT_TYPE = GenericType.of(Object.class);
    private static final Class<?>[] JSON_TYPES = new Class[]{String.class, Number.class, Boolean.class};
    public static final String PROP_DEBUG_MODE = "coherence.io.json.debug";
    public static final boolean DEBUG_MODE = Config.getBoolean((String)"coherence.io.json.debug");
    protected final Genson f_genson;
    protected final boolean f_fCompatibleMode;
    protected WeakReference<ClassLoader> m_refLoader;

    public JsonSerializer() {
        this(null, null, false);
    }

    public JsonSerializer(boolean fCompatibleMode) {
        this(null, null, fCompatibleMode);
    }

    public String getName() {
        return "json";
    }

    public JsonSerializer(ClassLoader loader) {
        this(loader, null, false);
    }

    public JsonSerializer(ClassLoader loader, Modifier<GensonBuilder> builderModifier, boolean fCompatibleMode) {
        this.f_fCompatibleMode = fCompatibleMode;
        GensonBuilder builder = new GensonBuilder().withBundle(new BundleProxy("com.fasterxml.jackson.annotation.JacksonAnnotation", "com.oracle.coherence.io.json.genson.ext.jackson.JacksonBundle")).withBundle(new JavaDateTimeBundle()).withBundle(new GensonServiceBundle()).setDefaultType(ValueType.OBJECT, JsonObject.class).setDefaultType(ValueType.INTEGER, Number.class).setDefaultType(ValueType.DOUBLE, Number.class).useClassMetadata(true).useClassMetadataWithStaticType(true).useFields(true, VisibilityFilter.PRIVATE).useMethods(false).useConstructorWithArguments(true).setSkipNull(true).withSerializer(VersionableSerializer.INSTANCE, Versionable.class).withConverter(InetAddressConverter.INSTANCE, InetAddress.class).withConverter(InetAddressConverter.INSTANCE, Inet4Address.class).withConverter(InetAddressConverter.INSTANCE, Inet6Address.class).withConverter(InetSocketAddressConverter.INSTANCE, InetSocketAddress.class).withConverter(JsonObjectConverter.INSTANCE, JsonObject.class).withConverter(MathContextConverter.INSTANCE, MathContext.class).withConverter(RoundingModeConverter.INSTANCE, RoundingMode.class);
        JsonSerializer.addSafeBundle(builder, JsonbBundle.class);
        JsonSerializer.addSafeBundle(builder, JSR353Bundle.class);
        try {
            builder.useUnknownPropertyHandler(new EvolvableHandler());
        }
        catch (Throwable t) {
            Logger.warn((String)("Could not add JSON UnknownPropertyHandler " + EvolvableHandler.class + " " + t.getLocalizedMessage()));
        }
        if (!this.f_fCompatibleMode) {
            builder.withConverterFactory(MapConverter.Factory.INSTANCE);
        }
        builder.withConverterFactory(ComparableConverter.Factory.INSTANCE).withConverterFactory(ClassConverter.Factory.INSTANCE).withConverterFactory(EnumConverter.Factory.INSTANCE).withConverterFactory(ThrowableConverter.Factory.INSTANCE).withConverterFactory(factory -> factory.find(NullConverterFactory.class).withNext(new SerializationSupportConverter.Factory(this)).withNext(MissingClassConverter.Factory.INSTANCE));
        if (builderModifier != null) {
            builder = builderModifier.apply(builder);
        }
        this.f_genson = builder.create();
        this.setContextClassLoader(loader);
    }

    public ClassLoader getContextClassLoader() {
        WeakReference<ClassLoader> refLoader = this.m_refLoader;
        return refLoader == null ? null : (ClassLoader)refLoader.get();
    }

    public void setContextClassLoader(ClassLoader classLoader) {
        assert (this.m_refLoader == null);
        if (classLoader != null) {
            this.m_refLoader = new WeakReference<ClassLoader>(classLoader);
            this.f_genson.setLoader(classLoader);
        }
    }

    public void serialize(WriteBuffer.BufferOutput bufferOutput, Object oValue) throws IOException {
        GenericType<Object> type = OBJECT_TYPE;
        if (oValue != null) {
            Class<?> clazz = oValue.getClass();
            if (!SerializationGate.isValid(clazz)) {
                throw new JsonBindingException("Unable to serialize " + clazz.getName());
            }
            for (Class<?> c : JSON_TYPES) {
                if (!c.isInstance(oValue)) continue;
                type = GenericType.of(oValue.getClass());
                break;
            }
        }
        if (DEBUG_MODE) {
            Class<?> cls = oValue == null ? null : oValue.getClass();
            String serialized = this.f_genson.serialize(oValue);
            Base.log((String)("\n-------------------- JSON DEBUG: Serializing -------------------- \nType: " + cls + "\nValue: " + oValue + "\nSerialized Result:\n" + serialized + "\nSerialized Bytes:\n" + Base.toHexDump((byte[])serialized.getBytes(), (int)16) + "\n---------------------------------------------------------------"));
        }
        this.f_genson.serialize(oValue, type, (OutputStream)new WrapperDataOutputStream((DataOutput)bufferOutput));
    }

    public <T> T deserialize(ReadBuffer.BufferInput in, Class<? extends T> clazz) throws IOException {
        if (in.available() == 0) {
            return null;
        }
        if (!SerializationGate.isValid(clazz)) {
            throw new JsonBindingException("Unable to de-serialize " + clazz.getName());
        }
        WrapperDataInputStream stream = new WrapperDataInputStream((DataInput)in);
        if (DEBUG_MODE) {
            byte[] abData = new byte[stream.available()];
            int nRead = stream.read(abData);
            if (nRead == -1) {
                throw new IOException("BufferInput.available() is non-zero, however, no bytes were read");
            }
            if (nRead != abData.length) {
                throw new IOException(String.format("Expected to %s bytes, but only %s were read", abData.length, nRead));
            }
            try {
                T oValue = this.f_genson.deserialize(new String(abData), clazz);
                Class<?> cls = oValue == null ? null : oValue.getClass();
                Base.log((String)("\n-------------------- JSON DEBUG: Deserializing -------------------- \nBytes:\n" + Base.toHexDump((byte[])abData, (int)16) + "\nType: " + cls + "\nValue: " + oValue + "\n---------------------------------------------------------------"));
                return oValue;
            }
            catch (Throwable thrown) {
                Logger.err((String)("JSON DEBUG: Failed to deserialize " + new String(abData)), (Throwable)thrown);
                throw Base.ensureRuntimeException((Throwable)thrown);
            }
        }
        return this.f_genson.deserialize((Reader)new InputStreamReader((InputStream)stream), clazz);
    }

    public <T> T deserialize(String sJson, Class<? extends T> clazz) throws IOException {
        return this.deserialize(sJson.getBytes(StandardCharsets.UTF_8), clazz);
    }

    public <T> T deserialize(byte[] abJson, Class<? extends T> clazz) throws IOException {
        ByteArrayReadBuffer buf = new ByteArrayReadBuffer(abJson);
        return this.deserialize(buf.getBufferInput(), clazz);
    }

    public WriteBuffer serialize(Object o) throws IOException {
        ByteArrayWriteBuffer buf = new ByteArrayWriteBuffer(512);
        this.serialize(buf.getBufferOutput(), o);
        return buf;
    }

    public Genson underlying() {
        return this.f_genson;
    }

    private static void addSafeBundle(GensonBuilder builder, Class<? extends GensonBundle> clz) {
        try {
            GensonBundle bundle = clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            builder.withBundle(bundle);
        }
        catch (Throwable t) {
            Logger.warn((String)("Failed to add Genson bundle: " + clz + " - " + t.getLocalizedMessage()));
        }
    }

    protected static final class BundleProxy
    extends GensonBundle {
        private final String f_sClzName;
        private final String f_sClzGensonBundle;

        private BundleProxy(String sClzGuard, String sClzGensonBundle) {
            this.f_sClzName = sClzGuard;
            this.f_sClzGensonBundle = sClzGensonBundle;
        }

        @Override
        public void configure(GensonBuilder builder) {
            String sClzGensonBundle = this.f_sClzGensonBundle;
            ClassLoader loader = builder.getClassLoader();
            try {
                Class.forName(this.f_sClzName, false, loader);
                try {
                    Class<?> clzGensonBundle = Class.forName(sClzGensonBundle, true, loader);
                    GensonBundle bundle = (GensonBundle)clzGensonBundle.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    bundle.configure(builder);
                }
                catch (Exception e) {
                    throw Base.ensureRuntimeException((Throwable)e, (String)String.format("Unexpected error loading bundle [%s]", sClzGensonBundle));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

