/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.internal;

import java.io.PrintStream;
import java.io.PrintWriter;

public class JsonPortableException
extends RuntimeException {
    protected final String f_sName;
    protected final String f_sMessage;
    protected final String[] f_asStack;

    JsonPortableException(String sName, String sMessage, String[] asStack) {
        if (sName == null) {
            throw new NullPointerException("no name specified");
        }
        if (sName.isEmpty()) {
            throw new IllegalArgumentException("sName is zero-length");
        }
        if (asStack == null) {
            throw new NullPointerException("no stack frames specified");
        }
        if (asStack.length == 0) {
            throw new IllegalArgumentException("asStack has a zero length");
        }
        this.f_sName = sName;
        this.f_sMessage = sMessage;
        this.f_asStack = asStack;
    }

    public String getName() {
        Class<?> clazz = this.getClass();
        String sName = this.f_sName;
        if (sName != null) {
            String sPrefix = "Portable(";
            if (sName.startsWith(sPrefix)) {
                return sName;
            }
            return sPrefix + sName + ")";
        }
        return clazz.getName();
    }

    public String[] getFullStackTrace() {
        int ofLocal;
        String[] asStackFull;
        String[] asStackRemote = this.f_asStack;
        StackTraceElement[] aoStackLocal = this.getStackTrace();
        int cLocal = aoStackLocal.length;
        if (asStackRemote == null) {
            asStackFull = new String[cLocal];
            ofLocal = 0;
        } else {
            int cRemote = asStackRemote.length;
            asStackFull = new String[cRemote + cLocal + 1];
            for (int i = 0; i < cRemote; ++i) {
                asStackFull[i] = "at " + asStackRemote[i];
            }
            asStackFull[cRemote] = "at <process boundary>";
            ofLocal = cRemote + 1;
        }
        for (int i = 0; i < cLocal; ++i) {
            asStackFull[ofLocal + i] = "at " + String.valueOf(aoStackLocal[i]);
        }
        return asStackFull;
    }

    @Override
    public String getMessage() {
        return this.f_sMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream stream) {
        PrintStream printStream = stream;
        synchronized (printStream) {
            PrintWriter pw = new PrintWriter(stream);
            this.printStackTrace(pw);
            pw.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter writer) {
        PrintWriter printWriter = writer;
        synchronized (printWriter) {
            String[] asStackFull;
            writer.println(this);
            for (String s : asStackFull = this.getFullStackTrace()) {
                writer.println("\t" + s);
            }
            Throwable tCause = this.getCause();
            if (tCause != null) {
                writer.print("Caused by: ");
                tCause.printStackTrace(writer);
            }
        }
    }

    @Override
    public String toString() {
        String sPrefix = this.getName();
        String sMessage = this.getMessage();
        return sMessage == null ? sPrefix : sPrefix + ": " + sMessage;
    }
}

