/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.internal;

import com.oracle.coherence.io.json.genson.Context;
import com.oracle.coherence.io.json.genson.Converter;
import com.oracle.coherence.io.json.genson.Genson;
import com.oracle.coherence.io.json.genson.annotation.HandleClassMetadata;
import com.oracle.coherence.io.json.genson.reflect.TypeUtil;
import com.oracle.coherence.io.json.genson.stream.ObjectReader;
import com.oracle.coherence.io.json.genson.stream.ObjectWriter;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

@HandleClassMetadata
public class MapConverter<K, V>
implements Converter<Map<K, V>> {
    protected final Converter<K> f_convKey;
    protected final Converter<V> f_convValue;

    protected MapConverter(Converter<K> convKey, Converter<V> convValue) {
        this.f_convKey = convKey;
        this.f_convValue = convValue;
    }

    @Override
    public void serialize(Map<K, V> object, ObjectWriter writer, Context ctx) throws Exception {
        writer.beginObject();
        boolean isSorted = object instanceof SortedMap;
        boolean isOrdered = object instanceof LinkedHashMap;
        if (isSorted) {
            writer.writeMetadata("sorted", true);
        } else if (isOrdered) {
            writer.writeMetadata("ordered", true);
        }
        writer.writeName("entries").beginArray();
        for (Map.Entry<K, V> entry : object.entrySet()) {
            writer.beginObject().writeName("key");
            this.f_convKey.serialize(entry.getKey(), writer, ctx);
            writer.writeName("value");
            this.f_convValue.serialize(entry.getValue(), writer, ctx);
            writer.endObject();
        }
        writer.endArray().endObject();
    }

    @Override
    public Map<K, V> deserialize(ObjectReader reader, Context ctx) throws Exception {
        Map<Object, Object> map;
        reader.nextObjectMetadata();
        boolean isSorted = (Boolean)reader.metadata().getOrDefault("sorted", false);
        boolean isOrdered = (Boolean)reader.metadata().getOrDefault("ordered", false);
        String className = (String)reader.metadata().getOrDefault("class", MapConverter.getMapTypeBasedOnFlags(isSorted, isOrdered));
        try {
            Class<?> mapClass = ctx.genson.classFor(className);
            map = (Map)mapClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            map = isSorted ? new TreeMap() : (isOrdered ? new LinkedHashMap() : new HashMap());
        }
        reader.next();
        if ("entries".equals(reader.name())) {
            reader.beginArray();
            while (reader.hasNext()) {
                reader.next();
                reader.beginObject();
                Object key = null;
                Object value = null;
                while (reader.hasNext()) {
                    reader.next();
                    if ("key".equals(reader.name())) {
                        key = this.f_convKey.deserialize(reader, ctx);
                        continue;
                    }
                    if (!"value".equals(reader.name())) continue;
                    value = this.f_convValue.deserialize(reader, ctx);
                }
                map.put(key, value);
                reader.endObject();
            }
            reader.endArray();
        }
        reader.endObject();
        return map;
    }

    private static String getMapTypeBasedOnFlags(boolean isSorted, boolean isOrdered) {
        return isSorted ? TreeMap.class.getName() : (isOrdered ? LinkedHashMap.class.getName() : HashMap.class.getName());
    }

    public static class Factory
    implements com.oracle.coherence.io.json.genson.Factory<Converter<? extends Map<?, ?>>> {
        public static final Factory INSTANCE = new Factory();

        protected Factory() {
        }

        @Override
        public Converter<? extends Map<?, ?>> create(Type type, Genson genson) {
            Type expandedType = type;
            if (TypeUtil.getRawClass(type).getTypeParameters().length == 0) {
                expandedType = TypeUtil.expandType(TypeUtil.lookupGenericType(Map.class, TypeUtil.getRawClass(type)), type);
            }
            Type keyType = TypeUtil.typeOf(0, expandedType);
            Type valueType = TypeUtil.typeOf(1, expandedType);
            return new MapConverter(genson.provideConverter(keyType), genson.provideConverter(valueType));
        }
    }
}

