/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson.convert;

import com.oracle.coherence.io.json.genson.Context;
import com.oracle.coherence.io.json.genson.Converter;
import com.oracle.coherence.io.json.genson.Genson;
import com.oracle.coherence.io.json.genson.JsonBindingException;
import com.oracle.coherence.io.json.genson.Wrapper;
import com.oracle.coherence.io.json.genson.annotation.HandleNull;
import com.oracle.coherence.io.json.genson.convert.ChainedFactory;
import com.oracle.coherence.io.json.genson.reflect.TypeUtil;
import com.oracle.coherence.io.json.genson.stream.ObjectReader;
import com.oracle.coherence.io.json.genson.stream.ObjectWriter;
import com.oracle.coherence.io.json.genson.stream.ValueType;
import java.lang.reflect.Type;

public class NullConverterFactory
extends ChainedFactory {
    private final boolean failOnNullPrimitive;

    public NullConverterFactory(boolean failOnNullPrimitive) {
        this.failOnNullPrimitive = failOnNullPrimitive;
    }

    @Override
    protected Converter<?> create(Type type, Genson genson, Converter<?> nextConverter) {
        if (Wrapper.toAnnotatedElement(nextConverter).isAnnotationPresent(HandleNull.class)) {
            return nextConverter;
        }
        Class<?> rawClass = TypeUtil.getRawClass(type);
        if (this.failOnNullPrimitive && rawClass.isPrimitive()) {
            return new FailIfNullConverter(nextConverter);
        }
        return new NullConverterWrapper(genson.defaultValue(rawClass), nextConverter);
    }

    private class NullConverterWrapper<T>
    extends Wrapper<Converter<T>>
    implements Converter<T> {
        private final T defaultValue;

        public NullConverterWrapper(T defaultValue, Converter<T> converter) {
            super(converter);
            this.defaultValue = defaultValue;
        }

        @Override
        public void serialize(T obj, ObjectWriter writer, Context ctx) throws Exception {
            if (obj == null) {
                writer.writeNull();
            } else {
                ((Converter)this.wrapped).serialize(obj, writer, ctx);
            }
        }

        @Override
        public T deserialize(ObjectReader reader, Context ctx) throws Exception {
            if (ValueType.NULL == reader.getValueType()) {
                return this.defaultValue;
            }
            return ((Converter)this.wrapped).deserialize(reader, ctx);
        }
    }

    private class FailIfNullConverter<T>
    extends Wrapper<Converter<T>>
    implements Converter<T> {
        public FailIfNullConverter(Converter<T> delegate) {
            super(delegate);
        }

        @Override
        public void serialize(T object, ObjectWriter writer, Context ctx) throws Exception {
            if (object == null) {
                throw new JsonBindingException("Serialization of null primitives is forbidden");
            }
            ((Converter)this.wrapped).serialize(object, writer, ctx);
        }

        @Override
        public T deserialize(ObjectReader reader, Context ctx) throws Exception {
            if (ValueType.NULL == reader.getValueType()) {
                throw new JsonBindingException("Can not deserialize null to a primitive type");
            }
            return ((Converter)this.wrapped).deserialize(reader, ctx);
        }
    }
}

