/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson.stream;

import com.oracle.coherence.io.json.genson.stream.Base64;
import com.oracle.coherence.io.json.genson.stream.JsonStreamException;
import com.oracle.coherence.io.json.genson.stream.JsonType;
import com.oracle.coherence.io.json.genson.stream.ObjectReader;
import com.oracle.coherence.io.json.genson.stream.ValueType;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

public class JsonReader
implements ObjectReader {
    protected static final int[] SKIPPED_TOKENS;
    private static final boolean[] _NEXT_TOKEN;
    private static final char[] _END_OF_LINE;
    private static final char[] _END_OF_BLOCK_COMMENT;
    private static final int[] sHexValues;
    private static final double[] _POWS;
    private final Reader reader;
    private final boolean strictDoubleParse;
    private final boolean readMetadata;
    private final char[] _buffer = new char[2048];
    private int _col;
    private int _row;
    private int _cursor;
    private int _buflen;
    private char[] _stringBuffer = new char[16];
    private int _stringBufferTail = 0;
    private int _stringBufferLength = this._stringBuffer.length;
    private String currentName;
    private String _stringValue;
    protected long _intValue;
    protected double _doubleValue;
    private int _numberLen = 0;
    private Boolean _booleanValue;
    private ValueType valueType;
    private boolean _first = true;
    private boolean _metadata_readen = false;
    private Map<String, Object> _metadata = new HashMap<String, Object>(5);
    private final Deque<JsonType> _ctx = new ArrayDeque<JsonType>(10);

    public JsonReader(String source) {
        this(new StringReader(source), false, false);
    }

    public JsonReader(Reader reader, boolean strictDoubleParse, boolean readMetadata) {
        this._ctx.push(JsonType.EMPTY);
        this.reader = reader;
        this.strictDoubleParse = strictDoubleParse;
        this.readMetadata = readMetadata;
        char token = (char)this.readNextToken(false);
        if ('[' == token) {
            this.valueType = ValueType.ARRAY;
        } else if ('{' == token) {
            this.valueType = ValueType.OBJECT;
        } else if (this._buflen > 0) {
            try {
                this.valueType = this.consumeValue();
            }
            catch (JsonStreamException jse) {
                this._cursor = -1;
                this._col = -1;
                this._stringValue = this.consumeString(34);
                this.valueType = ValueType.STRING;
            }
            if (ValueType.valueOf(this.valueType.name()) == null) {
                throw new JsonStreamException("Failed to instanciate reader, first character was " + token + " when possible characters are [ and {");
            }
        } else {
            this.valueType = ValueType.NULL;
        }
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new JsonStreamException(e);
        }
    }

    @Override
    public ObjectReader beginArray() {
        this.begin(91, JsonType.ARRAY);
        this.valueType = ValueType.ARRAY;
        if (this._metadata_readen) {
            this._metadata.clear();
        }
        return this;
    }

    @Override
    public ObjectReader beginObject() {
        if (!this._metadata_readen) {
            this.begin(123, JsonType.OBJECT);
            this.valueType = ValueType.OBJECT;
            if (this.readMetadata) {
                this._metadata.clear();
                this.readMetadata();
            }
        }
        return this;
    }

    @Override
    public ObjectReader nextObjectMetadata() {
        return this.beginObject();
    }

    @Override
    public ObjectReader endArray() {
        this.end(93, JsonType.ARRAY);
        return this;
    }

    @Override
    public ObjectReader endObject() {
        this.end(125, JsonType.OBJECT);
        this._metadata.clear();
        this._metadata_readen = false;
        return this;
    }

    @Override
    public String name() {
        if (this.enclosingType() != JsonType.OBJECT) {
            throw new JsonStreamException("Only json objects have names, actual type is " + (Object)((Object)this.valueType));
        }
        return this.currentName;
    }

    @Override
    public String valueAsString() {
        if (ValueType.STRING == this.valueType || ValueType.CHAR == this.valueType) {
            return this._stringValue;
        }
        if (ValueType.INTEGER == this.valueType) {
            return "" + this._intValue;
        }
        if (ValueType.DOUBLE == this.valueType) {
            return "" + this._doubleValue;
        }
        if (ValueType.NULL == this.valueType) {
            return null;
        }
        if (ValueType.BOOLEAN == this.valueType) {
            return this._booleanValue.toString();
        }
        throw new JsonStreamException("Readen value can not be converted to String");
    }

    @Override
    public int valueAsInt() {
        if (ValueType.INTEGER == this.valueType) {
            int value = (int)this._intValue;
            if ((long)value != this._intValue) {
                this.throwNumberFormatException("an int", "overflowing long value " + this._intValue);
            }
            return value;
        }
        if (ValueType.DOUBLE == this.valueType) {
            int value = (int)this._doubleValue;
            long longValue = (long)this._doubleValue;
            if ((long)value != longValue) {
                this.throwNumberFormatException("an int", "overflowing double value " + this._doubleValue);
            }
            return value;
        }
        if (ValueType.STRING == this.valueType) {
            return Integer.parseInt(this._stringValue);
        }
        throw new JsonStreamException("Expected a int but value is of type " + (Object)((Object)this.valueType));
    }

    @Override
    public long valueAsLong() {
        if (ValueType.INTEGER == this.valueType) {
            return this._intValue;
        }
        if (ValueType.DOUBLE == this.valueType) {
            if (-9.223372036854776E18 > this._doubleValue || this._doubleValue > 9.223372036854776E18) {
                this.throwNumberFormatException("a long", "overflowing double value " + this._doubleValue);
            }
            return (long)this._doubleValue;
        }
        if (ValueType.STRING == this.valueType) {
            return Long.parseLong(this._stringValue);
        }
        throw new JsonStreamException("Expected a long but value is of type " + (Object)((Object)this.valueType));
    }

    @Override
    public double valueAsDouble() {
        if (ValueType.DOUBLE == this.valueType) {
            return this._doubleValue;
        }
        if (ValueType.INTEGER == this.valueType) {
            return Long.valueOf(this._intValue).doubleValue();
        }
        if (ValueType.STRING == this.valueType) {
            return Double.parseDouble(this._stringValue);
        }
        throw new JsonStreamException("Expected a double but value is of type " + (Object)((Object)this.valueType));
    }

    @Override
    public short valueAsShort() {
        if (ValueType.INTEGER == this.valueType) {
            short value = (short)this._intValue;
            if ((long)value != this._intValue) {
                this.throwNumberFormatException("a short", "overflowing long value " + this._intValue);
            }
            return value;
        }
        if (ValueType.DOUBLE == this.valueType) {
            short value = (short)this._doubleValue;
            long longValue = (long)this._doubleValue;
            if ((long)value != longValue) {
                this.throwNumberFormatException("a short", "overflowing double value " + this._doubleValue);
            }
            return value;
        }
        if (ValueType.STRING == this.valueType) {
            return Short.parseShort(this._stringValue);
        }
        throw new JsonStreamException("Expected a short but value is of type " + (Object)((Object)this.valueType));
    }

    @Override
    public float valueAsFloat() {
        if (ValueType.DOUBLE == this.valueType) {
            return (float)this._doubleValue;
        }
        if (ValueType.INTEGER == this.valueType) {
            return Long.valueOf(this._intValue).floatValue();
        }
        if (ValueType.STRING == this.valueType) {
            return Float.parseFloat(this._stringValue);
        }
        throw new JsonStreamException("Expected a float but value is of type " + (Object)((Object)this.valueType));
    }

    @Override
    public boolean valueAsBoolean() {
        if (ValueType.BOOLEAN == this.valueType) {
            return this._booleanValue;
        }
        if (ValueType.STRING == this.valueType) {
            return Boolean.parseBoolean(this._stringValue);
        }
        throw new JsonStreamException("Readen value is not of type boolean");
    }

    @Override
    public byte[] valueAsByteArray() {
        if (ValueType.STRING == this.valueType) {
            return Base64.decodeFast(this._stringValue);
        }
        if (ValueType.NULL == this.valueType) {
            return null;
        }
        throw new JsonStreamException("Expected a String to convert to byte array found " + (Object)((Object)this.valueType));
    }

    @Override
    public Map<String, Object> metadata() {
        if (!this._metadata_readen) {
            this.nextObjectMetadata();
        }
        return Collections.unmodifiableMap(this._metadata);
    }

    @Override
    public String metadata(String name) {
        if (!this._metadata_readen) {
            this.nextObjectMetadata();
        }
        return (String)this._metadata.get(name);
    }

    @Override
    public Long metadataAsLong(String name) {
        if (!this._metadata_readen) {
            this.nextObjectMetadata();
        }
        return (Long)this._metadata.get(name);
    }

    @Override
    public Boolean metadataAsBoolean(String name) {
        if (!this._metadata_readen) {
            this.nextObjectMetadata();
        }
        return (Boolean)this._metadata.get(name);
    }

    @Override
    public ValueType getValueType() {
        return this.valueType;
    }

    @Override
    public ObjectReader skipValue() {
        if (ValueType.ARRAY == this.valueType || ValueType.OBJECT == this.valueType) {
            int balance = 0;
            do {
                if (ValueType.ARRAY == this.valueType) {
                    this.beginArray();
                    ++balance;
                } else if (ValueType.OBJECT == this.valueType) {
                    this.beginObject();
                    ++balance;
                }
                while (this.hasNext()) {
                    this.next();
                    this.skipValue();
                }
                JsonType type = this._ctx.peek();
                if (JsonType.ARRAY == type) {
                    this.endArray();
                    --balance;
                    continue;
                }
                if (JsonType.OBJECT != type) continue;
                this.endObject();
                --balance;
            } while (balance > 0);
        }
        return this;
    }

    @Override
    public boolean hasNext() {
        int token = this.readNextToken(false);
        if (token == -1) {
            return false;
        }
        if (token < 128) {
            if (this._first || this._ctx.size() == 1) {
                return _NEXT_TOKEN[token];
            }
            if (token == 44) {
                return true;
            }
        }
        return false;
    }

    @Override
    public ValueType next() {
        this._metadata_readen = false;
        this._first = false;
        this.valueType = null;
        char ctoken = (char)this.readNextToken(false);
        if (ctoken == ',') {
            ++this._cursor;
            ctoken = (char)this.readNextToken(false);
        } else if (JsonType.ARRAY == this._ctx.peek()) {
            if (ctoken == '[') {
                this.valueType = ValueType.ARRAY;
                return this.valueType;
            }
            if (ctoken == '{') {
                this.valueType = ValueType.OBJECT;
                return this.valueType;
            }
        }
        if (JsonType.OBJECT == this._ctx.peek()) {
            this.currentName = this.consumeString(ctoken);
            if (this.readNextToken(true) != 58) {
                this.newWrongTokenException(":", this._cursor - 1);
            }
        }
        this.valueType = this.consumeValue();
        return this.valueType;
    }

    @Override
    public JsonType enclosingType() {
        return this._ctx.peek();
    }

    protected final ValueType consumeValue() {
        char ctoken = (char)this.readNextToken(false);
        if (ctoken == '\"') {
            this._stringValue = this.consumeString(ctoken);
            return this.valueType == ValueType.CHAR && this._stringValue.length() == 1 ? ValueType.CHAR : ValueType.STRING;
        }
        if (ctoken == '[') {
            return ValueType.ARRAY;
        }
        if (ctoken == '{') {
            return ValueType.OBJECT;
        }
        return this.consumeLiteral();
    }

    protected final void readMetadata() {
        this._metadata_readen = true;
        while (true) {
            char ctoken;
            if ('\"' != (ctoken = (char)this.readNextToken(false))) {
                return;
            }
            this.ensureBufferHas(2, true);
            if ('@' != this._buffer[this._cursor + 1]) break;
            ++this._cursor;
            String key = this.consumeString(ctoken);
            if (this.readNextToken(true) != 58) {
                this.newWrongTokenException(":", this._cursor - 1);
            }
            if ((ctoken = (char)this.readNextToken(false)) == '\"') {
                String value = this.consumeString((char)this.readNextToken(false));
                this._metadata.put(key, value);
            } else {
                ValueType valueType = this.consumeLiteral();
                if (valueType == ValueType.BOOLEAN) {
                    this._metadata.put(key, this._booleanValue);
                } else if (valueType == ValueType.INTEGER) {
                    this._metadata.put(key, this._intValue);
                }
            }
            if (this.readNextToken(false) != 44) continue;
            ++this._cursor;
        }
    }

    protected final void begin(int character, JsonType type) {
        int token = this.readNextToken(true);
        if (character == token) {
            this._ctx.push(type);
        } else {
            this.newWrongTokenException("" + (char)character, this._cursor - 1);
        }
        this._first = true;
    }

    protected final void end(int character, JsonType type) {
        int token = this.readNextToken(true);
        if (character == token && type == this._ctx.peek()) {
            this._ctx.pop();
        } else {
            this.newWrongTokenException("" + (char)character, this._cursor - 1);
        }
        this._first = false;
    }

    protected final String consumeString(int token) {
        if (token != 34) {
            this.newMisplacedTokenException(this._cursor);
        }
        ++this._cursor;
        boolean buffered = false;
        while (true) {
            if (this.fillBuffer(true) < 0) {
                String name = new String(this._stringBuffer, 0, this._stringBufferTail);
                this._stringBufferTail = 0;
                return name;
            }
            int i = this._cursor;
            while (i < this._buflen) {
                if (this._buffer[i] == '\"') {
                    if (buffered) {
                        this.writeToStringBuffer(this._buffer, this._cursor, i - this._cursor);
                        this._cursor = i + 1;
                        String name = new String(this._stringBuffer, 0, this._stringBufferTail);
                        this._stringBufferTail = 0;
                        return name;
                    }
                    String name = new String(this._buffer, this._cursor, i - this._cursor);
                    this._cursor = i + 1;
                    return name;
                }
                if (this._buffer[i] == '\\') {
                    buffered = true;
                    this.writeToStringBuffer(this._buffer, this._cursor, i - this._cursor);
                    this._cursor = i + 1;
                    if (this._stringBufferLength <= this._stringBufferTail + 1) {
                        this.expandStringBuffer(16);
                    }
                    this._stringBuffer[this._stringBufferTail++] = this.readEscaped();
                    i = this._cursor;
                    continue;
                }
                ++i;
            }
            buffered = true;
            this.writeToStringBuffer(this._buffer, this._cursor, i - this._cursor);
            this._cursor = i + 1;
        }
    }

    protected final ValueType consumeLiteral() {
        char token = this._buffer[this._cursor];
        if (token > '/' && token < ':' || token == '-') {
            return this.consumeNumber();
        }
        this.ensureBufferHas(4, true);
        if (!(this._buffer[this._cursor] != 'N' && this._buffer[this._cursor] != 'n' || this._buffer[this._cursor + 1] != 'U' && this._buffer[this._cursor + 1] != 'u' || this._buffer[this._cursor + 2] != 'L' && this._buffer[this._cursor + 2] != 'l' || this._buffer[this._cursor + 3] != 'L' && this._buffer[this._cursor + 3] != 'l')) {
            this._cursor += 4;
            return ValueType.NULL;
        }
        if (!(this._buffer[this._cursor] != 'T' && this._buffer[this._cursor] != 't' || this._buffer[this._cursor + 1] != 'R' && this._buffer[this._cursor + 1] != 'r' || this._buffer[this._cursor + 2] != 'U' && this._buffer[this._cursor + 2] != 'u' || this._buffer[this._cursor + 3] != 'E' && this._buffer[this._cursor + 3] != 'e')) {
            this._booleanValue = true;
            this._cursor += 4;
            return ValueType.BOOLEAN;
        }
        this.ensureBufferHas(5, true);
        if (!(this._buffer[this._cursor] != 'F' && this._buffer[this._cursor] != 'f' || this._buffer[this._cursor + 1] != 'A' && this._buffer[this._cursor + 1] != 'a' || this._buffer[this._cursor + 2] != 'L' && this._buffer[this._cursor + 2] != 'l' || this._buffer[this._cursor + 3] != 'S' && this._buffer[this._cursor + 3] != 's' || this._buffer[this._cursor + 4] != 'E' && this._buffer[this._cursor + 4] != 'e')) {
            this._booleanValue = false;
            this._cursor += 5;
            return ValueType.BOOLEAN;
        }
        throw new JsonStreamException.Builder().message("Illegal character around row " + this._row + " and column " + (this._cursor - this._col) + " awaited for literal (number, boolean or null) but read '" + this._buffer[this._cursor] + "'!").create();
    }

    private ValueType consumeNumber() {
        char token;
        int cur;
        boolean negative;
        if (this._buflen - this._cursor < 378) {
            this.ensureBufferHas(this._buflen, false);
        }
        int begin = this._cursor;
        if (this._buffer[this._cursor] == '-') {
            negative = true;
            ++this._cursor;
            cur = this._cursor;
        } else {
            negative = false;
            cur = this._cursor;
        }
        while (cur < this._buflen && this._buffer[cur] == '0') {
            ++cur;
        }
        this._cursor = cur;
        int len = Math.min(this._buflen, cur + 18);
        long longValue = 0L;
        while (cur < len && (token = this._buffer[cur]) >= '0' && token <= '9') {
            longValue = 10L * longValue + (long)(token - 48);
            ++cur;
        }
        if (cur < this._buflen) {
            long newLongValue;
            token = this._buffer[cur];
            if (token > '/' && token < ':' && (newLongValue = 10L * longValue + (long)(token - 48)) > longValue) {
                longValue = newLongValue;
                ++cur;
            }
            if (cur < this._buflen && ((token = this._buffer[cur]) == '.' || token == 'e' || token == 'E' || token > '/' && token < ':')) {
                if (this.strictDoubleParse) {
                    this._cursor = begin;
                    return this.consumeStrictNumber(cur);
                }
                return this.consumeDouble(cur, longValue, negative);
            }
        }
        this._intValue = negative ? -longValue : longValue;
        this._numberLen = cur - this._cursor;
        this._cursor = cur;
        return ValueType.INTEGER;
    }

    private ValueType consumeDouble(int cur, long longValue, boolean negative) {
        char token;
        int valueDigits;
        int intDigits = cur - this._cursor;
        int n = valueDigits = longValue > 0L ? cur - this._cursor : 0;
        if (intDigits > 17) {
            while (cur < this._buflen && this._buffer[cur] >= '0' && this._buffer[cur] <= '9') {
                ++cur;
            }
            if (intDigits != cur - this._cursor) {
                intDigits = cur - this._cursor - intDigits;
            }
        } else {
            intDigits = 0;
        }
        int decimalDigits = 0;
        if (cur < this._buflen && this._buffer[cur] == '.') {
            int start = ++cur;
            if (longValue == 0L) {
                intDigits = 0;
                while (cur < this._buflen && this._buffer[cur] == '0') {
                    ++cur;
                }
            }
            int len = Math.min(this._buflen, cur + (18 - valueDigits));
            while (cur < len && (token = this._buffer[cur]) >= '0' && token <= '9') {
                longValue = 10L * longValue + (long)(token - 48);
                ++cur;
            }
            decimalDigits = cur - start;
            start = cur;
            while (cur < this._buflen && this._buffer[cur] >= '0' && this._buffer[cur] <= '9') {
                ++cur;
            }
        }
        if (cur + 1 < this._buflen && (this._buffer[cur] == 'e' || this._buffer[cur] == 'E')) {
            boolean negativeExp;
            if ((token = this._buffer[++cur]) == '-') {
                negativeExp = true;
                ++cur;
            } else {
                if (token == '+') {
                    ++cur;
                }
                negativeExp = false;
            }
            int powValue = 0;
            while (cur < this._buflen && (token = this._buffer[cur]) >= '0' && token <= '9') {
                powValue = 10 * powValue + (token - 48);
                ++cur;
            }
            if (negativeExp) {
                decimalDigits += powValue;
            } else {
                intDigits += powValue;
            }
        }
        if ((decimalDigits = intDigits - decimalDigits) < 0) {
            if (decimalDigits < -308) {
                if (decimalDigits < -325) {
                    this._doubleValue = 0.0;
                } else {
                    this._doubleValue = (double)longValue / _POWS[-decimalDigits - 308];
                    this._doubleValue /= _POWS[308];
                }
            } else {
                this._doubleValue = (double)longValue / _POWS[-decimalDigits];
            }
        } else {
            this._doubleValue = decimalDigits > 308 ? Double.POSITIVE_INFINITY : (double)longValue * _POWS[decimalDigits];
        }
        this._doubleValue = negative ? -this._doubleValue : this._doubleValue;
        this._numberLen = cur - this._cursor;
        this._cursor = cur;
        return ValueType.DOUBLE;
    }

    private final ValueType consumeStrictNumber(int localCursor) {
        char ctoken;
        if (localCursor < this._buflen) {
            while (localCursor < this._buflen && this._buffer[localCursor] >= '0' && this._buffer[localCursor] <= '9') {
                ++localCursor;
            }
        }
        if (localCursor < this._buflen && this._buffer[localCursor] == '.') {
            ++localCursor;
            localCursor = this.advanceWhileNumeric(localCursor);
        }
        if (localCursor + 1 < this._buflen && ((ctoken = this._buffer[localCursor]) == 'e' || ctoken == 'E')) {
            if ((ctoken = this._buffer[++localCursor]) == '-' || ctoken == '+' || ctoken > '/' && ctoken < ':') {
                ++localCursor;
                localCursor = this.advanceWhileNumeric(localCursor);
            } else {
                this.newWrongTokenException("'-' or '+' or '' (same as +)");
            }
        }
        if (localCursor >= this._buflen) {
            // empty if block
        }
        this._numberLen = localCursor - this._cursor;
        this._stringValue = new String(this._buffer, this._cursor, this._numberLen);
        this._doubleValue = Double.parseDouble(this._stringValue);
        this._cursor = localCursor;
        return ValueType.DOUBLE;
    }

    private int advanceWhileNumeric(int cursor) {
        while (cursor < this._buflen) {
            if (this._buffer[cursor] < '0' || this._buffer[cursor] > '9') {
                return cursor;
            }
            ++cursor;
        }
        return cursor;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final int readNextToken(boolean consume) {
        do {
            if (this._cursor >= this._buflen) {
                this.fillBuffer(true);
            }
            while (this._cursor < this._buflen) {
                char token = this._buffer[this._cursor];
                if (token < '\u0080' && SKIPPED_TOKENS[token] == 0) {
                    if (token != '/') {
                        if (!consume) return token;
                        return this._buffer[this._cursor++];
                    }
                    this.ensureBufferHas(2, true);
                    if (this._buffer[this._cursor + 1] == '*') {
                        this._cursor += 2;
                        this.advanceAfter(_END_OF_BLOCK_COMMENT);
                    } else if (this._buffer[this._cursor + 1] == '/') {
                        this._cursor += 2;
                        this.advanceAfter(_END_OF_LINE);
                        ++this._row;
                        this._col = this._cursor;
                    } else {
                        this.newWrongTokenException("start comment // or /*", this._cursor);
                    }
                    --this._cursor;
                } else if (this._buffer[this._cursor] == '\n') {
                    ++this._row;
                    this._col = this._cursor;
                }
                ++this._cursor;
            }
        } while (this._buflen != -1);
        if (this._cursor >= this._buflen) return -1;
        int n = this._buffer[this._cursor];
        return n;
    }

    private final void advanceAfter(char[] str) {
        int strPos = 0;
        do {
            if (this._cursor >= this._buflen) {
                this.fillBuffer(true);
            }
            while (this._cursor < this._buflen && strPos < str.length) {
                strPos = this._buffer[this._cursor] == str[strPos] ? ++strPos : 0;
                ++this._cursor;
            }
            if (strPos != str.length) continue;
            return;
        } while (this._buflen != -1);
    }

    protected final char readEscaped() {
        this.fillBuffer(true);
        char token = this._buffer[this._cursor++];
        switch (token) {
            case 'b': {
                return '\b';
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'f': {
                return '\f';
            }
            case 'r': {
                return '\r';
            }
            case '\"': 
            case '/': 
            case '\\': {
                return token;
            }
            case 'u': {
                this.valueType = ValueType.CHAR;
                break;
            }
            default: {
                this.newMisplacedTokenException(this._cursor - 1);
            }
        }
        int value = 0;
        if (this.ensureBufferHas(4, false) < 0) {
            throw new JsonStreamException("Expected 4 hex-digit for character escape sequence!");
        }
        for (int i = 0; i < 4; ++i) {
            char ch;
            int digit;
            int n = digit = (ch = this._buffer[this._cursor++]) > '\u007f' ? -1 : sHexValues[ch];
            if (digit < 0) {
                throw new JsonStreamException("Wrong character '" + ch + "' expected a hex-digit for character escape sequence!");
            }
            value = value << 4 | digit;
        }
        return (char)value;
    }

    private final void writeToStringBuffer(char[] data, int offset, int length) {
        if (this._stringBufferLength <= this._stringBufferTail + length) {
            this.expandStringBuffer(length);
        }
        System.arraycopy(data, offset, this._stringBuffer, this._stringBufferTail, length);
        this._stringBufferTail += length;
    }

    private final void expandStringBuffer(int length) {
        char[] extendedStringBuffer = new char[this._stringBufferLength * 2 + length];
        System.arraycopy(this._stringBuffer, 0, extendedStringBuffer, 0, this._stringBufferTail);
        this._stringBuffer = extendedStringBuffer;
        this._stringBufferLength = extendedStringBuffer.length;
    }

    private final int fillBuffer(boolean doThrow) {
        if (this._cursor < this._buflen) {
            return this._buflen;
        }
        try {
            this._buflen = this.reader.read(this._buffer);
        }
        catch (IOException ioe) {
            throw new JsonStreamException(ioe);
        }
        this.checkIllegalEnd(this._buflen);
        this._cursor = 0;
        this._col = 0;
        return this._buflen;
    }

    private final int ensureBufferHas(int minLength, boolean doThrow) {
        try {
            int len;
            int actualLen;
            if (actualLen >= minLength) {
                return actualLen;
            }
            System.arraycopy(this._buffer, this._cursor, this._buffer, 0, actualLen);
            for (actualLen = this._buflen - this._cursor; actualLen < minLength; actualLen += len) {
                len = this.reader.read(this._buffer, actualLen, this._buffer.length - actualLen);
                if (len >= 0) continue;
                if (doThrow) {
                    throw new JsonStreamException("Encountered end of stream, incomplete json!");
                }
                this._buflen = actualLen;
                this._col = 0;
                this._cursor = 0;
                return len;
            }
            this._buflen = actualLen;
            this._col = 0;
            this._cursor = 0;
            return actualLen;
        }
        catch (IOException ioe) {
            throw new JsonStreamException(ioe);
        }
    }

    protected final boolean isEOF() {
        return this._buflen < 0 || this.fillBuffer(false) < 0;
    }

    private final void newWrongTokenException(String awaited) {
        this.newWrongTokenException(awaited, this._cursor);
    }

    @Override
    public int column() {
        int col = this._cursor - this._col;
        return col < 0 ? 0 : col;
    }

    @Override
    public int row() {
        return this._row;
    }

    private final void newWrongTokenException(String awaited, int cursor) {
        int pos;
        if (cursor < 0) {
            cursor = 0;
        }
        if ((pos = cursor - this._col) < 0) {
            pos = 0;
        }
        if (this._buflen < 0) {
            throw new JsonStreamException("Incomplete data or malformed json : encoutered end of stream but expected " + awaited).niceTrace();
        }
        throw new JsonStreamException.Builder().message("Illegal character at row " + this._row + " and column " + pos + " expected " + awaited + " but read '" + this._buffer[cursor] + "' !").locate(this._row, pos).create().niceTrace();
    }

    private final void newMisplacedTokenException(int cursor) {
        int pos;
        if (this._buflen < 0) {
            throw JsonStreamException.niceTrace(new JsonStreamException("Incomplete data or malformed json : encoutered end of stream."));
        }
        if (cursor < 0) {
            cursor = 0;
        }
        if ((pos = cursor - this._col) < 0) {
            pos = 0;
        }
        throw new JsonStreamException.Builder().message("Encountred misplaced character '" + this._buffer[cursor] + "' around row " + this._row + " and column " + pos).locate(this._row, pos).create().niceTrace();
    }

    private final void checkIllegalEnd(int token) {
        if (token == -1 && JsonType.EMPTY != this._ctx.peek()) {
            throw new JsonStreamException("Incomplete data or malformed json : encoutered end of stream!").niceTrace();
        }
    }

    private void throwNumberFormatException(String expected, String encoutered) {
        int pos = this._cursor - this._col - this._numberLen;
        throw JsonStreamException.niceTrace(new NumberFormatException("Wrong numeric type at row " + this._row + " and column " + pos + ", expected " + expected + " but encoutered " + encoutered));
    }

    static {
        int i;
        SKIPPED_TOKENS = new int[128];
        JsonReader.SKIPPED_TOKENS[9] = 1;
        JsonReader.SKIPPED_TOKENS[8] = 1;
        JsonReader.SKIPPED_TOKENS[10] = 1;
        JsonReader.SKIPPED_TOKENS[13] = 1;
        JsonReader.SKIPPED_TOKENS[12] = 1;
        JsonReader.SKIPPED_TOKENS[32] = 1;
        _NEXT_TOKEN = new boolean[128];
        JsonReader._NEXT_TOKEN[44] = true;
        JsonReader._NEXT_TOKEN[34] = true;
        JsonReader._NEXT_TOKEN[123] = true;
        JsonReader._NEXT_TOKEN[91] = true;
        JsonReader._NEXT_TOKEN[110] = true;
        JsonReader._NEXT_TOKEN[78] = true;
        JsonReader._NEXT_TOKEN[45] = true;
        JsonReader._NEXT_TOKEN[116] = true;
        JsonReader._NEXT_TOKEN[102] = true;
        JsonReader._NEXT_TOKEN[84] = true;
        JsonReader._NEXT_TOKEN[70] = true;
        for (i = 48; i < 58; ++i) {
            JsonReader._NEXT_TOKEN[i] = true;
        }
        _END_OF_LINE = new char[]{'\n'};
        _END_OF_BLOCK_COMMENT = new char[]{'*', '/'};
        sHexValues = new int[128];
        Arrays.fill(sHexValues, -1);
        for (i = 0; i < 10; ++i) {
            JsonReader.sHexValues[48 + i] = i;
        }
        for (i = 0; i < 6; ++i) {
            JsonReader.sHexValues[97 + i] = 10 + i;
            JsonReader.sHexValues[65 + i] = 10 + i;
        }
        _POWS = new double[309];
        for (i = 0; i < _POWS.length; ++i) {
            JsonReader._POWS[i] = Math.pow(10.0, i);
        }
    }
}

