/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson;

import com.oracle.coherence.io.json.genson.BeanView;
import com.oracle.coherence.io.json.genson.Converter;
import com.oracle.coherence.io.json.genson.Deserializer;
import com.oracle.coherence.io.json.genson.Factory;
import com.oracle.coherence.io.json.genson.GenericType;
import com.oracle.coherence.io.json.genson.Genson;
import com.oracle.coherence.io.json.genson.Modifier;
import com.oracle.coherence.io.json.genson.Serializer;
import com.oracle.coherence.io.json.genson.convert.BasicConvertersFactory;
import com.oracle.coherence.io.json.genson.convert.BeanViewConverter;
import com.oracle.coherence.io.json.genson.convert.ChainedFactory;
import com.oracle.coherence.io.json.genson.convert.CircularClassReferenceConverterFactory;
import com.oracle.coherence.io.json.genson.convert.ClassMetadataConverter;
import com.oracle.coherence.io.json.genson.convert.ContextualFactory;
import com.oracle.coherence.io.json.genson.convert.DefaultConverters;
import com.oracle.coherence.io.json.genson.convert.NullConverterFactory;
import com.oracle.coherence.io.json.genson.convert.RuntimeTypeConverter;
import com.oracle.coherence.io.json.genson.ext.GensonBundle;
import com.oracle.coherence.io.json.genson.reflect.ASMCreatorParameterNameResolver;
import com.oracle.coherence.io.json.genson.reflect.AbstractBeanDescriptorProvider;
import com.oracle.coherence.io.json.genson.reflect.BaseBeanDescriptorProvider;
import com.oracle.coherence.io.json.genson.reflect.BeanDescriptorProvider;
import com.oracle.coherence.io.json.genson.reflect.BeanMutatorAccessorResolver;
import com.oracle.coherence.io.json.genson.reflect.BeanPropertyFactory;
import com.oracle.coherence.io.json.genson.reflect.BeanViewDescriptorProvider;
import com.oracle.coherence.io.json.genson.reflect.DefaultTypes;
import com.oracle.coherence.io.json.genson.reflect.PropertyFilter;
import com.oracle.coherence.io.json.genson.reflect.PropertyNameResolver;
import com.oracle.coherence.io.json.genson.reflect.RenamingPropertyNameResolver;
import com.oracle.coherence.io.json.genson.reflect.RuntimePropertyFilter;
import com.oracle.coherence.io.json.genson.reflect.TypeUtil;
import com.oracle.coherence.io.json.genson.reflect.UnknownPropertyHandler;
import com.oracle.coherence.io.json.genson.reflect.VisibilityFilter;
import com.oracle.coherence.io.json.genson.stream.ValueType;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GensonBuilder {
    private final DefaultTypes defaultTypes = new DefaultTypes();
    private final Map<Type, Serializer<?>> serializersMap = new HashMap();
    private final Map<Type, Deserializer<?>> deserializersMap = new HashMap();
    private final List<Factory<?>> converterFactories = new ArrayList();
    private final List<ContextualFactory<?>> contextualFactories = new ArrayList();
    private final List<BeanPropertyFactory> beanPropertyFactories = new ArrayList<BeanPropertyFactory>();
    private boolean skipNull = false;
    private boolean htmlSafe = false;
    private boolean withClassMetadata = false;
    private boolean throwExcOnNoDebugInfo = false;
    private boolean useGettersAndSetters = true;
    private boolean useFields = true;
    private boolean withBeanViewConverter = false;
    private boolean useRuntimeTypeForSerialization = false;
    private boolean withDebugInfoPropertyNameResolver = false;
    private boolean strictDoubleParse = false;
    private boolean indent = false;
    private boolean metadata = false;
    private boolean failOnMissingProperty = false;
    private boolean enforceTypeAliases = false;
    private List<GensonBundle> _bundles = new ArrayList<GensonBundle>();
    private PropertyNameResolver propertyNameResolver;
    private List<PropertyNameResolver> propertyNameResolvers = new ArrayList<PropertyNameResolver>();
    private List<PropertyNameResolver> renamingResolvers = new ArrayList<PropertyNameResolver>();
    private BeanMutatorAccessorResolver mutatorAccessorResolver;
    private List<BeanMutatorAccessorResolver> mutatorAccessorResolvers = new ArrayList<BeanMutatorAccessorResolver>();
    private List<BeanMutatorAccessorResolver> propertyFilters = new ArrayList<BeanMutatorAccessorResolver>();
    private VisibilityFilter propertyFilter = VisibilityFilter.PACKAGE_PUBLIC;
    private VisibilityFilter methodFilter = VisibilityFilter.PACKAGE_PUBLIC;
    private VisibilityFilter constructorFilter = VisibilityFilter.PACKAGE_PUBLIC;
    private ClassLoader classLoader = this.getClass().getClassLoader();
    private BeanDescriptorProvider beanDescriptorProvider;
    private DateFormat dateFormat = SimpleDateFormat.getDateTimeInstance();
    private boolean useDateAsTimestamp = true;
    private boolean classMetadataWithStaticType = true;
    private BeanViewDescriptorProvider beanViewDescriptorProvider;
    private final Map<String, Class<?>> withClassAliases = new HashMap();
    private final Map<String, String> compatibilityAliases = new HashMap<String, String>();
    private final Map<String, String> withPackageAliases = new HashMap<String, String>();
    private final Map<Class<?>, BeanView<?>> registeredViews = new HashMap();
    private ChainedFactory customFactoryChain;
    private Modifier<ChainedFactory> chainedFactoryModifier;
    private final Map<Class<?>, Object> defaultValues = new HashMap();
    private boolean failOnNullPrimitive = false;
    private RuntimePropertyFilter runtimePropertyFilter = RuntimePropertyFilter.noFilter;
    private UnknownPropertyHandler unknownPropertyHandler;

    public GensonBuilder() {
        this.defaultValues.put(Integer.TYPE, 0);
        this.defaultValues.put(Long.TYPE, 0L);
        this.defaultValues.put(Short.TYPE, (short)0);
        this.defaultValues.put(Double.TYPE, 0.0);
        this.defaultValues.put(Float.TYPE, Float.valueOf(0.0f));
        this.defaultValues.put(Boolean.TYPE, false);
        this.defaultValues.put(Byte.TYPE, (byte)0);
        this.defaultValues.put(Character.TYPE, Character.valueOf('\u0000'));
    }

    public GensonBuilder setDefaultType(ValueType type, Class<?> clazz) {
        this.defaultTypes.setClass(type, clazz);
        return this;
    }

    public GensonBuilder addAlias(String alias, Class<?> forClass) {
        if (this.withClassAliases.containsKey(alias)) {
            throw new IllegalArgumentException(String.format("Alias %s already defined for type %s", alias, this.withClassAliases.get(alias).getName()));
        }
        this.withClassMetadata = true;
        this.withClassAliases.put(alias, forClass);
        return this;
    }

    public GensonBuilder addCompatibilityAlias(String alias, String aliasFor) {
        if (this.compatibilityAliases.containsKey(alias)) {
            throw new IllegalArgumentException(String.format("Alias %s already defined for alias %s", alias, this.compatibilityAliases.get(alias)));
        }
        this.withClassMetadata = true;
        this.compatibilityAliases.put(alias, aliasFor);
        return this;
    }

    public GensonBuilder addPackageAlias(String alias, String forPackage) {
        if (this.withPackageAliases.containsKey(alias)) {
            throw new IllegalArgumentException(String.format("Alias %s already defined for package %s", alias, this.withPackageAliases.get(alias)));
        }
        this.withClassMetadata = true;
        this.withPackageAliases.put(alias, forPackage);
        return this;
    }

    public GensonBuilder withConverters(Converter<?> ... converter) {
        for (Converter<?> c : converter) {
            Type typeOfConverter = TypeUtil.typeOf(0, TypeUtil.lookupGenericType(Converter.class, c.getClass()));
            typeOfConverter = TypeUtil.expandType(typeOfConverter, c.getClass());
            this.registerConverter(c, typeOfConverter);
        }
        return this;
    }

    public <T> GensonBuilder withConverter(Converter<T> converter, Class<? extends T> type) {
        this.registerConverter(converter, type);
        return this;
    }

    public <T> GensonBuilder withConverter(Converter<T> converter, GenericType<? extends T> type) {
        this.registerConverter(converter, type.getType());
        return this;
    }

    private <T> void registerConverter(Converter<T> converter, Type type) {
        if (this.serializersMap.containsKey(type)) {
            throw new IllegalStateException("Can not register converter " + String.valueOf(converter.getClass()) + ". A custom serializer is already registered for type " + String.valueOf(type));
        }
        if (this.deserializersMap.containsKey(type)) {
            throw new IllegalStateException("Can not register converter " + String.valueOf(converter.getClass()) + ". A custom deserializer is already registered for type " + String.valueOf(type));
        }
        this.serializersMap.put(type, converter);
        this.deserializersMap.put(type, converter);
    }

    public GensonBuilder withSerializers(Serializer<?> ... serializer) {
        for (Serializer<?> s : serializer) {
            Type typeOfConverter = TypeUtil.typeOf(0, TypeUtil.lookupGenericType(Serializer.class, s.getClass()));
            typeOfConverter = TypeUtil.expandType(typeOfConverter, s.getClass());
            this.registerSerializer(s, typeOfConverter);
        }
        return this;
    }

    public <T> GensonBuilder withSerializer(Serializer<T> serializer, Class<? extends T> type) {
        this.registerSerializer(serializer, type);
        return this;
    }

    public <T> GensonBuilder withSerializer(Serializer<T> serializer, GenericType<? extends T> type) {
        this.registerSerializer(serializer, type.getType());
        return this;
    }

    private <T> void registerSerializer(Serializer<T> serializer, Type type) {
        if (this.serializersMap.containsKey(type)) {
            throw new IllegalStateException("Can not register serializer " + String.valueOf(serializer.getClass()) + ". A custom serializer is already registered for type " + String.valueOf(type));
        }
        this.serializersMap.put(type, serializer);
    }

    public GensonBuilder withDeserializers(Deserializer<?> ... deserializer) {
        for (Deserializer<?> d : deserializer) {
            Type typeOfConverter = TypeUtil.typeOf(0, TypeUtil.lookupGenericType(Deserializer.class, d.getClass()));
            typeOfConverter = TypeUtil.expandType(typeOfConverter, d.getClass());
            this.registerDeserializer(d, typeOfConverter);
        }
        return this;
    }

    public <T> GensonBuilder withDeserializer(Deserializer<T> deserializer, Class<? extends T> type) {
        this.registerDeserializer(deserializer, type);
        return this;
    }

    public <T> GensonBuilder withDeserializer(Deserializer<T> deserializer, GenericType<? extends T> type) {
        this.registerDeserializer(deserializer, type.getType());
        return this;
    }

    private <T> void registerDeserializer(Deserializer<T> deserializer, Type type) {
        if (this.deserializersMap.containsKey(type)) {
            throw new IllegalStateException("Can not register deserializer " + String.valueOf(deserializer.getClass()) + ". A custom deserializer is already registered for type " + String.valueOf(type));
        }
        this.deserializersMap.put(type, deserializer);
    }

    public GensonBuilder withConverterFactory(Factory<? extends Converter<?>> factory) {
        this.converterFactories.add(factory);
        return this;
    }

    public GensonBuilder withSerializerFactory(Factory<? extends Serializer<?>> factory) {
        this.converterFactories.add(factory);
        return this;
    }

    public GensonBuilder withDeserializerFactory(Factory<? extends Deserializer<?>> factory) {
        this.converterFactories.add(factory);
        return this;
    }

    public GensonBuilder withContextualFactory(ContextualFactory<?> ... factories) {
        this.contextualFactories.addAll(Arrays.asList(factories));
        return this;
    }

    public GensonBuilder withConverterFactory(ChainedFactory chainedFactory) {
        if (this.customFactoryChain == null) {
            this.customFactoryChain = chainedFactory;
        } else {
            this.customFactoryChain.append(chainedFactory);
        }
        return this;
    }

    public GensonBuilder withConverterFactory(Modifier<ChainedFactory> modifier) {
        this.chainedFactoryModifier = modifier;
        return this;
    }

    public GensonBuilder withBeanPropertyFactory(BeanPropertyFactory ... factories) {
        this.beanPropertyFactories.addAll(Arrays.asList(factories));
        return this;
    }

    public GensonBuilder withBundle(GensonBundle ... bundles) {
        for (GensonBundle bundle : bundles) {
            bundle.configure(this);
            this._bundles.add(bundle);
        }
        return this;
    }

    public GensonBuilder withClassLoader(ClassLoader loader) {
        this.classLoader = loader;
        return this;
    }

    public GensonBuilder set(BeanMutatorAccessorResolver resolver) {
        this.mutatorAccessorResolver = resolver;
        return this;
    }

    public GensonBuilder set(PropertyNameResolver resolver) {
        this.propertyNameResolver = resolver;
        return this;
    }

    public GensonBuilder with(BeanMutatorAccessorResolver ... resolvers) {
        this.mutatorAccessorResolvers.addAll(Arrays.asList(resolvers));
        return this;
    }

    public Map<Type, Serializer<?>> getSerializersMap() {
        return Collections.unmodifiableMap(this.serializersMap);
    }

    public Map<Type, Deserializer<?>> getDeserializersMap() {
        return Collections.unmodifiableMap(this.deserializersMap);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public GensonBuilder with(PropertyNameResolver ... resolvers) {
        this.propertyNameResolvers.addAll(Arrays.asList(resolvers));
        return this;
    }

    public GensonBuilder rename(String field, String toName) {
        return this.rename(field, null, toName, null);
    }

    public GensonBuilder rename(Class<?> fieldOfType, String toName) {
        return this.rename(null, null, toName, fieldOfType);
    }

    public GensonBuilder rename(String field, Class<?> fromClass, String toName) {
        return this.rename(field, fromClass, toName, null);
    }

    public GensonBuilder rename(String field, String toName, Class<?> fieldOfType) {
        return this.rename(field, null, toName, fieldOfType);
    }

    public GensonBuilder rename(String field, Class<?> fromClass, String toName, Class<?> ofType) {
        this.renamingResolvers.add(new RenamingPropertyNameResolver(field, fromClass, ofType, toName));
        return this;
    }

    public GensonBuilder exclude(String field) {
        return this.filter(field, null, null, true);
    }

    public GensonBuilder exclude(Class<?> fieldOfType) {
        return this.filter(null, null, fieldOfType, true);
    }

    public GensonBuilder exclude(String field, Class<?> fromClass) {
        return this.filter(field, fromClass, null, true);
    }

    public GensonBuilder exclude(String field, Class<?> fromClass, Class<?> ofType) {
        return this.filter(field, fromClass, ofType, true);
    }

    public GensonBuilder include(String field) {
        return this.filter(field, null, null, false);
    }

    public GensonBuilder include(Class<?> fieldOfType) {
        return this.filter(null, null, fieldOfType, false);
    }

    public GensonBuilder include(BeanMutatorAccessorResolver resolver) {
        this.propertyFilters.add(0, resolver);
        return this;
    }

    public GensonBuilder include(String field, Class<?> fromClass) {
        return this.filter(field, fromClass, null, false);
    }

    public GensonBuilder include(String field, Class<?> fromClass, Class<?> ofType) {
        return this.filter(field, fromClass, ofType, false);
    }

    private GensonBuilder filter(String field, Class<?> declaringClass, Class<?> ofType, boolean exclude) {
        if (exclude) {
            this.propertyFilters.add(new PropertyFilter(exclude, field, declaringClass, ofType));
        } else {
            this.propertyFilters.add(0, new PropertyFilter(exclude, field, declaringClass, ofType));
        }
        return this;
    }

    public GensonBuilder setSkipNull(boolean skipNull) {
        this.skipNull = skipNull;
        return this;
    }

    public boolean isSkipNull() {
        return this.skipNull;
    }

    public GensonBuilder setHtmlSafe(boolean htmlSafe) {
        this.htmlSafe = htmlSafe;
        return this;
    }

    public boolean isHtmlSafe() {
        return this.htmlSafe;
    }

    public GensonBuilder useClassMetadata(boolean enabled) {
        this.withClassMetadata = enabled;
        this.metadata = true;
        return this;
    }

    public GensonBuilder useDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    public boolean isEnforceTypeAliases() {
        return this.enforceTypeAliases;
    }

    public GensonBuilder setEnforceTypeAliases(boolean enforceTypeAliases) {
        this.enforceTypeAliases = enforceTypeAliases;
        return this;
    }

    public boolean isThrowExceptionOnNoDebugInfo() {
        return this.throwExcOnNoDebugInfo;
    }

    public GensonBuilder setThrowExceptionIfNoDebugInfo(boolean throwExcOnNoDebugInfo) {
        this.throwExcOnNoDebugInfo = throwExcOnNoDebugInfo;
        return this;
    }

    public GensonBuilder useMethods(boolean enabled) {
        this.useGettersAndSetters = enabled;
        return this;
    }

    public GensonBuilder useMethods(boolean enabled, VisibilityFilter visibility) {
        this.useMethods(enabled);
        return this.setMethodFilter(visibility);
    }

    public GensonBuilder useFields(boolean enabled) {
        this.useFields = enabled;
        return this;
    }

    public GensonBuilder useFields(boolean enabled, VisibilityFilter visibility) {
        this.useFields(enabled);
        return this.setFieldFilter(visibility);
    }

    public GensonBuilder useBeanViews(boolean enabled) {
        this.withBeanViewConverter = enabled;
        return this;
    }

    public GensonBuilder useRuntimeType(boolean enabled) {
        this.useRuntimeTypeForSerialization = enabled;
        return this;
    }

    public GensonBuilder useConstructorWithArguments(boolean enabled) {
        this.withDebugInfoPropertyNameResolver = enabled;
        return this;
    }

    public GensonBuilder setFieldFilter(VisibilityFilter propertyFilter) {
        this.propertyFilter = propertyFilter;
        return this;
    }

    public GensonBuilder setMethodFilter(VisibilityFilter methodFilter) {
        this.methodFilter = methodFilter;
        return this;
    }

    public GensonBuilder setConstructorFilter(VisibilityFilter constructorFilter) {
        this.constructorFilter = constructorFilter;
        return this;
    }

    public GensonBuilder useStrictDoubleParse(boolean strictDoubleParse) {
        this.strictDoubleParse = strictDoubleParse;
        return this;
    }

    public GensonBuilder useIndentation(boolean indent) {
        this.indent = indent;
        return this;
    }

    public GensonBuilder useDateAsTimestamp(boolean enabled) {
        this.useDateAsTimestamp = enabled;
        return this;
    }

    public GensonBuilder useMetadata(boolean metadata) {
        this.metadata = metadata;
        return this;
    }

    public GensonBuilder useByteAsInt(boolean enable) {
        if (enable) {
            this.withConverters(DefaultConverters.ByteArrayAsIntArrayConverter.instance);
        }
        return this;
    }

    public GensonBuilder failOnMissingProperty(boolean enable) {
        this.failOnMissingProperty = enable;
        return this;
    }

    public GensonBuilder useClassMetadataWithStaticType(boolean enable) {
        this.classMetadataWithStaticType = enable;
        return this;
    }

    public GensonBuilder acceptSingleValueAsList(boolean enable) {
        if (enable) {
            this.withConverterFactory(DefaultConverters.SingleValueAsListFactory.instance);
        }
        return this;
    }

    public GensonBuilder useDefaultValue(Object value, Class<?> targetType) {
        this.defaultValues.put(targetType, value);
        return this;
    }

    public GensonBuilder wrapRootValues(final String inputKey, final String outputKey) {
        return this.withConverterFactory(new ChainedFactory(){

            @Override
            protected Converter<?> create(Type type, Genson genson, Converter<?> nextConverter) {
                return new DefaultConverters.WrappedRootValueConverter(inputKey, outputKey, nextConverter);
            }
        });
    }

    public GensonBuilder failOnNullPrimitive(boolean enabled) {
        this.failOnNullPrimitive = enabled;
        return this;
    }

    public GensonBuilder useRuntimePropertyFilter(RuntimePropertyFilter filter) {
        this.runtimePropertyFilter = filter;
        return this;
    }

    public GensonBuilder useUnknownPropertyHandler(UnknownPropertyHandler handler) {
        this.unknownPropertyHandler = handler;
        return this;
    }

    public Genson create() {
        if (this.propertyNameResolver == null) {
            this.propertyNameResolver = this.createPropertyNameResolver();
        }
        if (this.mutatorAccessorResolver == null) {
            this.mutatorAccessorResolver = this.createBeanMutatorAccessorResolver();
        }
        List<Converter<?>> converters = this.getDefaultConverters();
        this.addDefaultSerializers(converters);
        this.addDefaultDeserializers(converters);
        this.addDefaultSerializers(this.getDefaultSerializers());
        this.addDefaultDeserializers(this.getDefaultDeserializers());
        ArrayList convFactories = new ArrayList();
        this.addDefaultConverterFactories(convFactories);
        this.converterFactories.addAll(convFactories);
        ArrayList serializerFactories = new ArrayList();
        this.addDefaultSerializerFactories(serializerFactories);
        this.converterFactories.addAll(serializerFactories);
        ArrayList deserializerFactories = new ArrayList();
        this.addDefaultDeserializerFactories(deserializerFactories);
        this.converterFactories.addAll(deserializerFactories);
        ArrayList defaultContextualFactories = new ArrayList();
        this.addDefaultContextualFactories(defaultContextualFactories);
        this.contextualFactories.addAll(defaultContextualFactories);
        this.beanDescriptorProvider = this.createBeanDescriptorProvider();
        if (this.withBeanViewConverter) {
            ArrayList<BeanMutatorAccessorResolver> resolvers = new ArrayList<BeanMutatorAccessorResolver>();
            resolvers.add(new BeanViewDescriptorProvider.BeanViewMutatorAccessorResolver());
            resolvers.add(this.mutatorAccessorResolver);
            this.beanViewDescriptorProvider = new BeanViewDescriptorProvider(new AbstractBeanDescriptorProvider.ContextualConverterFactory(this.contextualFactories), this.registeredViews, this.createBeanPropertyFactory(), new BeanMutatorAccessorResolver.CompositeResolver(resolvers), this.getPropertyNameResolver());
        }
        return this.create(this.createConverterFactory(), this.withClassAliases, this.withPackageAliases, this.compatibilityAliases);
    }

    private void addDefaultSerializers(List<? extends Serializer<?>> serializers) {
        if (serializers != null) {
            for (Serializer<?> serializer : serializers) {
                Type typeOfConverter = TypeUtil.typeOf(0, TypeUtil.lookupGenericType(Serializer.class, serializer.getClass()));
                if (this.serializersMap.containsKey(typeOfConverter = TypeUtil.expandType(typeOfConverter, serializer.getClass()))) continue;
                this.serializersMap.put(typeOfConverter, serializer);
            }
        }
    }

    private void addDefaultDeserializers(List<? extends Deserializer<?>> deserializers) {
        if (deserializers != null) {
            for (Deserializer<?> deserializer : deserializers) {
                Type typeOfConverter = TypeUtil.typeOf(0, TypeUtil.lookupGenericType(Deserializer.class, deserializer.getClass()));
                if (this.deserializersMap.containsKey(typeOfConverter = TypeUtil.expandType(typeOfConverter, deserializer.getClass()))) continue;
                this.deserializersMap.put(typeOfConverter, deserializer);
            }
        }
    }

    protected Genson create(Factory<Converter<?>> converterFactory, Map<String, Class<?>> classAliases, Map<String, String> packageAliases, Map<String, String> compatibilityAliases) {
        if (this.chainedFactoryModifier != null && converterFactory instanceof ChainedFactory) {
            this.chainedFactoryModifier.apply((ChainedFactory)converterFactory);
        }
        return new Genson(converterFactory, this.getBeanDescriptorProvider(), this.isSkipNull(), this.isHtmlSafe(), classAliases, packageAliases, compatibilityAliases, this.withClassMetadata, this.strictDoubleParse, this.indent, this.metadata, this.failOnMissingProperty, this.enforceTypeAliases, this.defaultValues, this.defaultTypes, this.runtimePropertyFilter, this.unknownPropertyHandler, this.classLoader);
    }

    protected Factory<Converter<?>> createConverterFactory() {
        CircularClassReferenceConverterFactory chainHead = new CircularClassReferenceConverterFactory();
        chainHead.append(new NullConverterFactory(this.failOnNullPrimitive));
        chainHead.append(new ClassMetadataConverter.ClassMetadataConverterFactory(this.classMetadataWithStaticType));
        chainHead.append(new RuntimeTypeConverter.RuntimeTypeConverterFactory());
        if (this.customFactoryChain != null) {
            chainHead.append(this.customFactoryChain);
        }
        if (this.withBeanViewConverter) {
            chainHead.append(new BeanViewConverter.BeanViewConverterFactory(this.getBeanViewDescriptorProvider()));
        }
        AbstractBeanDescriptorProvider.ContextualFactoryDecorator ctxFactoryDecorator = new AbstractBeanDescriptorProvider.ContextualFactoryDecorator(new BasicConvertersFactory(this.getSerializersMap(), this.getDeserializersMap(), this.getFactories(), this.getBeanDescriptorProvider()));
        chainHead.append(ctxFactoryDecorator);
        return chainHead;
    }

    protected BeanMutatorAccessorResolver createBeanMutatorAccessorResolver() {
        List<BeanMutatorAccessorResolver> resolvers = this.mutatorAccessorResolvers;
        resolvers.add(0, new BeanMutatorAccessorResolver.GensonAnnotationPropertyResolver());
        resolvers.addAll(0, this.propertyFilters);
        resolvers.add(new BeanMutatorAccessorResolver.StandardMutaAccessorResolver(this.propertyFilter, this.methodFilter, this.constructorFilter));
        return new BeanMutatorAccessorResolver.CompositeResolver(resolvers);
    }

    protected PropertyNameResolver createPropertyNameResolver() {
        List<PropertyNameResolver> resolvers = this.propertyNameResolvers;
        resolvers.add(0, new PropertyNameResolver.GensonAnnotationPropertyNameResolver());
        resolvers.addAll(0, this.renamingResolvers);
        resolvers.add(new PropertyNameResolver.ConventionalBeanPropertyNameResolver());
        if (this.withDebugInfoPropertyNameResolver) {
            resolvers.add(new ASMCreatorParameterNameResolver(this.isThrowExceptionOnNoDebugInfo()));
        }
        return new PropertyNameResolver.CompositePropertyNameResolver(resolvers);
    }

    protected List<Converter<?>> getDefaultConverters() {
        ArrayList converters = new ArrayList();
        converters.add(DefaultConverters.StringConverter.instance);
        converters.add(DefaultConverters.NumberConverter.instance);
        converters.add(new DefaultConverters.DateConverter(this.dateFormat, this.useDateAsTimestamp));
        converters.add(DefaultConverters.URLConverter.instance);
        converters.add(DefaultConverters.URIConverter.instance);
        converters.add(DefaultConverters.TimestampConverter.instance);
        converters.add(DefaultConverters.BigDecimalConverter.instance);
        converters.add(DefaultConverters.BigIntegerConverter.instance);
        converters.add(DefaultConverters.UUIDConverter.instance);
        converters.add(DefaultConverters.FileConverter.instance);
        converters.add(DefaultConverters.OptionalIntConverter.instance);
        converters.add(DefaultConverters.OptionalLongConverter.instance);
        converters.add(DefaultConverters.OptionalDoubleConverter.instance);
        return converters;
    }

    protected void addDefaultConverterFactories(List<Factory<? extends Converter<?>>> factories) {
        factories.add(DefaultConverters.ArrayConverterFactory.instance);
        factories.add(DefaultConverters.CollectionConverterFactory.instance);
        factories.add(DefaultConverters.MapConverterFactory.instance);
        factories.add(DefaultConverters.EnumConverterFactory.instance);
        factories.add(DefaultConverters.PrimitiveConverterFactory.instance);
        factories.add(DefaultConverters.UntypedConverterFactory.instance);
        factories.add(new DefaultConverters.CalendarConverterFactory(new DefaultConverters.DateConverter(this.dateFormat, this.useDateAsTimestamp)));
        factories.add(DefaultConverters.OptionalConverterFactory.instance);
    }

    protected void addDefaultContextualFactories(List<ContextualFactory<?>> factories) {
        factories.add(new DefaultConverters.DateContextualFactory());
        factories.add(new DefaultConverters.PropertyConverterFactory());
    }

    protected List<Serializer<?>> getDefaultSerializers() {
        return null;
    }

    protected void addDefaultSerializerFactories(List<Factory<? extends Serializer<?>>> serializerFactories) {
    }

    protected List<Deserializer<?>> getDefaultDeserializers() {
        return null;
    }

    protected void addDefaultDeserializerFactories(List<Factory<? extends Deserializer<?>>> deserializerFactories) {
    }

    protected BeanDescriptorProvider createBeanDescriptorProvider() {
        AbstractBeanDescriptorProvider.ContextualConverterFactory contextualConverterFactory = new AbstractBeanDescriptorProvider.ContextualConverterFactory(this.contextualFactories);
        BeanPropertyFactory beanPropertyFactory = this.createBeanPropertyFactory();
        ArrayList<BeanDescriptorProvider> providers = new ArrayList<BeanDescriptorProvider>();
        for (GensonBundle bundle : this._bundles) {
            BeanDescriptorProvider provider = bundle.createBeanDescriptorProvider(contextualConverterFactory, beanPropertyFactory, this.getMutatorAccessorResolver(), this.getPropertyNameResolver(), this);
            if (provider == null) continue;
            providers.add(provider);
        }
        providers.add(new BaseBeanDescriptorProvider(new AbstractBeanDescriptorProvider.ContextualConverterFactory(this.contextualFactories), this.createBeanPropertyFactory(), this.getMutatorAccessorResolver(), this.getPropertyNameResolver(), this.useGettersAndSetters, this.useFields, true));
        return new BeanDescriptorProvider.CompositeBeanDescriptorProvider(providers);
    }

    protected BeanPropertyFactory createBeanPropertyFactory() {
        if (this.withBeanViewConverter) {
            this.beanPropertyFactories.add(new BeanViewDescriptorProvider.BeanViewPropertyFactory(this.registeredViews));
        }
        this.beanPropertyFactories.add(new BeanPropertyFactory.StandardFactory());
        return new BeanPropertyFactory.CompositeFactory(this.beanPropertyFactories);
    }

    protected final PropertyNameResolver getPropertyNameResolver() {
        return this.propertyNameResolver;
    }

    protected final BeanMutatorAccessorResolver getMutatorAccessorResolver() {
        return this.mutatorAccessorResolver;
    }

    protected final BeanDescriptorProvider getBeanDescriptorProvider() {
        return this.beanDescriptorProvider;
    }

    protected final BeanViewDescriptorProvider getBeanViewDescriptorProvider() {
        return this.beanViewDescriptorProvider;
    }

    public final List<Factory<?>> getFactories() {
        return Collections.unmodifiableList(this.converterFactories);
    }

    public final boolean isDateAsTimestamp() {
        return this.useDateAsTimestamp;
    }
}

