/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.jpa;

import com.oracle.coherence.jpa.JpaCacheLoader;
import com.tangosol.net.cache.CacheStore;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class JpaCacheStore<K, V>
extends JpaCacheLoader<K, V>
implements CacheStore<K, V> {
    public JpaCacheStore(String sEntityName, String sEntityClassName, String sUnitName) {
        super(sEntityName, sEntityClassName, sUnitName);
    }

    public JpaCacheStore(String sEntityName, String sEntityClassName, String sUnitName, ClassLoader loader) {
        super(sEntityName, sEntityClassName, sUnitName, loader);
    }

    public void store(K oKey, V oValue) {
        EntityTransaction tx = null;
        try (EntityManager em = this.getEntityManager();){
            tx = em.getTransaction();
            tx.begin();
            em.merge(oValue);
            tx.commit();
        }
    }

    public void storeAll(Map<? extends K, ? extends V> mapEntries) {
        EntityTransaction tx = null;
        try (EntityManager em = this.getEntityManager();){
            tx = em.getTransaction();
            tx.begin();
            Iterator<V> iter = mapEntries.values().iterator();
            while (iter.hasNext()) {
                em.merge(iter.next());
            }
            tx.commit();
        }
    }

    public void erase(K oKey) {
        EntityTransaction tx = null;
        try (EntityManager em = this.getEntityManager();){
            tx = em.getTransaction();
            tx.begin();
            Object oValue = em.find(this.m_sEntityClass, oKey);
            if (oValue != null) {
                em.remove(oValue);
            }
            tx.commit();
        }
    }

    public void eraseAll(Collection<? extends K> colKeys) {
        EntityTransaction tx = null;
        try (EntityManager em = this.getEntityManager();){
            tx = em.getTransaction();
            tx.begin();
            for (K oKey : colKeys) {
                Object oValue = em.find(this.m_sEntityClass, oKey);
                if (oValue == null) continue;
                em.remove(oValue);
            }
            tx.commit();
        }
    }

    protected void rollback(EntityTransaction tx) {
        try {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

