/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.localcache.processors;

import com.tangosol.coherence.jcache.localcache.LocalCache;
import com.tangosol.coherence.jcache.localcache.LocalCacheValue;
import com.tangosol.coherence.jcache.localcache.processors.MutableEntryOperation;
import com.tangosol.util.InvocableMap;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import javax.cache.processor.MutableEntry;

public class EntryProcessorEntry<K, V>
implements MutableEntry<K, V> {
    private final LocalCache<K, V> m_cache;
    private final K m_key;
    private LocalCacheValue m_cachedValue;
    private V m_value;
    private MutableEntryOperation m_operation;
    private long m_ldtNow;
    private CacheLoader<K, V> m_cacheLoader;

    public EntryProcessorEntry(LocalCache cache, InvocableMap.Entry entry, long ldtNow) {
        this.m_cache = cache;
        this.m_key = cache.getKeyConverter().fromInternal(entry.getKey());
        this.m_cachedValue = (LocalCacheValue)entry.getValue();
        this.m_operation = MutableEntryOperation.NONE;
        this.m_value = null;
        this.m_ldtNow = ldtNow;
        this.m_cacheLoader = cache.getContext().isReadThrough() ? cache.getContext().getCacheLoader() : null;
    }

    public K getKey() {
        return this.m_key;
    }

    public V getValue() {
        Object internalValue;
        if (this.m_operation == MutableEntryOperation.NONE) {
            if (this.m_cachedValue == null || this.m_cachedValue.isExpiredAt(this.m_ldtNow)) {
                this.m_value = null;
            } else if (this.m_value == null) {
                internalValue = this.m_cachedValue.getInternalValue(this.m_ldtNow);
                this.m_value = internalValue == null ? null : this.m_cache.getValueConverter().fromInternal(internalValue);
                Object v0 = this.m_value;
            }
        }
        if (this.m_value != null) {
            if (this.m_operation == MutableEntryOperation.NONE) {
                this.m_operation = MutableEntryOperation.ACCESS;
            }
        } else if (this.m_cacheLoader != null) {
            try {
                this.m_value = this.m_cacheLoader.load(this.m_key);
                if (this.m_value != null) {
                    this.m_operation = MutableEntryOperation.LOAD;
                    internalValue = this.m_cache.getValueConverter().toInternal(this.m_value);
                    this.m_cachedValue = LocalCacheValue.createLoadedLocalCacheValue(internalValue, this.m_ldtNow, this.m_cache.getContext().getExpiryPolicy());
                }
            }
            catch (Exception e) {
                if (!(e instanceof CacheLoaderException)) {
                    throw new CacheLoaderException("Exception in CacheLoader", (Throwable)e);
                }
                throw (RuntimeException)e;
            }
        }
        return this.m_value;
    }

    public boolean exists() {
        return this.m_operation == MutableEntryOperation.NONE && this.m_cachedValue != null && !this.m_cachedValue.isExpiredAt(this.m_ldtNow) || this.m_value != null;
    }

    public void remove() {
        this.m_operation = this.m_operation == MutableEntryOperation.CREATE || this.m_operation == MutableEntryOperation.LOAD ? MutableEntryOperation.NONE : MutableEntryOperation.REMOVE;
        this.m_value = null;
        this.m_cachedValue = null;
    }

    public void setValue(V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.m_operation = this.m_cachedValue == null || this.m_cachedValue.isExpiredAt(this.m_ldtNow) ? MutableEntryOperation.CREATE : MutableEntryOperation.UPDATE;
        this.m_value = value;
        if (this.m_cachedValue == null && this.m_operation == MutableEntryOperation.CREATE) {
            Object internalValue = this.m_cache.getValueConverter().toInternal(value);
            this.m_cachedValue = LocalCacheValue.createLocalCacheValue(internalValue, this.m_ldtNow, this.m_cache.getContext().getExpiryPolicy());
        }
    }

    public <T> T unwrap(Class<T> clazz) {
        throw new IllegalArgumentException("Can't unwrap an EntryProcessor Entry");
    }

    public MutableEntryOperation getOperation() {
        return this.m_operation;
    }

    public LocalCacheValue getCacheValue() {
        return this.m_cachedValue;
    }
}

