/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.partitionedcache.processors;

import com.tangosol.coherence.jcache.common.Helper;
import com.tangosol.coherence.jcache.common.JCacheContext;
import com.tangosol.coherence.jcache.common.JCacheEntryMetaInf;
import com.tangosol.coherence.jcache.common.JCacheIdentifier;
import com.tangosol.coherence.jcache.common.JCacheStatistics;
import com.tangosol.coherence.jcache.partitionedcache.processors.AbstractEntryProcessor;
import com.tangosol.coherence.jcache.partitionedcache.processors.BinaryEntryHelper;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.InvocableMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ReplaceProcessor<K>
extends AbstractEntryProcessor {
    private Binary m_binValue;

    public ReplaceProcessor() {
        this.m_binValue = new Binary();
    }

    public ReplaceProcessor(Binary binValue, JCacheIdentifier id) {
        super(id);
        this.m_binValue = binValue;
    }

    public Object process(InvocableMap.Entry entry) {
        long ldtStart = Helper.getCurrentTimeMillis();
        BinaryEntry binEntry = (BinaryEntry)entry;
        BackingMapManagerContext ctx = binEntry.getContext();
        Boolean fReplaced = Boolean.FALSE;
        JCacheContext jcacheCtx = BinaryEntryHelper.getContext(this.m_cacheId, binEntry);
        JCacheStatistics stats = jcacheCtx.getStatistics();
        if (binEntry.isPresent()) {
            JCacheEntryMetaInf valueMetaInf = BinaryEntryHelper.getValueMetaInf(binEntry);
            if (BinaryEntryHelper.isExpired(binEntry, valueMetaInf, ldtStart)) {
                BinaryEntryHelper.expireEntry(binEntry);
            } else {
                valueMetaInf.modified(ldtStart, jcacheCtx.getExpiryPolicy());
                Binary binValue = (Binary)ctx.addInternalValueDecoration((Object)this.m_binValue, 14, (Object)valueMetaInf);
                binEntry.updateBinaryValue(binValue);
                fReplaced = Boolean.TRUE;
            }
        }
        if (fReplaced.booleanValue()) {
            stats.registerHits(1, ldtStart);
            stats.registerPuts(1L, ldtStart);
        } else {
            stats.registerMisses(1, ldtStart);
        }
        return fReplaced;
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        super.readExternal(dataInput);
        this.m_binValue.readExternal(dataInput);
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        super.writeExternal(dataOutput);
        this.m_binValue.writeExternal(dataOutput);
    }

    @Override
    public void readExternal(PofReader pofReader) throws IOException {
        super.readExternal(pofReader);
        this.m_binValue = pofReader.readBinary(1);
    }

    @Override
    public void writeExternal(PofWriter pofWriter) throws IOException {
        super.writeExternal(pofWriter);
        pofWriter.writeBinary(1, this.m_binValue);
    }
}

