/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.localcache.processors;

import com.tangosol.coherence.jcache.common.CoherenceCacheEntry;
import com.tangosol.coherence.jcache.common.Helper;
import com.tangosol.coherence.jcache.common.JCacheStatistics;
import com.tangosol.coherence.jcache.localcache.LocalCache;
import com.tangosol.coherence.jcache.localcache.LocalCacheValue;
import com.tangosol.coherence.jcache.localcache.processors.AbstractEntryProcessor;
import com.tangosol.util.InvocableMap;

public class ReplaceWithProcessor<K, V>
extends AbstractEntryProcessor {
    private Object m_internalExpectedValue;
    private Object m_internalNewValue;

    public ReplaceWithProcessor(LocalCache cache, Object expectedValue, Object newValue) {
        super(cache);
        this.m_internalExpectedValue = expectedValue;
        this.m_internalNewValue = newValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object process(InvocableMap.Entry entry) {
        boolean fResult = false;
        boolean fStatisticsEnabled = this.isStatisticsEnabled();
        long ldtNow = Helper.getCurrentTimeMillis();
        long ldtStart = fStatisticsEnabled ? ldtNow : 0L;
        int hitCount = 0;
        try {
            if (entry.isPresent()) {
                boolean fIsExpired;
                LocalCacheValue cachedValue = (LocalCacheValue)entry.getValue();
                boolean bl = fIsExpired = cachedValue != null && cachedValue.isExpiredAt(ldtNow);
                if (cachedValue == null || fIsExpired) {
                    fResult = false;
                    if (fIsExpired) {
                        this.processExpiries(entry.getKey());
                    }
                } else if (this.m_internalExpectedValue.equals(cachedValue.get())) {
                    ++hitCount;
                    CoherenceCacheEntry entryExternal = new CoherenceCacheEntry(this.fromInternalKey(entry.getKey()), this.fromInternalValue(this.m_internalNewValue));
                    this.writeCacheEntry(entryExternal);
                    fResult = true;
                    entry.setValue((Object)this.updateLocalCacheValue(cachedValue, this.m_internalNewValue, ldtNow));
                } else {
                    this.accessLocalCacheValue(cachedValue, ldtNow);
                    entry.setValue((Object)cachedValue);
                    ++hitCount;
                }
            }
        }
        finally {
            if (fStatisticsEnabled) {
                JCacheStatistics stats = this.getJCacheStatistics();
                if (fResult) {
                    stats.registerPuts(1L, ldtStart);
                }
                if (hitCount == 1) {
                    stats.registerHits(1, ldtStart);
                } else {
                    stats.registerMisses(1, ldtStart);
                }
            }
        }
        return fResult;
    }
}

