/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.common;

import java.util.Map;
import javax.cache.Cache;

public class CoherenceCacheEntry<K, V>
implements Cache.Entry<K, V> {
    private final K m_key;
    private final V m_value;
    private final V m_valueOld;
    private final Map.Entry<K, V> m_entry;

    public CoherenceCacheEntry(Map.Entry<K, V> entry) {
        this.m_key = entry.getKey();
        this.m_value = entry.getValue();
        this.m_valueOld = null;
        this.m_entry = entry;
    }

    public CoherenceCacheEntry(K key, V value) {
        if (key == null) {
            throw new NullPointerException("Keys cannot be null");
        }
        if (value == null) {
            throw new NullPointerException("Values cannot be null");
        }
        this.m_key = key;
        this.m_value = value;
        this.m_valueOld = null;
        this.m_entry = null;
    }

    public CoherenceCacheEntry(K key, V value, V oldValue) {
        if (key == null) {
            throw new NullPointerException("Keys cannot be null");
        }
        if (value == null) {
            throw new NullPointerException("Values cannot be null");
        }
        if (oldValue == null) {
            throw new NullPointerException("Previous values cannot be null");
        }
        this.m_key = key;
        this.m_value = value;
        this.m_valueOld = oldValue;
        this.m_entry = null;
    }

    public K getKey() {
        return this.m_key;
    }

    public V getValue() {
        return this.m_value;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz != null && clazz.isInstance(this)) {
            return (T)this;
        }
        if (this.m_entry != null && clazz.isAssignableFrom(this.m_entry.getClass())) {
            return (T)this.m_entry;
        }
        throw new IllegalArgumentException("Class " + clazz + " is unknown to this implementation");
    }

    public V getOldValue() {
        return this.m_valueOld;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CoherenceCacheEntry other = (CoherenceCacheEntry)object;
        return this.getKey().equals(other.getKey()) && this.getValue().equals(other.getValue()) && (this.getOldValue() == null && other.getOldValue() == null || this.getOldValue().equals(other.getOldValue()));
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }
}

