/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.partitionedcache.processors;

import com.tangosol.coherence.jcache.common.Helper;
import com.tangosol.coherence.jcache.common.JCacheEntryMetaInf;
import com.tangosol.coherence.jcache.common.JCacheIdentifier;
import com.tangosol.coherence.jcache.common.JCacheStatistics;
import com.tangosol.coherence.jcache.partitionedcache.processors.AbstractRemoveProcessor;
import com.tangosol.coherence.jcache.partitionedcache.processors.BinaryEntryHelper;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.InvocableMap;

public class GetAndRemoveProcessor<K, V>
extends AbstractRemoveProcessor<K, V> {
    public GetAndRemoveProcessor() {
        super(null);
    }

    public GetAndRemoveProcessor(JCacheIdentifier id) {
        super(id);
    }

    public Object process(InvocableMap.Entry entry) {
        Binary binValue;
        long ldtStart = Helper.getCurrentTimeMillis();
        BinaryEntry binEntry = (BinaryEntry)entry;
        Binary binary = binValue = binEntry.isPresent() ? binEntry.getBinaryValue() : null;
        if (binEntry.isPresent()) {
            JCacheEntryMetaInf valueMetaInf = BinaryEntryHelper.getValueMetaInf(binEntry);
            if (BinaryEntryHelper.isExpired(binEntry, valueMetaInf, ldtStart)) {
                binValue = null;
                BinaryEntryHelper.expireEntry(binEntry);
                this.deleteCacheEntry(binEntry);
            } else {
                binEntry.remove(false);
            }
        } else {
            this.deleteCacheEntry(binEntry);
        }
        JCacheStatistics stats = BinaryEntryHelper.getContext(this.m_cacheId, binEntry).getStatistics();
        if (binValue == null) {
            stats.registerMisses(1, ldtStart);
        } else {
            stats.registerHits(1, ldtStart);
            stats.registerRemoves(1L, ldtStart);
        }
        return binValue;
    }
}

