/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache;

import com.tangosol.coherence.config.CacheConfig;
import com.tangosol.coherence.config.CacheMapping;
import com.tangosol.coherence.config.ParameterList;
import com.tangosol.coherence.config.ParameterMacroExpression;
import com.tangosol.coherence.config.ResourceMapping;
import com.tangosol.coherence.config.ResourceMappingRegistry;
import com.tangosol.coherence.config.ServiceSchemeRegistry;
import com.tangosol.coherence.config.SimpleParameterList;
import com.tangosol.coherence.config.builder.InstanceBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.scheme.BackingMapScheme;
import com.tangosol.coherence.config.scheme.CacheStoreScheme;
import com.tangosol.coherence.config.scheme.CachingScheme;
import com.tangosol.coherence.config.scheme.DistributedScheme;
import com.tangosol.coherence.config.scheme.LocalScheme;
import com.tangosol.coherence.config.scheme.NearScheme;
import com.tangosol.coherence.config.scheme.ReadWriteBackingMapScheme;
import com.tangosol.coherence.config.scheme.ServiceScheme;
import com.tangosol.coherence.config.xml.processor.PersistenceProcessor;
import com.tangosol.coherence.jcache.common.ContainerHelper;
import com.tangosol.coherence.jcache.partitionedcache.PartitionedCacheBinaryEntryStore;
import com.tangosol.coherence.jcache.partitionedcache.PartitionedCacheConfigurationMapListener;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.LiteralExpression;
import com.tangosol.config.expression.Parameter;
import com.tangosol.config.injection.SimpleInjector;
import com.tangosol.config.xml.AbstractNamespaceHandler;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.internal.net.service.grid.DefaultPartitionedCacheDependencies;
import com.tangosol.internal.net.service.grid.PersistenceDependencies;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.net.events.InterceptorRegistry;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.RegistrationBehavior;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.ResourceResolver;
import java.net.URI;

public class JCacheNamespace
extends AbstractNamespaceHandler {
    public void onEndNamespace(ProcessingContext processingContext, XmlElement xmlElement, String s, URI uri) {
        CacheMapping mapping;
        super.onEndNamespace(processingContext, xmlElement, s, uri);
        CacheConfig cacheConfig = (CacheConfig)processingContext.getCookie(CacheConfig.class);
        if (cacheConfig == null) {
            throw new ConfigurationException("Can't locate the Coherence Configuration.  This only occurs when the " + uri + " namespace is used outside of a Coherence Cache Configuration", "Please ensure that the " + uri + " is defined with in the scope of a Coherence Cache Configuration");
        }
        ResourceRegistry registryResources = processingContext.getResourceRegistry();
        ServiceSchemeRegistry registryServices = cacheConfig.getServiceSchemeRegistry();
        ResourceMappingRegistry registryCacheMappings = cacheConfig.getMappingRegistry();
        ((InterceptorRegistry)registryResources.getResource(InterceptorRegistry.class)).registerEventInterceptor("jcache-lifecycle-interceptor", (EventInterceptor)new ContainerHelper.JCacheLifecycleInterceptor(), RegistrationBehavior.ALWAYS);
        PersistenceDependencies persistenceDeps = new PersistenceProcessor().onProcess(processingContext, xmlElement);
        SimpleInjector injector = new SimpleInjector();
        ServiceScheme schemeService = registryServices.findSchemeBySchemeName("jcache-configurations-scheme");
        DistributedScheme schemeBack = (DistributedScheme)registryServices.findSchemeBySchemeName("jcache-configurations-distributed-scheme");
        if (schemeBack == null) {
            schemeBack = new DistributedScheme();
            schemeBack.setSchemeName("jcache-configurations-distributed-scheme");
            schemeBack.setServiceName("jcache-configurations-distributed-service");
            BackingMapScheme schemeBackingMap = new BackingMapScheme();
            schemeBackingMap.setInnerScheme((CachingScheme)new LocalScheme());
            schemeBack.setBackingMapScheme(schemeBackingMap);
            schemeBack.setAutoStart(true);
            DefaultPartitionedCacheDependencies dependencies = new DefaultPartitionedCacheDependencies();
            dependencies.setPersistenceDependencies(persistenceDeps);
            injector.inject((Object)dependencies, (ResourceResolver)registryResources);
            schemeBack.setServiceDependencies((ServiceDependencies)dependencies);
            injector.inject((Object)schemeBack, (ResourceResolver)registryResources);
            registryServices.register((ServiceScheme)schemeBack);
        }
        if (schemeService == null) {
            NearScheme schemeNear = new NearScheme();
            schemeNear.setSchemeName("jcache-configurations-scheme");
            schemeNear.setServiceName("jcache-configurations-service");
            schemeNear.setInvalidationStrategy((Expression)new LiteralExpression((Object)"all"));
            InstanceBuilder bldrMapListener = new InstanceBuilder(PartitionedCacheConfigurationMapListener.class, new Object[0]);
            schemeNear.setListenerBuilder((ParameterizedBuilder)bldrMapListener);
            LocalScheme schemeFront = new LocalScheme();
            schemeNear.setFrontScheme((CachingScheme)schemeFront);
            schemeNear.setBackScheme((CachingScheme)schemeBack);
            schemeNear.setAutoStart(true);
            registryServices.register((ServiceScheme)schemeNear);
        }
        if ((mapping = registryCacheMappings.findCacheMapping("jcache-configurations")) == null || mapping.usesWildcard()) {
            mapping = new CacheMapping("jcache-configurations", "jcache-configurations-scheme");
            registryCacheMappings.register((ResourceMapping)mapping);
        }
        if ((schemeService = registryServices.findSchemeBySchemeName("jcache-partitioned-scheme")) == null) {
            InstanceBuilder bldrBinaryEntryStore = new InstanceBuilder(PartitionedCacheBinaryEntryStore.class, new Object[0]);
            SimpleParameterList listParameters = new SimpleParameterList();
            listParameters.add(new Parameter("sCacheName", String.class, (Expression)new ParameterMacroExpression("{cache-name}", String.class)));
            listParameters.add(new Parameter("ctxBackingMap", BackingMapManagerContext.class, (Expression)new ParameterMacroExpression("{manager-context}", BackingMapManagerContext.class)));
            listParameters.add(new Parameter("classLoader", ClassLoader.class, (Expression)new ParameterMacroExpression("{class-loader}", ClassLoader.class)));
            bldrBinaryEntryStore.setConstructorParameterList((ParameterList)listParameters);
            CacheStoreScheme schemeCacheStore = new CacheStoreScheme();
            schemeCacheStore.setCustomBuilder((ParameterizedBuilder)bldrBinaryEntryStore);
            ReadWriteBackingMapScheme schemeRWBM = new ReadWriteBackingMapScheme();
            LocalScheme schemeLocal = new LocalScheme();
            schemeRWBM.setCacheStoreScheme(schemeCacheStore);
            schemeRWBM.setInternalScheme((CachingScheme)schemeLocal);
            BackingMapScheme schemeBackingMap = new BackingMapScheme();
            schemeBackingMap.setInnerScheme((CachingScheme)schemeRWBM);
            DistributedScheme schemeDistributed = new DistributedScheme();
            schemeDistributed.setSchemeName("jcache-partitioned-scheme");
            schemeDistributed.setServiceName("jcache-partitioned-service");
            schemeDistributed.setBackingMapScheme(schemeBackingMap);
            schemeDistributed.setAutoStart(true);
            DefaultPartitionedCacheDependencies dependencies = new DefaultPartitionedCacheDependencies();
            dependencies.setPersistenceDependencies(persistenceDeps);
            injector.inject((Object)dependencies, (ResourceResolver)registryResources);
            schemeDistributed.setServiceDependencies((ServiceDependencies)dependencies);
            injector.inject((Object)schemeDistributed, (ResourceResolver)registryResources);
            registryServices.register((ServiceScheme)schemeDistributed);
        }
        if ((mapping = registryCacheMappings.findCacheMapping("jcache-partitioned-*")) == null) {
            mapping = new CacheMapping("jcache-partitioned-*", "jcache-partitioned-scheme");
            registryCacheMappings.register((ResourceMapping)mapping);
        }
        if ((schemeService = registryServices.findSchemeBySchemeName("jcache-local-scheme")) == null) {
            LocalScheme schemeLocal = new LocalScheme();
            schemeLocal.setSchemeName("jcache-local-scheme");
            schemeLocal.setServiceName("jcache-local-service");
            injector.inject((Object)schemeLocal, (ResourceResolver)registryResources);
            registryServices.register((ServiceScheme)schemeLocal);
        }
        if ((mapping = registryCacheMappings.findCacheMapping("jcache-local-*")) == null) {
            mapping = new CacheMapping("jcache-local-*", "jcache-local-scheme");
            registryCacheMappings.register((ResourceMapping)mapping);
        }
    }
}

