/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class SerializationHelper {
    public static byte[] toByteArray(Serializable serializable) throws IOException {
        ByteArrayOutputStream streamByteArray = new ByteArrayOutputStream();
        ObjectOutputStream streamObject = new ObjectOutputStream(streamByteArray);
        streamObject.writeObject(serializable);
        streamObject.flush();
        streamObject.close();
        return streamByteArray.toByteArray();
    }

    public static <T> T fromByteArray(byte[] aBytes, Class<T> clz) throws IOException {
        ByteArrayInputStream streamByteArray = new ByteArrayInputStream(aBytes);
        try (ObjectInputStream streamObject = new ObjectInputStream(streamByteArray);){
            Object oObject = streamObject.readObject();
            if (oObject == null || clz.isInstance(oObject)) {
                T t = clz.cast(oObject);
                return t;
            }
            try {
                throw new ClassCastException("Expected " + clz.getName() + ", Found " + oObject.getClass().getName());
            }
            catch (ClassCastException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("Failed to read underlying exception", e);
            }
        }
    }
}

