/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.passthroughcache.processors;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class GetAndReplaceProcessor<K, V>
extends AbstractProcessor
implements ExternalizableLite,
PortableObject {
    private V m_newValue;

    public GetAndReplaceProcessor() {
    }

    public GetAndReplaceProcessor(V newValue) {
        if (newValue == null) {
            throw new NullPointerException("newValue can't be null)");
        }
        this.m_newValue = newValue;
    }

    public Object process(InvocableMap.Entry entry) {
        if (entry.isPresent()) {
            Object existingValue = entry.getValue();
            entry.setValue(this.m_newValue);
            return existingValue;
        }
        return null;
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_newValue = ExternalizableHelper.readObject((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, this.m_newValue);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.m_newValue = reader.readObject(0);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeObject(0, this.m_newValue);
    }
}

