/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.partitionedcache.processors;

import com.tangosol.coherence.jcache.common.Helper;
import com.tangosol.coherence.jcache.common.JCacheContext;
import com.tangosol.coherence.jcache.common.JCacheEntryMetaInf;
import com.tangosol.coherence.jcache.common.JCacheIdentifier;
import com.tangosol.coherence.jcache.partitionedcache.processors.AbstractEntryProcessor;
import com.tangosol.coherence.jcache.partitionedcache.processors.BinaryEntryHelper;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.GuardSupport;
import com.tangosol.net.Guardian;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.CompositeKey;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PutAllProcessor<K>
extends AbstractEntryProcessor {
    private boolean m_fReplaceExistingValues;
    private boolean m_fUseWriteThrough;
    private boolean m_fLoadAll;

    public PutAllProcessor() {
        this.m_fReplaceExistingValues = false;
        this.m_fUseWriteThrough = false;
        this.m_fLoadAll = false;
    }

    public PutAllProcessor(JCacheIdentifier id, boolean replaceExistingValues, boolean useWriteThrough, boolean fLoadAll) {
        super(id);
        this.m_fReplaceExistingValues = replaceExistingValues;
        this.m_fUseWriteThrough = useWriteThrough;
        this.m_fLoadAll = fLoadAll;
    }

    public Object process(InvocableMap.Entry entry) {
        long ldtNow = Helper.getCurrentTimeMillis();
        BinaryEntry binEntry = (BinaryEntry)entry;
        if (binEntry.isPresent()) {
            throw new IllegalStateException("An entry for the CompositeKey should not exist when using the PutAllProcessor");
        }
        Object oCompositeKey = binEntry.getKey();
        if (oCompositeKey instanceof CompositeKey) {
            boolean fExpired;
            CompositeKey keyComposite = (CompositeKey)oCompositeKey;
            Object oValue = keyComposite.getSecondaryKey();
            BackingMapManagerContext ctx = binEntry.getContext();
            Binary binKey = (Binary)ctx.getKeyToInternalConverter().convert(keyComposite.getPrimaryKey());
            JCacheContext jcacheCtx = BinaryEntryHelper.getContext(this.m_cacheId, binEntry);
            Binary binValue = (Binary)oValue;
            JCacheEntryMetaInf valueMetaInf = BinaryEntryHelper.getValueMetaInf(binEntry = (BinaryEntry)binEntry.getBackingMapContext().getBackingMapEntry((Object)binKey));
            boolean bl = fExpired = valueMetaInf != null && BinaryEntryHelper.isExpired(binEntry, valueMetaInf, ldtNow);
            if (valueMetaInf == null || fExpired) {
                valueMetaInf = new JCacheEntryMetaInf(ldtNow, jcacheCtx.getExpiryPolicy());
                if (!valueMetaInf.isExpiredAt(ldtNow)) {
                    Byte jcacheSynthetic;
                    binValue = (Binary)ctx.addInternalValueDecoration((Object)binValue, 14, (Object)valueMetaInf);
                    if (fExpired && (jcacheSynthetic = (Byte)ctx.getInternalValueDecoration((Object)binValue, 15)) != null && !BinaryEntryHelper.JCACHE_SYNTHETIC_EXPIRY.equals(jcacheSynthetic)) {
                        binValue = BinaryEntryHelper.jcacheSyntheticExpiryEventForReusedBinaryEntry(binValue, ctx);
                    }
                    if (this.m_fLoadAll) {
                        binValue = BinaryEntryHelper.decorateUpdateJCacheSynthetic(binValue, ctx, BinaryEntryHelper.JCACHE_SYNTHETIC_LOADED);
                    }
                    binEntry.updateBinaryValue(binValue);
                    return Boolean.TRUE;
                }
            } else if (this.m_fReplaceExistingValues) {
                valueMetaInf.modified(ldtNow, jcacheCtx.getExpiryPolicy());
                binValue = (Binary)ctx.addInternalValueDecoration((Object)binValue, 14, (Object)valueMetaInf);
                if (this.m_fLoadAll) {
                    binValue = BinaryEntryHelper.decorateUpdateJCacheSynthetic(binValue, ctx, BinaryEntryHelper.JCACHE_SYNTHETIC_LOADED);
                }
                binEntry.updateBinaryValue(binValue);
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public Map processAll(Set setEntries) {
        BinaryEntry binEntry;
        long ldtStart = Helper.getCurrentTimeMillis();
        int cPuts = 0;
        Guardian.GuardContext ctxGuard = GuardSupport.getThreadContext();
        long cMillis = ctxGuard == null ? 0L : ctxGuard.getTimeoutMillis();
        InvocableMap.Entry entry2 = null;
        for (InvocableMap.Entry entry2 : setEntries) {
            boolean fPut = (Boolean)this.process(entry2);
            if (fPut) {
                ++cPuts;
            }
            if (ctxGuard == null) continue;
            ctxGuard.heartbeat(cMillis);
        }
        BinaryEntry binaryEntry = binEntry = entry2 instanceof BinaryEntry ? (BinaryEntry)entry2 : null;
        if (binEntry != null && !this.m_fLoadAll) {
            BinaryEntryHelper.getContext(this.m_cacheId, binEntry).getStatistics().registerPuts(cPuts, ldtStart);
        }
        return null;
    }

    public static Set<CompositeKey> setOf(Map<Object, Binary> map) {
        HashSet<CompositeKey> set = new HashSet<CompositeKey>();
        if (map != null) {
            for (Map.Entry<Object, Binary> entry : map.entrySet()) {
                set.add(new CompositeKey(entry.getKey(), (Object)entry.getValue()));
            }
        }
        return set;
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        super.readExternal(dataInput);
        this.m_fReplaceExistingValues = (Boolean)ExternalizableHelper.readObject((DataInput)dataInput);
        this.m_fUseWriteThrough = (Boolean)ExternalizableHelper.readObject((DataInput)dataInput);
        this.m_fLoadAll = (Boolean)ExternalizableHelper.readObject((DataInput)dataInput);
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        super.writeExternal(dataOutput);
        ExternalizableHelper.writeObject((DataOutput)dataOutput, (Object)this.m_fReplaceExistingValues);
        ExternalizableHelper.writeObject((DataOutput)dataOutput, (Object)this.m_fUseWriteThrough);
        ExternalizableHelper.writeObject((DataOutput)dataOutput, (Object)this.m_fLoadAll);
    }

    @Override
    public void readExternal(PofReader pofReader) throws IOException {
        super.readExternal(pofReader);
        this.m_fReplaceExistingValues = pofReader.readBoolean(1);
        this.m_fUseWriteThrough = pofReader.readBoolean(2);
        this.m_fLoadAll = pofReader.readBoolean(3);
    }

    @Override
    public void writeExternal(PofWriter pofWriter) throws IOException {
        super.writeExternal(pofWriter);
        pofWriter.writeBoolean(1, this.m_fReplaceExistingValues);
        pofWriter.writeBoolean(2, this.m_fUseWriteThrough);
        pofWriter.writeBoolean(3, this.m_fLoadAll);
    }
}

