/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.client;

import com.oracle.coherence.client.GrpcChannelConfigurer;
import com.oracle.coherence.client.GrpcRemoteService;
import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Classes;
import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.common.base.Timeout;
import com.oracle.coherence.common.net.InetSocketAddress32;
import com.oracle.coherence.grpc.CredentialsHelper;
import com.tangosol.coherence.component.net.extend.remoteService.RemoteNameService;
import com.tangosol.coherence.config.builder.FactoryBasedAddressProviderBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.builder.SocketProviderBuilder;
import com.tangosol.coherence.config.unit.Seconds;
import com.tangosol.config.expression.NullParameterResolver;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.internal.net.service.extend.remote.DefaultRemoteNameServiceDependencies;
import com.tangosol.internal.net.service.extend.remote.LegacyXmlRemoteNameServiceHelper;
import com.tangosol.internal.net.service.peer.initiator.DefaultTcpInitiatorDependencies;
import com.tangosol.internal.net.service.peer.initiator.InitiatorDependencies;
import com.tangosol.net.AddressProviderFactory;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.SocketAddressProvider;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.net.grpc.GrpcChannelDependencies;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.run.xml.XmlElement;
import io.grpc.Attributes;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.EquivalentAddressGroup;
import io.grpc.Grpc;
import io.grpc.LoadBalancer;
import io.grpc.ManagedChannelBuilder;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.NameResolverRegistry;
import io.grpc.ProxyDetector;
import io.grpc.Status;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.SharedResourceHolder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class GrpcChannelFactory
extends NameResolverProvider {
    public static final String RESOLVER_SCHEME = "coherence";
    private final Map<String, GrpcServiceInfo> m_mapServiceInfo = new ConcurrentHashMap<String, GrpcServiceInfo>();
    private static final ReentrantLock s_lock = new ReentrantLock();
    private static volatile GrpcChannelFactory s_instance;

    private GrpcChannelFactory() {
        NameResolverRegistry.getDefaultRegistry().register((NameResolverProvider)this);
    }

    public static GrpcChannelFactory singleton() {
        GrpcChannelFactory factory = s_instance;
        if (factory == null) {
            s_lock.lock();
            try {
                factory = s_instance;
                if (factory == null) {
                    factory = s_instance = new GrpcChannelFactory();
                }
            }
            finally {
                s_lock.unlock();
            }
        }
        return factory;
    }

    public Channel getChannel(GrpcRemoteService<?> service) {
        try {
            Object depsService = service.getDependencies();
            GrpcChannelDependencies depsChannel = depsService.getChannelDependencies();
            ManagedChannelBuilder<?> builder = depsChannel.getChannelProvider().orElse(this.createManagedChannelBuilder(service));
            return builder.build();
        }
        catch (Exception e) {
            throw new ConnectionException("Failed to create gRPC channel for service " + service.getServiceName(), (Throwable)e);
        }
    }

    private ManagedChannelBuilder<?> createManagedChannelBuilder(GrpcRemoteService<?> service) {
        Object depsService = service.getDependencies();
        OperationalContext ctx = (OperationalContext)service.getCluster();
        String sService = service.getServiceName();
        String sKey = GrpcServiceInfo.createKey(service);
        String sRemoteService = depsService.getRemoteServiceName();
        String sRemoteCluster = depsService.getRemoteClusterName();
        GrpcChannelDependencies depsChannel = depsService.getChannelDependencies();
        this.m_mapServiceInfo.put(sKey, new GrpcServiceInfo(ctx, sService, sRemoteService, sRemoteCluster, depsChannel));
        String sTarget = depsChannel.getTarget();
        if (sTarget == null) {
            sTarget = GrpcServiceInfo.createTargetURI(service);
        }
        SocketProviderBuilder builder = depsChannel.getSocketProviderBuilder();
        ChannelCredentials credentials = CredentialsHelper.createChannelCredentials((String)sService, (SocketProviderBuilder)builder);
        ManagedChannelBuilder channelBuilder = Grpc.newChannelBuilder((String)sTarget, (ChannelCredentials)credentials);
        depsChannel.getAuthorityOverride().ifPresent(arg_0 -> ((ManagedChannelBuilder)channelBuilder).overrideAuthority(arg_0));
        depsChannel.getConfigurer().filter(GrpcChannelConfigurer.class::isInstance).map(GrpcChannelConfigurer.class::cast).ifPresent(c -> c.apply(channelBuilder));
        HashMap<String, Map<String, String>> mapServiceConfig = new HashMap<String, Map<String, String>>();
        mapServiceConfig.put("healthCheckConfig", Collections.singletonMap("serviceName", "$GRPC:GrpcProxy"));
        channelBuilder.defaultServiceConfig(mapServiceConfig);
        channelBuilder.defaultLoadBalancingPolicy(depsChannel.getDefaultLoadBalancingPolicy());
        channelBuilder.userAgent("Coherence Java Client");
        return channelBuilder;
    }

    public NameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        String sKey = GrpcServiceInfo.parseServiceInfoKey(targetUri);
        GrpcServiceInfo serviceInfo = this.m_mapServiceInfo.get(sKey);
        GrpcChannelDependencies dependencies = serviceInfo.getDependencies();
        return new AddressProviderNameResolver(dependencies, serviceInfo, args);
    }

    public String getDefaultScheme() {
        return RESOLVER_SCHEME;
    }

    protected boolean isAvailable() {
        return true;
    }

    protected int priority() {
        return 0;
    }

    public static class GrpcServiceInfo {
        public static final String KEY_SEPARATOR = "$";
        private final OperationalContext m_operationalContext;
        private final String m_sService;
        private final String m_sRemoteService;
        private final String m_sRemoteCluster;
        private final GrpcChannelDependencies m_dependencies;

        public GrpcServiceInfo(OperationalContext ctx, String sService, String sRemoteService, String sRemoteCluster, GrpcChannelDependencies dependencies) {
            this.m_operationalContext = ctx;
            this.m_sService = sService;
            this.m_sRemoteService = sRemoteService;
            this.m_sRemoteCluster = sRemoteCluster;
            this.m_dependencies = dependencies;
        }

        public static String createKey(GrpcRemoteService<?> service) {
            String sService = service.getServiceName();
            String sScope = service.getScopeName();
            int nIdx = sService.indexOf(":");
            if (sScope == null && nIdx > 0) {
                sScope = sService.substring(0, nIdx);
                sService = sService.substring(nIdx + 1);
            }
            if (sScope == null) {
                return sService + KEY_SEPARATOR;
            }
            return sService + KEY_SEPARATOR + sScope;
        }

        public static String parseServiceInfoKey(URI uri) {
            String sService = uri.getHost();
            String sScope = uri.getQuery();
            if (sScope != null && !sScope.isEmpty() && sScope.charAt(0) == '/') {
                sScope = sService.substring(1);
            }
            if (sScope == null) {
                return sService + KEY_SEPARATOR;
            }
            return sService + KEY_SEPARATOR + sScope;
        }

        public static String createTargetURI(GrpcRemoteService<?> service) {
            String sService = service.getServiceName();
            String sScope = service.getScopeName();
            int nIdx = sService.indexOf(":");
            if (sScope == null && nIdx > 0) {
                sScope = sService.substring(0, nIdx);
                sService = sService.substring(nIdx + 1);
            }
            if (sScope == null) {
                return "coherence://" + sService;
            }
            return "coherence://" + sService + "?" + sScope;
        }

        public OperationalContext getOperationalContext() {
            return this.m_operationalContext;
        }

        public String getService() {
            return this.m_sService;
        }

        public String getRemoteService() {
            if (this.m_sRemoteService == null || this.m_sRemoteService.isBlank()) {
                return "$GRPC:GrpcProxy";
            }
            if (this.m_sRemoteService.endsWith("$GRPC:GrpcProxy")) {
                return "$GRPC:GrpcProxy";
            }
            return this.m_sRemoteService + "$GRPC:GrpcProxy";
        }

        public String getRemoteCluster() {
            return this.m_sRemoteCluster;
        }

        public GrpcChannelDependencies getDependencies() {
            return this.m_dependencies;
        }
    }

    public static class AddressProviderNameResolver
    extends NameResolver {
        private final GrpcServiceInfo m_serviceInfo;
        private final NameResolver.Args m_nameResolverArgs;
        private String m_sAuthority;
        private final ParameterizedBuilder<? extends SocketAddressProvider> m_addressProviderBuilder;
        private final boolean m_fNameServiceAddressProvider;
        private volatile boolean m_fResolving;
        private volatile boolean m_fShutdown;
        private Executor m_executor;
        private final SharedResourceHolder.Resource<Executor> m_executorResource;
        private NameResolver.Listener2 m_listener;

        public AddressProviderNameResolver(GrpcChannelDependencies deps, GrpcServiceInfo serviceInfo, NameResolver.Args args) {
            this.m_fNameServiceAddressProvider = deps.isNameServiceAddressProvider();
            this.m_executorResource = GrpcUtil.SHARED_CHANNEL_EXECUTOR;
            this.m_serviceInfo = serviceInfo;
            this.m_nameResolverArgs = args;
            Object bldr = deps.getRemoteAddressProviderBuilder();
            if (bldr == null) {
                AddressProviderFactory factory = (AddressProviderFactory)serviceInfo.getOperationalContext().getAddressProviderMap().get("cluster-discovery");
                if (factory != null) {
                    bldr = factory instanceof ParameterizedBuilder ? (ParameterizedBuilder)factory : new FactoryBasedAddressProviderBuilder(factory);
                } else {
                    throw new IllegalStateException("Cannot locate the cluster-discovery address provider factory");
                }
            }
            this.m_addressProviderBuilder = bldr;
            new Resolve(this, serviceInfo).run();
        }

        public String getServiceAuthority() {
            return this.m_sAuthority == null ? "" : this.m_sAuthority;
        }

        public void start(NameResolver.Listener2 listener) {
            this.m_listener = Objects.requireNonNull(listener);
            this.m_executor = (Executor)SharedResourceHolder.get(this.m_executorResource);
            this.resolve();
        }

        public void refresh() {
            if (this.m_listener != null) {
                this.resolve();
            }
        }

        public void shutdown() {
            if (this.m_fShutdown) {
                return;
            }
            this.m_fShutdown = true;
            if (this.m_executor != null) {
                this.m_executor = (Executor)SharedResourceHolder.release(this.m_executorResource, (Object)this.m_executor);
            }
        }

        protected NameResolver.Args getNameResolverArgs() {
            return this.m_nameResolverArgs;
        }

        protected SocketAddressProvider buildSocketAddressProvider() {
            ClassLoader loader = Classes.getContextClassLoader();
            return (SocketAddressProvider)this.m_addressProviderBuilder.realize((ParameterResolver)new NullParameterResolver(), loader, null);
        }

        protected boolean isNameServiceAddressProvider() {
            return this.m_fNameServiceAddressProvider;
        }

        protected void setAuthority(String sAuthority) {
            this.m_sAuthority = sAuthority;
        }

        private void resolve() {
            if (this.m_fResolving || this.m_fShutdown) {
                return;
            }
            this.m_fResolving = true;
            this.m_executor.execute(new Resolve(this, this.m_serviceInfo, this.m_listener));
        }
    }

    protected static class NullNameResolverListener
    extends NameResolver.Listener2 {
        protected static final NullNameResolverListener INSTANCE = new NullNameResolverListener();

        protected NullNameResolverListener() {
        }

        public void onResult(NameResolver.ResolutionResult resolutionResult) {
        }

        public void onError(Status error) {
        }
    }

    protected static class Resolve
    implements Runnable {
        private final AddressProviderNameResolver f_parent;
        private final NameResolver.Listener2 f_listener;
        private final GrpcServiceInfo f_serviceInfo;

        protected Resolve(AddressProviderNameResolver parent, GrpcServiceInfo serviceInfo) {
            this(parent, serviceInfo, NullNameResolverListener.INSTANCE);
        }

        protected Resolve(AddressProviderNameResolver parent, GrpcServiceInfo serviceInfo, NameResolver.Listener2 listener) {
            this.f_parent = Objects.requireNonNull(parent);
            this.f_serviceInfo = Objects.requireNonNull(serviceInfo);
            this.f_listener = Objects.requireNonNull(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<Throwable> listError = new ArrayList<Throwable>();
            NameResolver.ResolutionResult result = null;
            int cAttempt = 1;
            GrpcChannelDependencies dependencies = this.f_serviceInfo.getDependencies();
            long cTimeoutSeconds = dependencies.getLoadBalancerTimeout();
            if (cTimeoutSeconds < 1L) {
                cTimeoutSeconds = ((Seconds)GrpcChannelDependencies.DEFAULT_LOAD_BALANCER_TIMEOUT.evaluate((ParameterResolver)new NullParameterResolver())).get();
            }
            try (Timeout ignored = Timeout.after((long)cTimeoutSeconds, (TimeUnit)TimeUnit.SECONDS);){
                while (result == null) {
                    try {
                        List<SocketAddress> list;
                        List<SocketAddress> list2 = list = this.f_parent.isNameServiceAddressProvider() ? this.lookupAddresses() : this.resolveAddresses();
                        if (list.isEmpty()) {
                            NameResolver.ConfigOrError error = NameResolver.ConfigOrError.fromError((Status)Status.FAILED_PRECONDITION.withDescription("Failed to resolve any gRPC proxy addresses"));
                            result = NameResolver.ResolutionResult.newBuilder().setServiceConfig(error).setAttributes(Attributes.EMPTY).build();
                        } else {
                            ProxyDetector proxyDetector;
                            NameResolver.Args args = this.f_parent.getNameResolverArgs();
                            ProxyDetector proxyDetector2 = proxyDetector = args == null ? null : args.getProxyDetector();
                            if (proxyDetector != null) {
                                ArrayList<SocketAddress> proxiedAddresses = new ArrayList<SocketAddress>();
                                for (SocketAddress socketAddress : list) {
                                    proxiedAddresses.add(Objects.requireNonNullElse(proxyDetector.proxyFor(socketAddress), socketAddress));
                                }
                                list = proxiedAddresses;
                            }
                            Map<String, String> config = Collections.singletonMap("serviceName", "$GRPC:GrpcProxy");
                            Attributes attrs = Attributes.newBuilder().set(LoadBalancer.ATTR_HEALTH_CHECKING_CONFIG, config).build();
                            result = NameResolver.ResolutionResult.newBuilder().setAddresses(Collections.singletonList(new EquivalentAddressGroup(list, attrs))).setAttributes(Attributes.EMPTY).build();
                        }
                        Logger.config((String)("Refreshed gRPC endpoints: " + result.getAddresses()));
                    }
                    catch (Throwable t) {
                        listError.add(t);
                        Logger.finest((String)("Failed to lookup gRPC endpoints, attempts=" + cAttempt + " : " + t.getMessage()));
                        Blocking.sleep((long)1000L);
                        ++cAttempt;
                    }
                }
            }
            catch (InterruptedException e) {
                listError.forEach(e::addSuppressed);
                NameResolver.ConfigOrError error = NameResolver.ConfigOrError.fromError((Status)Status.DEADLINE_EXCEEDED.withDescription(e.getMessage()));
                result = NameResolver.ResolutionResult.newBuilder().setServiceConfig(error).setAttributes(Attributes.EMPTY).build();
            }
            finally {
                this.f_parent.m_fResolving = false;
            }
            this.f_listener.onResult(result);
        }

        protected List<SocketAddress> resolveAddresses() {
            SocketAddressProvider addressProvider = this.f_parent.buildSocketAddressProvider();
            ArrayList<SocketAddress> list = new ArrayList<SocketAddress>();
            SocketAddress address = addressProvider.getNextAddress();
            boolean fFirst = true;
            Logger.config((String)("Resolving configured remote gRPC endpoints for service " + this.f_serviceInfo.getService()));
            while (address != null) {
                if (address instanceof InetSocketAddress32) {
                    address = new InetSocketAddress(((InetSocketAddress32)address).getAddress(), ((InetSocketAddress32)address).getPort());
                }
                if (address instanceof InetSocketAddress) {
                    if (fFirst) {
                        this.updateAuthority((InetSocketAddress)address);
                        fFirst = false;
                    }
                    list.add(address);
                }
                address = addressProvider.getNextAddress();
            }
            return list;
        }

        private void updateAuthority(InetSocketAddress address) {
            String sAuthority = GrpcUtil.authorityFromHostAndPort((String)address.getHostString(), (int)address.getPort());
            this.f_parent.setAuthority(sAuthority);
        }

        protected List<SocketAddress> lookupAddresses() {
            SocketAddressProvider addressProvider = this.f_parent.buildSocketAddressProvider();
            RemoteNameService serviceNS = new RemoteNameService();
            OperationalContext context = this.f_serviceInfo.getOperationalContext();
            Logger.config((String)("Using NameService to lookup remote gRPC endpoints for service " + this.f_serviceInfo.getService()));
            serviceNS.setOperationalContext(context);
            serviceNS.setContextClassLoader(Classes.getContextClassLoader());
            serviceNS.setServiceName(this.f_serviceInfo.getService() + ":RemoteNameService");
            DefaultRemoteNameServiceDependencies nameServiceDeps = LegacyXmlRemoteNameServiceHelper.fromXml((XmlElement)CacheFactory.getServiceConfig((String)"RemoteNameService"), (DefaultRemoteNameServiceDependencies)new DefaultRemoteNameServiceDependencies(), (OperationalContext)context, (ClassLoader)Classes.getContextClassLoader());
            DefaultTcpInitiatorDependencies depsNsTcp = new DefaultTcpInitiatorDependencies();
            depsNsTcp.setRemoteSocketAddressProviderBuilder((resolver, loader, listParameters) -> addressProvider);
            depsNsTcp.setSocketProviderBuilder(new SocketProviderBuilder(SocketProviderFactory.DEFAULT_SOCKET_PROVIDER, false));
            String sServiceRemote = this.f_serviceInfo.getRemoteService();
            String sCluster = this.f_serviceInfo.getRemoteCluster();
            if (sCluster == null || sCluster.isEmpty()) {
                sCluster = context.getLocalMember().getClusterName();
            }
            nameServiceDeps.setInitiatorDependencies((InitiatorDependencies)depsNsTcp);
            nameServiceDeps.setRemoteClusterName(sCluster);
            nameServiceDeps.setRemoteServiceName("NameService");
            serviceNS.setDependencies((ServiceDependencies)nameServiceDeps);
            try {
                serviceNS.start();
                Object[] aoResult = (Object[])serviceNS.lookup(sServiceRemote);
                if (aoResult == null) {
                    throw new ConnectionException("Unable to locate gRPC proxy service '" + sServiceRemote + "' within cluster '" + sCluster + "'");
                }
                ArrayList<SocketAddress> list = new ArrayList<SocketAddress>();
                for (int i = 0; i < aoResult.length; i += 2) {
                    list.add(new InetSocketAddress((String)aoResult[i], (int)((Integer)aoResult[i + 1])));
                }
                list.stream().findAny().ifPresent(address -> this.updateAuthority((InetSocketAddress)address));
                if (list.isEmpty()) {
                    throw new ConnectionException("Unable to locate any addresses in cluster '" + sCluster + "' while looking for its gRPC proxy service '" + sServiceRemote + "'");
                }
                ArrayList<SocketAddress> arrayList = list;
                return arrayList;
            }
            catch (Exception ex) {
                throw new ConnectionException("Unable to lookup gRPC proxy '" + sServiceRemote + "' in cluster '" + sCluster + "' cause: " + ex.getMessage(), (Throwable)ex);
            }
            finally {
                serviceNS.stop();
            }
        }
    }
}

