/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.client;

import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.UnsafeByteOperations;
import com.oracle.coherence.client.NamedCacheGrpcClient;
import com.oracle.coherence.common.base.Classes;
import com.oracle.coherence.grpc.BinaryHelper;
import com.oracle.coherence.grpc.OptionalValue;
import com.tangosol.coherence.config.Config;
import com.tangosol.io.NamedSerializerFactory;
import com.tangosol.io.Serializer;
import com.tangosol.net.events.EventDispatcher;
import com.tangosol.util.ExternalizableHelper;
import io.grpc.Channel;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public abstract class BaseGrpcClient<V> {
    protected final String f_sScopeName;
    protected final String f_sName;
    protected final Serializer f_serializer;
    protected final String f_sFormat;
    protected boolean m_fReleased;
    protected boolean m_fDestroyed;
    protected final Executor f_executor;
    protected final EventDispatcher f_dispatcher;

    public BaseGrpcClient(Dependencies dependencies) {
        this.f_sName = dependencies.getName();
        this.f_dispatcher = dependencies.getEventDispatcher();
        this.f_sScopeName = dependencies.getScopeName().orElse("");
        this.f_executor = dependencies.getExecutor().orElseGet(BaseGrpcClient::createDefaultExecutor);
        this.f_sFormat = dependencies.getSerializerFormat().orElseGet(() -> dependencies.getSerializer().map(Serializer::getName).orElseGet(BaseGrpcClient::getDefaultSerializerFormat));
        this.f_serializer = dependencies.getSerializer().orElseGet(() -> BaseGrpcClient.createSerializer(this.f_sFormat));
    }

    public boolean isReleased() {
        return this.m_fReleased;
    }

    public boolean isDestroyed() {
        return this.m_fDestroyed;
    }

    public boolean isActiveInternal() {
        return !this.m_fReleased && !this.m_fDestroyed;
    }

    protected static Serializer createSerializer(String sFormat) {
        return NamedSerializerFactory.DEFAULT.getNamedSerializer(sFormat, Classes.getContextClassLoader());
    }

    protected static String getDefaultSerializerFormat() {
        return Config.getBoolean((String)"coherence.pof.enabled") ? "pof" : "java";
    }

    protected static Executor createDefaultExecutor() {
        return Executors.newSingleThreadExecutor();
    }

    protected BytesValue toBytesValue(Object obj) {
        return BytesValue.of((ByteString)this.toByteString(obj));
    }

    protected ByteString toByteString(Object obj) {
        return UnsafeByteOperations.unsafeWrap((ByteBuffer)ExternalizableHelper.toBinary((Object)obj, (Serializer)this.f_serializer).toByteBuffer());
    }

    protected V valueFromOptionalValue(OptionalValue optional, V defaultValue) {
        if (optional.getPresent()) {
            return (V)this.fromByteString(optional.getValue());
        }
        return defaultValue;
    }

    protected V valueFromBytesValue(BytesValue bv) {
        return (V)this.fromBytesValue(bv);
    }

    protected <T> T fromBytesValue(BytesValue bytes) {
        return (T)BinaryHelper.fromBytesValue((BytesValue)bytes, (Serializer)this.f_serializer);
    }

    protected <T> T fromByteString(ByteString bytes) {
        return (T)BinaryHelper.fromByteString((ByteString)bytes, (Serializer)this.f_serializer);
    }

    protected <T> CompletableFuture<T> failedFuture(Throwable t) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(t);
        return future;
    }

    public static class DefaultDependencies
    implements Dependencies {
        private final String f_sName;
        private final Channel f_channel;
        private final EventDispatcher f_dispatcher;
        private String m_sScopeName;
        private NamedCacheGrpcClient m_client;
        private Executor m_executor;
        private Serializer m_serializer;
        private String m_serializerFormat;

        public DefaultDependencies(String sName, Channel channel, EventDispatcher dispatcher) {
            this.f_sName = sName;
            this.f_channel = channel;
            this.m_sScopeName = "";
            this.f_dispatcher = dispatcher;
        }

        @Override
        public String getName() {
            return this.f_sName;
        }

        @Override
        public Channel getChannel() {
            return this.f_channel;
        }

        @Override
        public Optional<String> getScopeName() {
            return Optional.ofNullable(this.m_sScopeName);
        }

        @Override
        public Optional<Serializer> getSerializer() {
            return Optional.ofNullable(this.m_serializer);
        }

        @Override
        public Optional<String> getSerializerFormat() {
            return Optional.ofNullable(this.m_serializerFormat);
        }

        @Override
        public Optional<Executor> getExecutor() {
            return Optional.ofNullable(this.m_executor);
        }

        @Override
        public EventDispatcher getEventDispatcher() {
            return this.f_dispatcher;
        }

        public void setScope(String sName, String sScopeName) {
            this.m_sScopeName = "$DEFAULT$".equals(sScopeName) ? "" : sScopeName;
        }

        public void setScope(String sScopeName) {
            this.m_sScopeName = "$DEFAULT$".equals(sScopeName) ? "" : sScopeName;
        }

        public void setExecutor(Executor executor) {
            this.m_executor = executor;
        }

        public void setSerializerFormat(String sFormat) {
            this.m_serializerFormat = sFormat;
            this.m_serializer = null;
        }

        public void setSerializer(Serializer serializer) {
            String sFormat = serializer == null ? null : serializer.getName();
            this.setSerializer(serializer, sFormat);
        }

        public void setSerializer(Serializer serializer, String sFormat) {
            this.m_serializer = serializer;
            this.m_serializerFormat = sFormat;
        }
    }

    public static interface Dependencies {
        public String getName();

        public Channel getChannel();

        public Optional<String> getScopeName();

        public Optional<Serializer> getSerializer();

        public Optional<String> getSerializerFormat();

        public Optional<Executor> getExecutor();

        public EventDispatcher getEventDispatcher();
    }
}

