/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.internal.extend.messageFactory;

import com.google.protobuf.Any;
import com.google.protobuf.Int32Value;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.StringValue;
import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.grpc.BinaryHelper;
import com.oracle.coherence.grpc.MessageHelper;
import com.oracle.coherence.grpc.TopicHelper;
import com.oracle.coherence.grpc.internal.extend.message.response.ChannelUriResponse;
import com.oracle.coherence.grpc.internal.extend.message.response.CollectionOfStringValuesResponse;
import com.oracle.coherence.grpc.internal.extend.message.response.EmptyResponse;
import com.oracle.coherence.grpc.internal.extend.message.response.Int32ValueResponse;
import com.oracle.coherence.grpc.messages.topic.v1.EnsureChannelCountRequest;
import com.oracle.coherence.grpc.messages.topic.v1.EnsurePublisherRequest;
import com.oracle.coherence.grpc.messages.topic.v1.EnsurePublisherResponse;
import com.oracle.coherence.grpc.messages.topic.v1.EnsureSubscriberRequest;
import com.oracle.coherence.grpc.messages.topic.v1.EnsureSubscriberResponse;
import com.oracle.coherence.grpc.messages.topic.v1.EnsureTopicRequest;
import com.oracle.coherence.grpc.messages.topic.v1.TopicServiceRequest;
import com.oracle.coherence.grpc.messages.topic.v1.TopicServiceRequestType;
import com.oracle.coherence.grpc.messages.topic.v1.TopicServiceResponse;
import com.tangosol.coherence.component.net.extend.message.GrpcMessageWrapper;
import com.tangosol.coherence.component.net.extend.message.Response;
import com.tangosol.coherence.component.net.extend.message.response.GrpcResponse;
import com.tangosol.coherence.component.net.extend.messageFactory.BaseTopicMessageFactory;
import com.tangosol.coherence.component.net.extend.messageFactory.GrpcMessageFactory;
import com.tangosol.coherence.component.net.extend.messageFactory.TopicServiceFactory;
import com.tangosol.internal.net.topic.impl.paged.model.SubscriberGroupId;
import com.tangosol.internal.net.topic.impl.paged.model.SubscriberId;
import com.tangosol.io.Serializer;
import com.tangosol.util.Filter;
import com.tangosol.util.ListMap;
import com.tangosol.util.ValueExtractor;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class GrpcTopicServiceFactory
extends TopicServiceFactory
implements GrpcMessageFactory<TopicServiceRequest, TopicServiceResponse> {
    private static ListMap<String, Class<?>> __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put((Object)"ChannelCountRequest", GrpcChannelCountRequest.class);
        __mapChildren.put((Object)"DestroyTopicRequest", GrpcDestroyTopicRequest.class);
        __mapChildren.put((Object)"EnsureChannelCountRequest", GrpcEnsureChannelCountRequest.class);
        __mapChildren.put((Object)"EnsureTopicRequest", GrpcEnsureTopicRequest.class);
        __mapChildren.put((Object)"GetSubscriberGroupRequest", GrpcGetSubscriberGroupsRequest.class);
        __mapChildren.put((Object)"EnsurePublisherRequest", GrpcEnsurePublisherRequest.class);
        __mapChildren.put((Object)"DestroyPublisherRequest", GrpcDestroyPublisherRequest.class);
        __mapChildren.put((Object)"EnsureSubscriberRequest", GrpcEnsureSubscriberRequest.class);
        __mapChildren.put((Object)"DestroySubscriberRequest", GrpcDestroySubscriberRequest.class);
        __mapChildren.put((Object)"Response", BaseTopicMessageFactory.TopicsResponse.class);
    }

    protected Map<String, Class<?>> get_ChildClasses() {
        return __mapChildren;
    }

    public <M extends GrpcMessageWrapper> M createRequestMessage(TopicServiceRequest request, Serializer serializer) {
        GrpcMessageWrapper message = (GrpcMessageWrapper)(switch (request.getType()) {
            case TopicServiceRequestType.EnsureTopic -> this.createMessage(5);
            case TopicServiceRequestType.DestroyTopic -> this.createMessage(3);
            case TopicServiceRequestType.EnsurePublisher -> this.createMessage(8);
            case TopicServiceRequestType.DestroyPublisher -> this.createMessage(10);
            case TopicServiceRequestType.EnsureSubscriber -> this.createMessage(9);
            case TopicServiceRequestType.DestroySubscriber -> this.createMessage(11);
            case TopicServiceRequestType.EnsureChannelCount -> this.createMessage(4);
            case TopicServiceRequestType.GetChannelCount -> this.createMessage(1);
            case TopicServiceRequestType.GetSubscriberGroups -> this.createMessage(6);
            default -> throw new IllegalArgumentException("Unsupported request type: " + String.valueOf((Object)request.getType()));
        });
        if (request.hasMessage()) {
            message.setProtoMessage(request.getMessage(), serializer);
        }
        return (M)message;
    }

    public TopicServiceResponse createResponse(GrpcResponse response) {
        TopicServiceResponse.Builder builder = TopicServiceResponse.newBuilder();
        builder.setProxyId(response.getProxyId());
        builder.setMessage(Any.pack((Message)response.getProtoResponse()));
        return builder.build();
    }

    public TopicServiceResponse toProtoMessage(com.tangosol.net.messaging.Message message, int nProxyId) {
        if (message instanceof GrpcResponse) {
            GrpcResponse response = (GrpcResponse)message;
            Message body = response.getProtoResponse();
            return TopicServiceResponse.newBuilder().setProxyId(response.getProxyId()).setMessage(Any.pack((Message)body)).build();
        }
        throw new IllegalArgumentException("Unsupported message type: " + String.valueOf(message));
    }

    protected <T extends Message> T unpack(TopicServiceRequest request, Class<T> type) {
        try {
            Any any = request.getMessage();
            return (T)any.unpack(type);
        }
        catch (InvalidProtocolBufferException e) {
            throw Exceptions.ensureRuntimeException((Throwable)e, (String)("Could not unpack message field of type " + type.getName()));
        }
    }

    static {
        GrpcTopicServiceFactory.__initStatic();
    }

    public static class GrpcChannelCountRequest
    extends TopicServiceFactory.ChannelCountRequest
    implements GrpcMessageWrapper {
        public void setProtoMessage(Any any, Serializer serializer) {
            StringValue request = MessageHelper.unpack(any, StringValue.class);
            this.setTopicName(request.getValue());
            this.setResponse((com.tangosol.net.messaging.Response)new Int32ValueResponse());
        }

        public GrpcResponse getResponse() {
            return (GrpcResponse)super.getResponse();
        }
    }

    public static class GrpcDestroyTopicRequest
    extends TopicServiceFactory.DestroyTopicRequest
    implements GrpcMessageWrapper {
        public GrpcDestroyTopicRequest() {
            this.setResponse((com.tangosol.net.messaging.Response)new EmptyResponse());
        }

        public void setProtoMessage(Any any, Serializer serializer) {
            StringValue request = MessageHelper.unpack(any, StringValue.class);
            this.setTopicName(request.getValue());
        }

        public GrpcResponse getResponse() {
            return (GrpcResponse)super.getResponse();
        }
    }

    public static class GrpcEnsureChannelCountRequest
    extends TopicServiceFactory.EnsureChannelCountRequest
    implements GrpcMessageWrapper {
        public void setProtoMessage(Any any, Serializer serializer) {
            EnsureChannelCountRequest request = MessageHelper.unpack(any, EnsureChannelCountRequest.class);
            this.setTopicName(request.getTopic());
            this.setChannelCount(request.getChannelCount());
            this.setRequiredChannels(request.getRequiredCount());
            this.setResponse((com.tangosol.net.messaging.Response)new Int32ValueResponse());
        }

        public GrpcResponse getResponse() {
            return (GrpcResponse)super.getResponse();
        }
    }

    public static class GrpcEnsureTopicRequest
    extends TopicServiceFactory.EnsureTopicRequest
    implements GrpcMessageWrapper {
        public GrpcEnsureTopicRequest() {
            this.m_fAutoAccept = true;
        }

        public void setProtoMessage(Any any, Serializer serializer) {
            EnsureTopicRequest request = MessageHelper.unpack(any, EnsureTopicRequest.class);
            this.setTopicName(request.getTopic());
            this.setResponse((com.tangosol.net.messaging.Response)new ChannelUriResponse());
        }

        public GrpcResponse getResponse() {
            return (GrpcResponse)super.getResponse();
        }
    }

    public static class GrpcGetSubscriberGroupsRequest
    extends TopicServiceFactory.GetSubscriberGroupsRequest
    implements GrpcMessageWrapper {
        protected void onRun(Response response) {
            super.onRun(response);
            if (!response.isFailure()) {
                Collection list = (Collection)response.getResult();
                response.setResult(list.stream().filter(SubscriberGroupId::isDurable).map(SubscriberGroupId::getGroupName).toList());
            }
        }

        public void setProtoMessage(Any any, Serializer serializer) {
            StringValue request = MessageHelper.unpack(any, StringValue.class);
            this.setTopicName(request.getValue());
            this.setResponse((com.tangosol.net.messaging.Response)new CollectionOfStringValuesResponse());
        }

        public GrpcResponse getResponse() {
            return (GrpcResponse)super.getResponse();
        }
    }

    public static class GrpcEnsurePublisherRequest
    extends TopicServiceFactory.EnsurePublisherRequest
    implements GrpcMessageWrapper {
        public GrpcEnsurePublisherRequest() {
            this.m_fAutoAccept = true;
        }

        public void setProtoMessage(Any any, Serializer serializer) {
            EnsurePublisherRequest request = MessageHelper.unpack(any, EnsurePublisherRequest.class);
            this.setTopicName(request.getTopic());
            this.setChannelCount(request.getChannelCount());
            this.setResponse((com.tangosol.net.messaging.Response)new GrpcEnsurePublisherResponse());
        }

        public GrpcResponse getResponse() {
            return (GrpcResponse)super.getResponse();
        }
    }

    public static class GrpcDestroyPublisherRequest
    extends TopicServiceFactory.DestroyPublisherRequest
    implements GrpcMessageWrapper {
        public void setProtoMessage(Any any, Serializer serializer) {
            Int32Value request = MessageHelper.unpack(any, Int32Value.class);
            this.setPublisherId(request.getValue());
            this.setResponse((com.tangosol.net.messaging.Response)new EmptyResponse());
        }

        public GrpcResponse getResponse() {
            return (GrpcResponse)super.getResponse();
        }
    }

    public static class GrpcEnsureSubscriberRequest
    extends TopicServiceFactory.EnsureSubscriberRequest
    implements GrpcMessageWrapper {
        public GrpcEnsureSubscriberRequest() {
            this.m_fAutoAccept = true;
        }

        public void setProtoMessage(Any any, Serializer serializer) {
            EnsureSubscriberRequest request = MessageHelper.unpack(any, EnsureSubscriberRequest.class);
            this.setTopicName(request.getTopic());
            this.setSubscriberGroup(request.getSubscriberGroup());
            this.setCompleteOnEmpty(request.getCompleteOnEmpty());
            List<Integer> listChannel = request.getChannelsList();
            if (!listChannel.isEmpty()) {
                this.setChannels(listChannel.stream().mapToInt(Integer::intValue).toArray());
            }
            if (request.hasFilter()) {
                Filter filter = (Filter)BinaryHelper.fromByteString(request.getFilter(), serializer);
                this.setFilter(filter);
            }
            if (request.hasExtractor()) {
                ValueExtractor extractor = (ValueExtractor)BinaryHelper.fromByteString(request.getExtractor(), serializer);
                this.setExtractor(extractor);
            }
            this.setResponse((com.tangosol.net.messaging.Response)new GrpcEnsureSubscriberResponse());
        }

        public GrpcResponse getResponse() {
            return (GrpcResponse)super.getResponse();
        }
    }

    public static class GrpcDestroySubscriberRequest
    extends TopicServiceFactory.DestroySubscriberRequest
    implements GrpcMessageWrapper {
        public void setProtoMessage(Any any, Serializer serializer) {
            Int32Value request = MessageHelper.unpack(any, Int32Value.class);
            this.setSubscriberId(request.getValue());
            this.setResponse((com.tangosol.net.messaging.Response)new EmptyResponse());
        }

        public GrpcResponse getResponse() {
            return (GrpcResponse)super.getResponse();
        }
    }

    public static class GrpcEnsureSubscriberResponse
    extends ChannelUriResponse {
        @Override
        protected String getURIValue() {
            Object[] ao = (Object[])this.getResult();
            return String.valueOf(ao[0]);
        }

        @Override
        public Message getMessage() {
            Object[] aoResponse = (Object[])this.getResult();
            URI uri = URI.create((String)aoResponse[0]);
            int nProxyId = Integer.parseInt(uri.getSchemeSpecificPart());
            return EnsureSubscriberResponse.newBuilder().setProxyId(nProxyId).setSubscriberId(TopicHelper.toProtobufSubscriberId((SubscriberId)aoResponse[1])).setGroupId(TopicHelper.toProtobufSubscriberGroupId((SubscriberGroupId)aoResponse[2])).build();
        }
    }

    public static class GrpcEnsurePublisherResponse
    extends ChannelUriResponse {
        @Override
        protected String getURIValue() {
            Object[] ao = (Object[])this.getResult();
            return String.valueOf(ao[0]);
        }

        @Override
        public Message getMessage() {
            Object[] aoResponse = (Object[])this.getResult();
            URI uri = URI.create((String)aoResponse[0]);
            int nProxyId = Integer.parseInt(uri.getSchemeSpecificPart());
            return EnsurePublisherResponse.newBuilder().setProxyId(nProxyId).setPublisherId(((Number)aoResponse[1]).longValue()).setMaxBatchSize(((Number)aoResponse[2]).longValue()).setChannelCount(((Number)aoResponse[3]).intValue()).build();
        }
    }
}

