/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.grpc.BinaryHelper;
import com.oracle.coherence.grpc.ErrorsHelper;
import com.oracle.coherence.grpc.MessageHelper;
import com.oracle.coherence.grpc.messages.common.v1.ErrorMessage;
import com.oracle.coherence.grpc.messages.topic.v1.EnsureSubscriberResponse;
import com.oracle.coherence.grpc.messages.topic.v1.MapOfChannelAndPosition;
import com.oracle.coherence.grpc.messages.topic.v1.MapOfChannelAndTimestamp;
import com.oracle.coherence.grpc.messages.topic.v1.PagedPosition;
import com.oracle.coherence.grpc.messages.topic.v1.PublishResult;
import com.oracle.coherence.grpc.messages.topic.v1.PublishStatus;
import com.oracle.coherence.grpc.messages.topic.v1.PublishedValueStatus;
import com.oracle.coherence.grpc.messages.topic.v1.PublisherEvent;
import com.oracle.coherence.grpc.messages.topic.v1.PublisherEventType;
import com.oracle.coherence.grpc.messages.topic.v1.SubscriberEvent;
import com.oracle.coherence.grpc.messages.topic.v1.SubscriberEventType;
import com.oracle.coherence.grpc.messages.topic.v1.SubscriberGroupId;
import com.oracle.coherence.grpc.messages.topic.v1.SubscriberId;
import com.oracle.coherence.grpc.messages.topic.v1.TopicElement;
import com.oracle.coherence.grpc.messages.topic.v1.TopicPosition;
import com.oracle.coherence.grpc.messages.topic.v1.TopicServiceResponse;
import com.tangosol.coherence.component.net.extend.messageFactory.NamedTopicFactory;
import com.tangosol.internal.net.topic.NamedTopicPublisher;
import com.tangosol.internal.net.topic.PublishResult;
import com.tangosol.internal.net.topic.PublisherConnector;
import com.tangosol.internal.net.topic.SimplePublishResult;
import com.tangosol.internal.net.topic.SimplePublisherStatus;
import com.tangosol.internal.net.topic.SubscriberConnector;
import com.tangosol.io.Serializer;
import com.tangosol.net.topic.Position;
import com.tangosol.net.topic.Publisher;
import com.tangosol.net.topic.Subscriber;
import com.tangosol.util.LongArray;
import com.tangosol.util.SimpleLongArray;
import com.tangosol.util.UUID;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.IntStream;

public abstract class TopicHelper {
    private TopicHelper() {
    }

    public static TopicPosition toProtobufPosition(Position position) {
        if (position == null) {
            return null;
        }
        if (position instanceof com.tangosol.internal.net.topic.impl.paged.model.PagedPosition) {
            PagedPosition.Builder builder = PagedPosition.newBuilder();
            builder.setPage(((com.tangosol.internal.net.topic.impl.paged.model.PagedPosition)position).getPage());
            builder.setOffset(((com.tangosol.internal.net.topic.impl.paged.model.PagedPosition)position).getOffset());
            return TopicPosition.newBuilder().setPosition(Any.pack((Message)builder.build())).build();
        }
        throw new IllegalArgumentException("unsupported position type: " + String.valueOf(position.getClass()));
    }

    public static Position fromProtobufPosition(TopicPosition position) {
        if (position == null || !position.hasPosition()) {
            return null;
        }
        Any any = position.getPosition();
        try {
            if (any.is(PagedPosition.class)) {
                PagedPosition pagedPosition = (PagedPosition)any.unpack(PagedPosition.class);
                return new com.tangosol.internal.net.topic.impl.paged.model.PagedPosition(pagedPosition.getPage(), pagedPosition.getOffset());
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw Exceptions.ensureRuntimeException((Throwable)e);
        }
        throw new IllegalArgumentException("unsupported position typeURL: " + any.getTypeUrl());
    }

    public static PublishResult toProtobufPublishResult(com.tangosol.internal.net.topic.PublishResult result, Serializer serializer) {
        PublishResult.Builder builder = PublishResult.newBuilder();
        if (result != null) {
            PublishStatus publishStatus = switch (result.getStatus()) {
                default -> throw new IncompatibleClassChangeError();
                case PublishResult.Status.Success -> PublishStatus.Success;
                case PublishResult.Status.Retry -> PublishStatus.Success;
                case PublishResult.Status.TopicFull -> PublishStatus.TopicFull;
            };
            int cAccepted = result.getAcceptedCount();
            builder.setChannel(result.getChannelId());
            builder.setStatus(publishStatus);
            builder.setAcceptedCount(cAccepted);
            builder.setRemainingCapacity(result.getRemainingCapacity());
            LongArray aStatuses = result.getPublishStatus();
            LongArray aErrors = result.getErrors();
            for (long i = 0L; i < (long)cAccepted; ++i) {
                PublishedValueStatus.Builder statusBuilder = PublishedValueStatus.newBuilder();
                if (aErrors != null && aErrors.exists(i)) {
                    Throwable throwable = (Throwable)aErrors.get(i);
                    statusBuilder.setError(ErrorsHelper.createErrorMessage(throwable, serializer));
                } else {
                    Publisher.Status status = (Publisher.Status)aStatuses.get(i);
                    statusBuilder.setPosition(TopicHelper.toProtobufPosition(status.getPosition()));
                }
                builder.addValueStatus(statusBuilder.build());
            }
        }
        return builder.build();
    }

    public static com.tangosol.internal.net.topic.PublishResult fromProtoBufPublishResult(TopicServiceResponse response, Serializer serializer) {
        try {
            return TopicHelper.fromProtoBufPublishResult((PublishResult)response.getMessage().unpack(PublishResult.class), serializer);
        }
        catch (InvalidProtocolBufferException e) {
            throw Exceptions.ensureRuntimeException((Throwable)e);
        }
    }

    public static com.tangosol.internal.net.topic.PublishResult fromProtoBufPublishResult(PublishResult result, Serializer serializer) {
        if (result == null) {
            return null;
        }
        int nChannel = result.getChannel();
        int cAccepted = result.getAcceptedCount();
        int cRemaining = result.getRemainingCapacity();
        PublishResult.Status status = switch (result.getStatus()) {
            case PublishStatus.Success -> PublishResult.Status.Success;
            case PublishStatus.TopicFull -> PublishResult.Status.TopicFull;
            default -> throw new IllegalArgumentException("unrecognized status: " + String.valueOf((Object)result.getStatus()));
        };
        SimpleLongArray aStatus = new SimpleLongArray();
        SimpleLongArray aError = new SimpleLongArray();
        for (int i = 0; i < cAccepted; ++i) {
            PublishedValueStatus valueStatus = result.getValueStatus(i);
            if (valueStatus.hasError()) {
                ErrorMessage error = valueStatus.getError();
                Throwable throwable = (Throwable)BinaryHelper.fromByteString(error.getError(), serializer);
                aError.set((long)i, (Object)throwable);
                continue;
            }
            Position position = TopicHelper.fromProtobufPosition(valueStatus.getPosition());
            aStatus.set((long)i, (Object)new SimplePublisherStatus(nChannel, position));
        }
        return new SimplePublishResult(nChannel, cAccepted, (LongArray)aStatus, (LongArray)aError, cRemaining, null, status);
    }

    public static NamedTopicPublisher.PublisherEvent fromProtobufPublisherEvent(PublisherConnector<?> publisher, TopicServiceResponse response) {
        PublisherEvent event = MessageHelper.unpack(response.getMessage(), PublisherEvent.class);
        return TopicHelper.fromProtobufPublisherEvent(publisher, event);
    }

    public static NamedTopicPublisher.PublisherEvent fromProtobufPublisherEvent(PublisherConnector<?> publisher, PublisherEvent event) {
        int cChannel = event.getChannelsCount();
        int[] anChannel = new int[cChannel];
        for (int i = 0; i < cChannel; ++i) {
            anChannel[i] = event.getChannels(i);
        }
        NamedTopicPublisher.PublisherEvent.Type type = switch (event.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case PublisherEventType.PublisherConnected -> NamedTopicPublisher.PublisherEvent.Type.Connected;
            case PublisherEventType.PublisherDisconnected -> NamedTopicPublisher.PublisherEvent.Type.Disconnected;
            case PublisherEventType.PublisherChannelsFreed -> NamedTopicPublisher.PublisherEvent.Type.ChannelsFreed;
            case PublisherEventType.PublisherDestroyed -> NamedTopicPublisher.PublisherEvent.Type.Destroyed;
            case PublisherEventType.PublisherReleased -> NamedTopicPublisher.PublisherEvent.Type.Released;
            case PublisherEventType.PublisherEventUnknown, PublisherEventType.UNRECOGNIZED -> throw new IllegalArgumentException("unknown event type: " + String.valueOf((Object)event.getType()));
        };
        return new NamedTopicPublisher.PublisherEvent(publisher, type, anChannel);
    }

    public static PublisherEvent toProtobufPublisherEvent(NamedTopicFactory.PublisherEvent event) {
        NamedTopicPublisher.PublisherEvent.Type eventType = event.getType();
        PublisherEventType type = switch (eventType) {
            default -> throw new IncompatibleClassChangeError();
            case NamedTopicPublisher.PublisherEvent.Type.Connected -> PublisherEventType.PublisherConnected;
            case NamedTopicPublisher.PublisherEvent.Type.Disconnected -> PublisherEventType.PublisherDisconnected;
            case NamedTopicPublisher.PublisherEvent.Type.Released -> PublisherEventType.PublisherReleased;
            case NamedTopicPublisher.PublisherEvent.Type.Destroyed -> PublisherEventType.PublisherDestroyed;
            case NamedTopicPublisher.PublisherEvent.Type.ChannelsFreed -> PublisherEventType.PublisherChannelsFreed;
        };
        PublisherEvent.Builder builder = PublisherEvent.newBuilder().setType(type);
        int[] anChannel = event.getChannels();
        if (anChannel != null && anChannel.length > 0) {
            builder.addAllChannels(IntStream.of(event.getChannels()).boxed().toList());
        }
        return builder.build();
    }

    public static PublisherEvent toProtobufPublisherEvent(NamedTopicPublisher.PublisherEvent event) {
        PublisherEventType type = switch ((NamedTopicPublisher.PublisherEvent.Type)event.getType()) {
            case NamedTopicPublisher.PublisherEvent.Type.Connected -> PublisherEventType.PublisherConnected;
            case NamedTopicPublisher.PublisherEvent.Type.Disconnected -> PublisherEventType.PublisherDisconnected;
            case NamedTopicPublisher.PublisherEvent.Type.Released -> PublisherEventType.PublisherReleased;
            case NamedTopicPublisher.PublisherEvent.Type.Destroyed -> PublisherEventType.PublisherDestroyed;
            case NamedTopicPublisher.PublisherEvent.Type.ChannelsFreed -> PublisherEventType.PublisherChannelsFreed;
            default -> throw new IllegalArgumentException("unknown event type: " + String.valueOf(event.getType()));
        };
        return PublisherEvent.newBuilder().setType(type).addAllChannels(IntStream.of(event.getChannels()).boxed().toList()).build();
    }

    public static SubscriberConnector.SubscriberEvent fromProtobufSubscriberEvent(SubscriberConnector<?> connector, TopicServiceResponse response) {
        SubscriberEvent event = MessageHelper.unpack(response.getMessage(), SubscriberEvent.class);
        return TopicHelper.fromProtobufSubscriberEvent(connector, event);
    }

    public static SubscriberConnector.SubscriberEvent fromProtobufSubscriberEvent(SubscriberConnector<?> connector, SubscriberEvent event) {
        SubscriberConnector.SubscriberEvent.Type type = switch (event.getType()) {
            case SubscriberEventType.SubscriberGroupDestroyed -> SubscriberConnector.SubscriberEvent.Type.GroupDestroyed;
            case SubscriberEventType.SubscriberChannelAllocation -> SubscriberConnector.SubscriberEvent.Type.ChannelAllocation;
            case SubscriberEventType.SubscriberChannelsLost -> SubscriberConnector.SubscriberEvent.Type.ChannelsLost;
            case SubscriberEventType.SubscriberChannelPopulated -> SubscriberConnector.SubscriberEvent.Type.ChannelPopulated;
            case SubscriberEventType.SubscriberChannelHead -> SubscriberConnector.SubscriberEvent.Type.ChannelHead;
            case SubscriberEventType.SubscriberUnsubscribed -> SubscriberConnector.SubscriberEvent.Type.Unsubscribed;
            case SubscriberEventType.SubscriberDestroyed -> SubscriberConnector.SubscriberEvent.Type.Destroyed;
            case SubscriberEventType.SubscriberReleased -> SubscriberConnector.SubscriberEvent.Type.Released;
            case SubscriberEventType.SubscriberDisconnected -> SubscriberConnector.SubscriberEvent.Type.Disconnected;
            default -> throw new IllegalArgumentException("unknown event type: " + String.valueOf((Object)event.getType()));
        };
        List<Integer> list = event.getChannelsList();
        int[] anChannel = list.stream().mapToInt(i -> i).toArray();
        TreeSet<Integer> setChannel = new TreeSet<Integer>(list);
        return new SubscriberConnector.SubscriberEvent(connector, type, anChannel, setChannel);
    }

    public static SubscriberEvent toProtobufSubscriberEvent(SubscriberConnector.SubscriberEvent event) {
        return TopicHelper.toProtobufSubscriberEvent((SubscriberConnector.SubscriberEvent.Type)event.getType(), event.getAllocatedChannels(), event.getPopulatedChannels());
    }

    public static SubscriberEvent toProtobufSubscriberEvent(NamedTopicFactory.SubscriberChannelEvent event) {
        return TopicHelper.toProtobufSubscriberEvent(event.getEventType(), event.getAllocatedChannels(), event.getPopulatedChannels());
    }

    public static SubscriberEvent toProtobufSubscriberEvent(SubscriberConnector.SubscriberEvent.Type eventType, Set<Integer> setAllocatedChannels, int[] anPopulatedChannels) {
        SubscriberEventType type = switch (eventType) {
            default -> throw new IncompatibleClassChangeError();
            case SubscriberConnector.SubscriberEvent.Type.GroupDestroyed -> SubscriberEventType.SubscriberGroupDestroyed;
            case SubscriberConnector.SubscriberEvent.Type.ChannelAllocation -> SubscriberEventType.SubscriberChannelAllocation;
            case SubscriberConnector.SubscriberEvent.Type.ChannelsLost -> SubscriberEventType.SubscriberChannelsLost;
            case SubscriberConnector.SubscriberEvent.Type.ChannelPopulated -> SubscriberEventType.SubscriberChannelPopulated;
            case SubscriberConnector.SubscriberEvent.Type.ChannelHead -> SubscriberEventType.SubscriberChannelHead;
            case SubscriberConnector.SubscriberEvent.Type.Unsubscribed -> SubscriberEventType.SubscriberUnsubscribed;
            case SubscriberConnector.SubscriberEvent.Type.Destroyed -> SubscriberEventType.SubscriberDestroyed;
            case SubscriberConnector.SubscriberEvent.Type.Released -> SubscriberEventType.SubscriberReleased;
            case SubscriberConnector.SubscriberEvent.Type.Disconnected -> SubscriberEventType.SubscriberDisconnected;
        };
        Collection<Integer> colChannel = setAllocatedChannels;
        if (colChannel == null || colChannel.isEmpty()) {
            colChannel = anPopulatedChannels == null || anPopulatedChannels.length == 0 ? Collections.emptyList() : IntStream.of(anPopulatedChannels).boxed().toList();
        }
        return SubscriberEvent.newBuilder().setType(type).addAllChannels(colChannel).build();
    }

    public static com.tangosol.internal.net.topic.impl.paged.model.SubscriberId fromProtobufSubscriberId(EnsureSubscriberResponse response) {
        return TopicHelper.fromProtobufSubscriberId(response.getSubscriberId());
    }

    public static com.tangosol.internal.net.topic.impl.paged.model.SubscriberId fromProtobufSubscriberId(SubscriberId subscriberId) {
        UUID uuid = new UUID(subscriberId.getUuid().toByteArray());
        long id = subscriberId.getId();
        return new com.tangosol.internal.net.topic.impl.paged.model.SubscriberId(id, uuid);
    }

    public static SubscriberId toProtobufSubscriberId(com.tangosol.internal.net.topic.impl.paged.model.SubscriberId subscriberId) {
        return SubscriberId.newBuilder().setId(subscriberId.getId()).setUuid(ByteString.copyFrom((byte[])subscriberId.getUID().toByteArray())).build();
    }

    public static com.tangosol.internal.net.topic.impl.paged.model.SubscriberGroupId fromProtobufSubscriberGroupId(EnsureSubscriberResponse response) {
        return TopicHelper.fromProtobufSubscriberGroupId(response.getGroupId());
    }

    public static com.tangosol.internal.net.topic.impl.paged.model.SubscriberGroupId fromProtobufSubscriberGroupId(SubscriberGroupId groupId) {
        return com.tangosol.internal.net.topic.impl.paged.model.SubscriberGroupId.unsafe((String)groupId.getName(), (long)groupId.getId());
    }

    public static SubscriberGroupId toProtobufSubscriberGroupId(com.tangosol.internal.net.topic.impl.paged.model.SubscriberGroupId groupId) {
        return SubscriberGroupId.newBuilder().setName(groupId.getGroupName()).setId(groupId.getMemberId()).build();
    }

    public static MapOfChannelAndPosition toProtobufChannelAndPosition(Map<Integer, ? extends Position> map) {
        MapOfChannelAndPosition.Builder builder = MapOfChannelAndPosition.newBuilder();
        for (Map.Entry<Integer, ? extends Position> entry : map.entrySet()) {
            builder.putPositions(entry.getKey(), TopicHelper.toProtobufPosition(entry.getValue()));
        }
        return builder.build();
    }

    public static Map<Integer, Position> fromProtobufChannelAndPosition(MapOfChannelAndPosition col) {
        HashMap<Integer, Position> map = new HashMap<Integer, Position>();
        if (col != null) {
            for (Map.Entry<Integer, TopicPosition> entry : col.getPositionsMap().entrySet()) {
                map.put(entry.getKey(), TopicHelper.fromProtobufPosition(entry.getValue()));
            }
        }
        return map;
    }

    public static MapOfChannelAndTimestamp toProtobufChannelAndTimestamp(Map<Integer, ? extends Instant> map) {
        MapOfChannelAndTimestamp.Builder builder = MapOfChannelAndTimestamp.newBuilder();
        for (Map.Entry<Integer, ? extends Instant> entry : map.entrySet()) {
            Instant instant = entry.getValue();
            Timestamp timestamp = Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build();
            builder.putTimestamps(entry.getKey(), timestamp);
        }
        return builder.build();
    }

    public static Map<Integer, Instant> fromProtobufChannelAndTimestamp(MapOfChannelAndTimestamp col) {
        HashMap<Integer, Instant> map = new HashMap<Integer, Instant>();
        if (col != null) {
            for (Map.Entry<Integer, Timestamp> entry : col.getTimestampsMap().entrySet()) {
                Timestamp timestamp = entry.getValue();
                map.put(entry.getKey(), Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos()));
            }
        }
        return map;
    }

    public static TopicElement toProtobufTopicElement(Subscriber.Element<?> element) {
        Instant instant = element.getTimestamp();
        Timestamp timestamp = Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build();
        return TopicElement.newBuilder().setChannel(element.getChannel()).setTimestamp(timestamp).setPosition(TopicHelper.toProtobufPosition(element.getPosition())).setValue(BinaryHelper.toByteString(element.getBinaryValue())).build();
    }
}

