/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc;

import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Empty;
import com.google.protobuf.StringValue;
import com.google.protobuf.UnsafeByteOperations;
import com.tangosol.io.MultiBufferReadBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.Serializer;
import com.tangosol.io.nio.ByteBufferReadBuffer;
import com.tangosol.net.cache.KeyAssociation;
import com.tangosol.net.partition.KeyPartitioningStrategy;
import com.tangosol.util.Binary;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.ExternalizableHelper;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class BinaryHelper {
    public static final Empty EMPTY = Empty.getDefaultInstance();
    public static final ByteString EMPTY_BYTE_STRING = ByteString.EMPTY;

    private BinaryHelper() {
    }

    public static Binary toBinary(BytesValue bytes) {
        return BinaryHelper.toBinary(bytes.getValue());
    }

    public static Binary toBinary(ByteString bytes) {
        return BinaryHelper.toReadBuffer(bytes).toBinary();
    }

    public static ReadBuffer toReadBuffer(ByteString bytes) {
        ReadBuffer[] readBuffers = (ReadBuffer[])bytes.asReadOnlyByteBufferList().stream().map(ByteBufferReadBuffer::new).toArray(ReadBuffer[]::new);
        return new MultiBufferReadBuffer(readBuffers);
    }

    public static <T> T fromBinary(Binary binary, Serializer serializer) {
        if (binary == null) {
            return null;
        }
        return (T)ExternalizableHelper.fromBinary((Binary)binary, (Serializer)serializer);
    }

    public static BytesValue toBytesValue(Binary binary) {
        BytesValue.Builder builder = BytesValue.newBuilder();
        if (binary != null) {
            builder.setValue(BinaryHelper.toByteString(binary));
        }
        return builder.build();
    }

    public static ByteString toByteString(Binary binary) {
        if (binary != null) {
            return UnsafeByteOperations.unsafeWrap((ByteBuffer)binary.toByteBuffer());
        }
        return ByteString.EMPTY;
    }

    public static <T> T fromBytesValue(BytesValue bytes, Serializer serializer) {
        if (bytes == null) {
            return null;
        }
        return BinaryHelper.fromByteString(bytes.getValue(), serializer);
    }

    public static <T> T fromByteString(ByteString bytes, Serializer serializer) {
        if (bytes != null && !bytes.isEmpty()) {
            return (T)ExternalizableHelper.fromBinary((Binary)BinaryHelper.toBinary(bytes), (Serializer)serializer);
        }
        return null;
    }

    public static BytesValue toBytesValue(Object value, Serializer serializer) {
        return BytesValue.of((ByteString)BinaryHelper.toByteString(value, serializer));
    }

    public static ByteString toByteString(Object value, Serializer serializer) {
        Binary binary = ExternalizableHelper.toBinary((Object)value, (Serializer)serializer);
        return BinaryHelper.toByteString(binary);
    }

    public static Stream<StringValue> toStringValueStream(Iterable<?> iterable) {
        if (iterable == null) {
            return Stream.empty();
        }
        return StreamSupport.stream(iterable.spliterator(), false).filter(Objects::nonNull).map(String::valueOf).map(StringValue::of);
    }

    public static ByteString toKeyByteString(Binary bin, Object obj, Serializer serializer) {
        Binary binDeco = bin;
        if (obj instanceof KeyPartitioningStrategy.PartitionAwareKey) {
            int nPart = ((KeyPartitioningStrategy.PartitionAwareKey)obj).getPartitionId();
            return UnsafeByteOperations.unsafeWrap((ByteBuffer)ExternalizableHelper.decorateBinary((ReadBuffer)bin, (int)nPart).toByteBuffer());
        }
        if (obj instanceof KeyAssociation && (obj = ((KeyAssociation)obj).getAssociatedKey()) != null) {
            binDeco = ExternalizableHelper.toBinary((Object)obj, (Serializer)serializer);
        }
        return UnsafeByteOperations.unsafeWrap((ByteBuffer)ExternalizableHelper.decorateBinary((ReadBuffer)bin, (int)binDeco.calculateNaturalPartition(0)).toByteBuffer());
    }

    public static List<ByteString> toListOfByteString(List<Binary> list) {
        return ConverterCollections.getList(list, BinaryHelper::toByteString, BinaryHelper::toBinary);
    }

    public static List<Binary> toListOfBinary(List<ByteString> list) {
        return ConverterCollections.getList(list, BinaryHelper::toBinary, BinaryHelper::toByteString);
    }
}

