/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc;

import com.oracle.coherence.common.net.SSLSocketProvider;
import com.oracle.coherence.grpc.RefreshableSslContext;
import com.tangosol.coherence.config.Config;
import com.tangosol.coherence.config.builder.SocketProviderBuilder;
import com.tangosol.internal.net.ssl.SSLContextDependencies;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.util.Resources;
import io.grpc.ChannelCredentials;
import io.grpc.InsecureChannelCredentials;
import io.grpc.InsecureServerCredentials;
import io.grpc.ServerCredentials;
import io.grpc.netty.NettySslContextChannelCredentials;
import io.grpc.netty.NettySslContextServerCredentials;
import io.netty.handler.ssl.SslContext;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;

public class CredentialsHelper {
    public static final String PROP_TLS_KEY = "coherence.grpc.channels.%s.tls.key";
    public static final String PROP_TLS_KEYPASS = "coherence.grpc.channels.%s.tls.password";
    public static final String PROP_TLS_KEYPASS_URI = "coherence.grpc.channels.%s.tls.password";
    public static final String PROP_TLS_CERT = "coherence.grpc.channels.%s.tls.cert";
    public static final String PROP_TLS_CA = "coherence.grpc.channels.%s.tls.ca";
    public static final String PROP_CREDENTIALS = "coherence.grpc.channels.%s.credentials";

    private CredentialsHelper() {
    }

    public static ServerCredentials createServerCredentials(SocketProviderBuilder socketBuilder) {
        if (socketBuilder != null) {
            SocketProviderFactory.Dependencies depsFactory = socketBuilder.getDependencies();
            if (depsFactory == null) {
                return InsecureServerCredentials.create();
            }
            String sSocketId = socketBuilder.getId();
            SocketProviderFactory.Dependencies.ProviderType type = depsFactory.getProviderType(sSocketId);
            if (type == SocketProviderFactory.Dependencies.ProviderType.GRPC) {
                return InsecureServerCredentials.create();
            }
            SSLSocketProvider.Dependencies dependencies = depsFactory.getSSLDependencies(sSocketId);
            if (dependencies != null) {
                SSLContextDependencies sslContextDependencies = dependencies.getSSLContextDependencies();
                RefreshableSslContext sslContext = new RefreshableSslContext(sslContextDependencies, true);
                return NettySslContextServerCredentials.create((SslContext)sslContext);
            }
        }
        return InsecureServerCredentials.create();
    }

    public static ChannelCredentials createChannelCredentials(SocketProviderBuilder socketBuilder) {
        if (socketBuilder != null) {
            String sSocketId;
            SocketProviderFactory.Dependencies depsFactory = socketBuilder.getDependencies();
            SocketProviderFactory.Dependencies.ProviderType type = depsFactory.getProviderType(sSocketId = socketBuilder.getId());
            if (type == SocketProviderFactory.Dependencies.ProviderType.GRPC) {
                return InsecureChannelCredentials.create();
            }
            SSLSocketProvider.Dependencies dependencies = depsFactory.getSSLDependencies(sSocketId);
            if (dependencies != null) {
                SSLContextDependencies sslContextDependencies = dependencies.getSSLContextDependencies();
                RefreshableSslContext sslContext = new RefreshableSslContext(sslContextDependencies, false);
                return NettySslContextChannelCredentials.create((SslContext)sslContext);
            }
        }
        return InsecureChannelCredentials.create();
    }

    private static String resolveChannelPassword(String sChannel) throws IOException {
        String sPasswordProperty = String.format("coherence.grpc.channels.%s.tls.password", sChannel);
        String sURIProperty = String.format("coherence.grpc.channels.%s.tls.password", sChannel);
        return CredentialsHelper.resolvePassword(sPasswordProperty, sURIProperty);
    }

    private static String resolveServerPassword() throws IOException {
        return CredentialsHelper.resolvePassword("coherence.grpc.server.tls.password", "coherence.grpc.server.tls.password.uri");
    }

    private static String resolvePassword(String sPasswordProperty, String sURIProperty) throws IOException {
        String sTlsPass = Config.getProperty((String)sPasswordProperty);
        if (sTlsPass != null) {
            return sTlsPass;
        }
        String sURI = Config.getProperty((String)"coherence.grpc.server.tls.password.uri");
        if (sURI != null) {
            URL url = Resources.findFileOrResource((String)sURI, null);
            if (url == null) {
                throw new FileNotFoundException("Cannot locate password file: " + sURI);
            }
            try (InputStream in = url.openStream();){
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                String string = reader.readLine();
                return string;
            }
        }
        return null;
    }

    private static String getProperty(String sProperty, String sChannelName) {
        return Config.getProperty((String)String.format(sProperty, sChannelName));
    }

    private static String getProperty(String sProperty, String sChannelName, String sDefault) {
        return Config.getProperty((String)String.format(sProperty, sChannelName), (String)sDefault);
    }
}

