/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc;

import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.oracle.coherence.grpc.BinaryHelper;
import com.oracle.coherence.grpc.Entry;
import com.oracle.coherence.grpc.RequestHolder;
import com.tangosol.io.Serializer;
import com.tangosol.net.AsyncNamedCache;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.Service;
import com.tangosol.util.Binary;
import com.tangosol.util.Converter;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class CacheRequestHolder<Req, Res>
extends RequestHolder<Req, Res> {
    protected final AsyncNamedCache<Binary, Binary> f_asyncNamedCache;
    protected final Supplier<NamedCache<?, ?>> f_cacheSupplier;
    protected Converter<Binary, Binary> m_converterKeyDown;

    public CacheRequestHolder(Req request, AsyncNamedCache<Binary, Binary> cache, Supplier<NamedCache<?, ?>> cacheSupplier, String sFormat, Serializer serializer, Executor executor) {
        super(request, sFormat, serializer, (Service)cache.getNamedCache().getCacheService(), executor);
        this.f_asyncNamedCache = cache;
        this.f_cacheSupplier = cacheSupplier;
    }

    public String getCacheName() {
        return this.f_asyncNamedCache.getNamedCache().getCacheName();
    }

    public AsyncNamedCache<Binary, Binary> getAsyncCache() {
        return this.f_asyncNamedCache;
    }

    public NamedCache<Binary, Binary> getCache() {
        return this.f_asyncNamedCache.getNamedCache();
    }

    public <K, V> NamedCache<K, V> getNonPassThruCache() {
        return this.f_cacheSupplier.get();
    }

    public Serializer getCacheSerializer() {
        return this.getServiceSerializer();
    }

    public Binary convertKeyDown(ByteString bytes) {
        Binary binary = BinaryHelper.toBinaryKey(bytes);
        return this.convertKeyDown(binary);
    }

    public Binary convertKeyDown(Binary binary) {
        return (Binary)this.ensureConverterKeyDown().convert((Object)binary);
    }

    public Converter<Binary, Binary> ensureConverterKeyDown() {
        if (this.m_converterKeyDown == null) {
            Converter converter;
            CacheService cacheService = this.f_asyncNamedCache.getNamedCache().getCacheService();
            String cacheFormat = CacheRequestHolder.getCacheFormat((Service)cacheService);
            if (this.f_sFormat == null || this.f_sFormat.trim().isEmpty() || this.f_sFormat.equals(cacheFormat)) {
                converter = BinaryHelper::toBinaryKey;
            } else {
                BackingMapManagerContext context = cacheService.getBackingMapManager().getContext();
                Converter converterKey = context.getKeyToInternalConverter();
                converter = new RequestHolder.DownConverter(this.f_serializer, (Converter<Object, Binary>)converterKey);
            }
            this.m_converterKeyDown = new RequestHolder.ErrorHandlingConverter<Binary, Binary>(converter);
        }
        return this.m_converterKeyDown;
    }

    @Override
    protected Converter<Object, Binary> createConverterDown() {
        return ((CacheService)this.f_service).getBackingMapManager().getContext().getValueToInternalConverter();
    }

    public <T> CompletionStage<CacheRequestHolder<Req, T>> runAsync(CompletionStage<T> stage) {
        return stage.handleAsync((r, err) -> {
            if (err == null) {
                return (CacheRequestHolder)this.setResult(r);
            }
            throw Status.INTERNAL.withCause(err).withDescription(err.getMessage()).asRuntimeException();
        }, this.f_executor);
    }

    public Consumer<Map.Entry<? extends Binary, ? extends Binary>> entryConsumer(StreamObserver<Entry> observer) {
        return entry -> observer.onNext((Object)this.toEntry((Binary)entry.getKey(), (Binary)entry.getValue()));
    }

    public Consumer<Binary> binaryConsumer(StreamObserver<BytesValue> observer) {
        return binary -> observer.onNext((Object)BinaryHelper.toBytesValue(this.convertUp((Binary)binary)));
    }
}

