/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.net.ssl.SSLContextDependencies;
import io.grpc.netty.GrpcSslContexts;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.ApplicationProtocolNegotiator;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSessionContext;

public class RefreshableSslContext
extends SslContext
implements SSLContextDependencies.Listener {
    private final SSLContextDependencies m_deps;
    private final boolean m_fServer;
    private volatile SslContext m_delegate;

    public RefreshableSslContext(SSLContextDependencies dependencies, boolean fServer) {
        this.m_deps = new SSLContextDependencies(dependencies, (SSLContextDependencies.Listener)this);
        this.m_fServer = fServer;
        this.m_deps.init();
    }

    public void onUpdate(SSLContextDependencies dependencies) throws GeneralSecurityException {
        try {
            SslContextBuilder builder = this.m_fServer ? SslContextBuilder.forServer((KeyManager)dependencies.getKeyManagers()[0]) : SslContextBuilder.forClient().keyManager(dependencies.getKeyManagers()[0]);
            ClientAuth clientAuth = dependencies.isPeerAuthentication() ? ClientAuth.REQUIRE : ClientAuth.OPTIONAL;
            String[] asCipher = dependencies.getEnabledCipherSuites();
            if (asCipher != null && asCipher.length > 0) {
                builder.ciphers(Arrays.asList(asCipher));
            }
            builder.clientAuth(clientAuth).trustManager(dependencies.getTrustManagers()[0]).sslContextProvider(dependencies.getProvider()).startTls(false);
            this.m_delegate = GrpcSslContexts.configure((SslContextBuilder)builder).build();
        }
        catch (SSLException e) {
            throw new GeneralSecurityException(e);
        }
    }

    public void onError(SSLContextDependencies dependencies, Throwable t) throws KeyManagementException {
        if (this.m_delegate == null) {
            throw new KeyManagementException("Could not create first SSLContext. Expect communication errors.", t);
        }
        Logger.err((String)"Could not properly instantiate SSLContext. The existing SSLContext will be used", (Throwable)t);
    }

    public boolean isClient() {
        return this.m_delegate.isClient();
    }

    public List<String> cipherSuites() {
        return this.m_delegate.cipherSuites();
    }

    public ApplicationProtocolNegotiator applicationProtocolNegotiator() {
        return this.m_delegate.applicationProtocolNegotiator();
    }

    public SSLEngine newEngine(ByteBufAllocator alloc) {
        return this.m_delegate.newEngine(alloc);
    }

    public SSLEngine newEngine(ByteBufAllocator alloc, String peerHost, int peerPort) {
        return this.m_delegate.newEngine(alloc, peerHost, peerPort);
    }

    public SSLSessionContext sessionContext() {
        return this.m_delegate.sessionContext();
    }
}

