/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc;

import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SafeStreamObserver<T>
implements StreamObserver<T> {
    private StreamObserver<? super T> delegate;
    private boolean done;
    private static final Logger LOGGER = Logger.getLogger(SafeStreamObserver.class.getName());

    private SafeStreamObserver(StreamObserver<? super T> streamObserver) {
        this.delegate = streamObserver;
    }

    public void onNext(T t) {
        if (this.done) {
            return;
        }
        if (t == null) {
            this.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("onNext called with null. Null values are generally not allowed.").asRuntimeException());
        } else {
            try {
                this.delegate.onNext(t);
            }
            catch (Throwable thrown) {
                SafeStreamObserver.throwIfFatal(thrown);
                this.onError(thrown);
            }
        }
    }

    public void onError(Throwable thrown) {
        try {
            if (this.done) {
                LOGGER.log(Level.SEVERE, this.checkNotNull(thrown), () -> "OnError called after StreamObserver was closed");
            } else {
                this.done = true;
                this.delegate.onError(this.checkNotNull(thrown));
            }
        }
        catch (Throwable t) {
            SafeStreamObserver.throwIfFatal(t);
            LOGGER.log(Level.SEVERE, t, () -> "Caught exception handling onError");
        }
    }

    public void onCompleted() {
        if (this.done) {
            LOGGER.log(Level.WARNING, "onComplete called after StreamObserver was closed");
        } else {
            try {
                this.done = true;
                this.delegate.onCompleted();
            }
            catch (Throwable thrown) {
                SafeStreamObserver.throwIfFatal(thrown);
                LOGGER.log(Level.SEVERE, thrown, () -> "Caught exception handling onComplete");
            }
        }
    }

    public StreamObserver<? super T> delegate() {
        return this.delegate;
    }

    private Throwable checkNotNull(Throwable thrown) {
        if (thrown == null) {
            thrown = Status.INVALID_ARGUMENT.withDescription("onError called with null Throwable. Null exceptions are generally not allowed.").asRuntimeException();
        }
        return thrown;
    }

    private static void throwIfFatal(Throwable thrown) {
        if (thrown instanceof VirtualMachineError) {
            throw (VirtualMachineError)thrown;
        }
        if (thrown instanceof ThreadDeath) {
            throw (ThreadDeath)thrown;
        }
        if (thrown instanceof LinkageError) {
            throw (LinkageError)thrown;
        }
    }

    public static <T> StreamObserver<T> ensureSafeObserver(StreamObserver<T> observer) {
        if (observer instanceof SafeStreamObserver) {
            return observer;
        }
        return new SafeStreamObserver<T>(observer);
    }
}

