/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc;

import com.oracle.coherence.grpc.SafeStreamObserver;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LockingStreamObserver<V>
implements StreamObserver<V> {
    private final Lock f_lock = new ReentrantLock();
    private final SafeStreamObserver<? super V> f_delegate;

    public LockingStreamObserver(StreamObserver<? super V> delegate) {
        this.f_delegate = (SafeStreamObserver)SafeStreamObserver.ensureSafeObserver(delegate);
    }

    public void onNext(V value) {
        this.f_lock.lock();
        try {
            this.f_delegate.onNext(value);
        }
        finally {
            this.f_lock.unlock();
        }
    }

    public void onError(Throwable t) {
        this.f_lock.lock();
        try {
            this.f_delegate.onError(t);
        }
        finally {
            this.f_lock.unlock();
        }
    }

    public void onCompleted() {
        this.f_lock.lock();
        try {
            this.f_delegate.onCompleted();
        }
        finally {
            this.f_lock.unlock();
        }
    }

    public boolean isDone() {
        return this.f_delegate.isDone();
    }

    public static <T> LockingStreamObserver<T> ensureLockingObserver(StreamObserver<T> observer) {
        if (observer instanceof LockingStreamObserver) {
            return (LockingStreamObserver)observer;
        }
        return new LockingStreamObserver<T>(observer);
    }
}

