/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy;

import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.grpc.CredentialsHelper;
import com.oracle.coherence.grpc.proxy.BindableGrpcProxyService;
import com.oracle.coherence.grpc.proxy.DaemonPoolExecutor;
import com.oracle.coherence.grpc.proxy.GrpcMetricsInterceptor;
import com.oracle.coherence.grpc.proxy.GrpcServerConfiguration;
import com.oracle.coherence.grpc.proxy.GrpcServiceDependencies;
import com.oracle.coherence.grpc.proxy.NamedCacheServiceGrpcImpl;
import com.oracle.coherence.grpc.proxy.NamedCacheServiceImpl;
import com.tangosol.coherence.config.builder.SocketProviderBuilder;
import com.tangosol.internal.net.service.peer.acceptor.DefaultGrpcAcceptorDependencies;
import com.tangosol.internal.net.service.peer.acceptor.GrpcAcceptorDependencies;
import com.tangosol.internal.util.DaemonPool;
import com.tangosol.net.grpc.GrpcAcceptorController;
import io.grpc.BindableService;
import io.grpc.Grpc;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;

public class DefaultGrpcAcceptorController
implements GrpcAcceptorController {
    private GrpcAcceptorDependencies m_dependencies;
    private volatile boolean m_fRunning;
    private Server m_server;
    private Server m_inProcessServer;
    private DaemonPool m_daemonPool;

    public void setDependencies(GrpcAcceptorDependencies deps) {
        this.m_dependencies = deps;
    }

    public GrpcAcceptorDependencies getDependencies() {
        GrpcAcceptorDependencies deps = this.m_dependencies;
        if (deps == null) {
            deps = this.m_dependencies = new DefaultGrpcAcceptorDependencies();
        }
        return deps;
    }

    public void setDaemonPool(DaemonPool pool) {
        this.m_daemonPool = pool;
    }

    public void start() {
        try {
            GrpcAcceptorDependencies deps = this.getDependencies();
            ServerBuilder<?> serverBuilder = this.createServerBuilder(deps);
            InProcessServerBuilder inProcessBuilder = this.createInProcessServerBuilder(deps);
            GrpcServiceDependencies.DefaultDependencies serviceDeps = new GrpcServiceDependencies.DefaultDependencies();
            if (this.m_daemonPool != null) {
                serviceDeps.setExecutor(new DaemonPoolExecutor(this.m_daemonPool));
            }
            for (BindableGrpcProxyService service : DefaultGrpcAcceptorController.createGrpcServices(serviceDeps)) {
                GrpcMetricsInterceptor interceptor = new GrpcMetricsInterceptor(service.getMetrics());
                ServerServiceDefinition definition = ServerInterceptors.intercept((BindableService)service, (ServerInterceptor[])new ServerInterceptor[]{interceptor});
                serverBuilder.addService(definition);
                inProcessBuilder.addService(definition);
            }
            this.configure(serverBuilder, inProcessBuilder);
            Server server = serverBuilder.build();
            Server inProcessServer = inProcessBuilder.build();
            server.start();
            inProcessServer.start();
            Logger.info(() -> "In-Process GrpcAcceptor is now listening for connections using name \"" + deps.getInProcessName() + "\"");
            this.m_server = server;
            this.m_inProcessServer = inProcessServer;
            this.m_fRunning = true;
        }
        catch (IOException e) {
            throw Exceptions.ensureRuntimeException((Throwable)e, (String)"Failed to start gRPC server");
        }
    }

    public void stop() {
        if (this.isRunning()) {
            this.stopServer(this.m_inProcessServer, "in-process server");
            this.m_inProcessServer = null;
            this.stopServer(this.m_server, "server");
            this.m_server = null;
        }
    }

    public boolean isRunning() {
        return this.m_fRunning;
    }

    public String getLocalAddress() {
        return this.m_dependencies.getLocalAddress();
    }

    public int getLocalPort() {
        if (this.m_server == null) {
            throw new IllegalStateException("The gRPC server is not started");
        }
        return this.m_server.getPort();
    }

    public String getInProcessName() {
        return this.getDependencies().getInProcessName();
    }

    protected ServerBuilder<?> createServerBuilder(GrpcAcceptorDependencies deps) {
        ServerCredentials credentials = CredentialsHelper.createServerCredentials((SocketProviderBuilder)deps.getSocketProviderBuilder());
        return Grpc.newServerBuilderForPort((int)deps.getLocalPort(), (ServerCredentials)credentials);
    }

    protected InProcessServerBuilder createInProcessServerBuilder(GrpcAcceptorDependencies deps) {
        return InProcessServerBuilder.forName((String)deps.getInProcessName());
    }

    public static List<BindableGrpcProxyService> createGrpcServices() {
        return DefaultGrpcAcceptorController.createGrpcServices(null);
    }

    public static List<BindableGrpcProxyService> createGrpcServices(GrpcServiceDependencies deps) {
        NamedCacheServiceGrpcImpl cacheService = new NamedCacheServiceGrpcImpl(new NamedCacheServiceImpl.DefaultDependencies(deps));
        return Collections.singletonList(cacheService);
    }

    protected void configure(ServerBuilder<?> serverBuilder, InProcessServerBuilder inProcessServerBuilder) {
        for (GrpcServerConfiguration cfg : ServiceLoader.load(GrpcServerConfiguration.class)) {
            try {
                cfg.configure(serverBuilder, inProcessServerBuilder);
            }
            catch (Throwable t) {
                Logger.err((String)("Caught exception calling GrpcServerConfiguration " + cfg), (Throwable)t);
            }
        }
    }

    private void stopServer(Server server, String sName) {
        boolean fStopped = false;
        if (server == null) {
            return;
        }
        server.shutdown();
        Logger.finest((String)("Awaiting termination of Coherence gRPC proxy " + sName));
        try {
            fStopped = server.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!fStopped) {
            Logger.finest((String)("Forcing termination of Coherence gRPC proxy " + sName));
            server.shutdownNow();
        }
        Logger.fine((String)("Stopped Coherence gRPC proxy " + sName));
    }
}

