/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy;

import com.oracle.coherence.common.base.Classes;
import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.common.base.Objects;
import com.oracle.coherence.grpc.proxy.BindableGrpcProxyService;
import com.oracle.coherence.grpc.proxy.DefaultGrpcAcceptorController;
import com.tangosol.application.ContainerContext;
import com.tangosol.application.Context;
import com.tangosol.application.LifecycleListener;
import com.tangosol.coherence.config.Config;
import com.tangosol.coherence.config.scheme.ServiceScheme;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.net.ProxyService;
import com.tangosol.net.ServiceMonitor;
import com.tangosol.net.SimpleServiceMonitor;
import com.tangosol.net.grpc.GrpcAcceptorController;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.ResourceRegistry;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class GrpcServerController {
    public static final GrpcServerController INSTANCE = new GrpcServerController();
    private ExtensibleConfigurableCacheFactory m_ccf;
    private final ServiceMonitor f_serviceMonitor;
    private boolean m_fEnabled = true;
    private final Context f_context;
    private CompletableFuture<Void> m_startFuture = new CompletableFuture();
    private final Lock f_startLock = new ReentrantLock();

    private GrpcServerController() {
        this(null);
    }

    private GrpcServerController(Context context) {
        this.f_context = context;
        this.f_serviceMonitor = new SimpleServiceMonitor();
    }

    public void start() {
        if (this.isRunning() || !this.m_fEnabled) {
            return;
        }
        this.f_startLock.lock();
        try {
            if (this.isRunning() || !this.m_fEnabled) {
                return;
            }
            ContainerContext containerContext = this.f_context == null ? null : this.f_context.getContainerContext();
            String sAppName = this.f_context == null ? null : this.f_context.getApplicationName();
            Runnable r = () -> {
                ClassLoader loader = Classes.getContextClassLoader();
                XmlDocument xmlConfig = XmlHelper.loadFileOrResourceOrDefault((String)"grpc-proxy-cache-config.xml", (String)"gRPC Proxy Cache Configuration", (ClassLoader)loader);
                Object sCcfScope = sAppName != null && !"$SYS".equals(sAppName) ? sAppName + "$GRPC" : "$GRPC";
                ExtensibleConfigurableCacheFactory.Dependencies deps = ExtensibleConfigurableCacheFactory.DependenciesHelper.newInstance((XmlElement)xmlConfig, (ClassLoader)loader, null, (String)sCcfScope, (Context)this.f_context);
                this.m_ccf = new ExtensibleConfigurableCacheFactory(deps);
                this.m_ccf.activate();
                ServiceMonitor monitor = this.f_serviceMonitor;
                monitor.setConfigurableCacheFactory((ConfigurableCacheFactory)this.m_ccf);
                monitor.registerServices(this.m_ccf.getServiceMap());
                if (monitor.isMonitoring()) {
                    String sScope = ServiceScheme.getScopePrefix((String)sAppName, (ContainerContext)containerContext);
                    String sName = ServiceScheme.getScopedServiceName((String)sScope, (String)monitor.getThread().getName());
                    monitor.getThread().setName(sName);
                }
            };
            if (containerContext == null) {
                r.run();
            } else {
                containerContext.runInDomainPartitionContext(r);
            }
            this.markStarted();
        }
        catch (Throwable e) {
            if (!this.m_startFuture.isDone()) {
                this.m_startFuture.completeExceptionally(e);
            }
            throw Exceptions.ensureRuntimeException((Throwable)e);
        }
        finally {
            this.f_startLock.unlock();
        }
    }

    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.f_startLock.lock();
        try {
            if (this.isRunning()) {
                if (this.f_serviceMonitor.isMonitoring()) {
                    this.f_serviceMonitor.stopMonitoring();
                    this.f_serviceMonitor.unregisterServices(this.m_ccf.getServiceMap().keySet());
                    this.m_ccf.dispose();
                    this.m_ccf = null;
                }
                this.m_startFuture = new CompletableFuture();
            }
        }
        finally {
            this.f_startLock.unlock();
        }
    }

    public void markStarted() {
        if (!this.m_startFuture.isDone()) {
            this.m_startFuture.complete(null);
        }
    }

    public CompletionStage<Void> whenStarted() {
        return this.m_startFuture;
    }

    public boolean isRunning() {
        return this.f_serviceMonitor.isMonitoring();
    }

    public int getPort() {
        if (this.isRunning()) {
            ProxyService proxyService = (ProxyService)this.m_ccf.ensureService("GrpcProxy");
            ResourceRegistry registry = proxyService.getResourceRegistry();
            GrpcAcceptorController controller = (GrpcAcceptorController)registry.getResource(GrpcAcceptorController.class);
            return controller.getLocalPort();
        }
        throw new IllegalStateException("The gRPC server is not running");
    }

    public String getInProcessName() {
        if (this.isRunning()) {
            ProxyService proxyService = (ProxyService)this.m_ccf.ensureService("GrpcProxy");
            ResourceRegistry registry = proxyService.getResourceRegistry();
            GrpcAcceptorController controller = (GrpcAcceptorController)registry.getResource(GrpcAcceptorController.class);
            return controller.getInProcessName();
        }
        throw new IllegalStateException("The gRPC server is not running");
    }

    @Deprecated(since="22.06.2")
    public List<BindableGrpcProxyService> createGrpcServices() {
        return DefaultGrpcAcceptorController.createGrpcServices();
    }

    public void setEnabled(boolean fEnabled) {
        this.m_fEnabled = fEnabled;
    }

    public static class Listener
    implements LifecycleListener {
        private static final Map<String, GrpcServerController> f_mapDomainController = new ConcurrentHashMap<String, GrpcServerController>();
        private static final Lock f_lock = new ReentrantLock();

        public void preStart(Context ctx) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void postStart(Context ctx) {
            if (Config.getBoolean((String)"coherence.grpc.enabled", (boolean)true)) {
                f_lock.lock();
                try {
                    ContainerContext containerContext = ctx.getContainerContext();
                    String sScopePrefix = ServiceScheme.getScopePrefix((String)ctx.getApplicationName(), (ContainerContext)containerContext);
                    GrpcServerController controller = f_mapDomainController.computeIfAbsent(sScopePrefix, k -> "".equals(sScopePrefix) && "".equals(ctx.getApplicationName()) ? INSTANCE : new GrpcServerController(ctx));
                    controller.start();
                }
                finally {
                    f_lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void preStop(Context ctx) {
            f_lock.lock();
            try {
                ContainerContext containerContext = ctx.getContainerContext();
                String sScopePrefix = ServiceScheme.getScopePrefix((String)ctx.getApplicationName(), (ContainerContext)containerContext);
                GrpcServerController controller = f_mapDomainController.get(sScopePrefix);
                if (controller != null && Objects.equals((Object)ctx, (Object)controller.f_context)) {
                    f_mapDomainController.remove(sScopePrefix);
                    controller.stop();
                }
            }
            finally {
                f_lock.unlock();
            }
        }

        public void postStop(Context ctx) {
        }
    }
}

