/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy;

import com.tangosol.internal.util.DaemonPool;
import com.tangosol.internal.util.DaemonPoolDependencies;
import com.tangosol.run.xml.XmlElement;
import io.grpc.Context;
import io.opentracing.Span;
import io.opentracing.contrib.grpc.OpenTracingContextKey;
import io.opentracing.util.GlobalTracer;
import java.util.function.Supplier;

class TracingDaemonPool
implements DaemonPool {
    protected final DaemonPool f_delegate;
    protected final Supplier<Span> f_activeSpan;

    TracingDaemonPool(DaemonPool delegate) {
        this(delegate, null);
    }

    TracingDaemonPool(DaemonPool delegate, Supplier<Span> supplier) {
        this.f_delegate = delegate;
        this.f_activeSpan = supplier == null ? () -> GlobalTracer.get().activeSpan() : supplier;
    }

    public void add(Runnable task) {
        Span span = this.findSpan();
        long hash = task.hashCode();
        if (span != null) {
            span.log("adding to daemon pool task=" + hash);
            this.f_delegate.add((Runnable)new TracingRunnable(span, task));
        } else {
            this.f_delegate.add(task);
        }
    }

    public DaemonPoolDependencies getDependencies() {
        return this.f_delegate.getDependencies();
    }

    public void setDependencies(DaemonPoolDependencies deps) {
        this.f_delegate.setDependencies(deps);
    }

    public boolean isRunning() {
        return this.f_delegate.isRunning();
    }

    public boolean isStuck() {
        return this.f_delegate.isStuck();
    }

    public void schedule(Runnable task, long cMillis) {
        Span span = this.findSpan();
        long hash = task.hashCode();
        if (span != null) {
            span.log("scheduling in daemon pool in " + cMillis + " task=" + hash);
            this.f_delegate.schedule((Runnable)new TracingRunnable(span, task), cMillis);
        } else {
            this.f_delegate.schedule(task, cMillis);
        }
    }

    public void shutdown() {
        this.f_delegate.shutdown();
    }

    public void start() {
        this.f_delegate.start();
    }

    public void stop() {
        this.f_delegate.stop();
    }

    public void configure(XmlElement xml) {
        this.f_delegate.configure(xml);
    }

    public ClassLoader getContextClassLoader() {
        return this.f_delegate.getContextClassLoader();
    }

    public void setContextClassLoader(ClassLoader loader) {
        this.f_delegate.setContextClassLoader(loader);
    }

    protected Span findSpan() {
        Context context;
        Span span = this.f_activeSpan.get();
        if (span == null && (context = Context.current()) != null) {
            span = (Span)OpenTracingContextKey.getKey().get(context);
        }
        return span;
    }

    protected DaemonPool getDelegate() {
        return this.f_delegate;
    }

    protected static class TracingRunnable
    implements Runnable {
        protected final Span f_span;
        protected final Runnable f_delegate;
        protected final long f_lHash;

        protected TracingRunnable(Span span, Runnable delegate) {
            this.f_span = span;
            this.f_delegate = delegate;
            this.f_lHash = delegate.hashCode();
        }

        @Override
        public void run() {
            GlobalTracer.get().scopeManager().activate(this.f_span);
            this.f_span.log("starting execution in daemon pool task=" + this.f_lHash);
            this.f_delegate.run();
            this.f_span.log("finished execution in daemon pool task=" + this.f_lHash);
        }

        protected Runnable getDelegate() {
            return this.f_delegate;
        }
    }
}

