/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy;

import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.UnsafeByteOperations;
import com.oracle.coherence.grpc.BinaryHelper;
import com.oracle.coherence.grpc.EntryResult;
import com.oracle.coherence.grpc.PageRequest;
import com.oracle.coherence.grpc.proxy.CacheRequestHolder;
import com.oracle.coherence.grpc.proxy.ErrorsHelper;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.CacheService;
import com.tangosol.net.Member;
import com.tangosol.net.NamedCache;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.Service;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryWriteBuffer;
import com.tangosol.util.Filter;
import com.tangosol.util.Filters;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.filter.PartitionedFilter;
import io.grpc.Status;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

final class PagedQueryHelper {
    private PagedQueryHelper() {
    }

    static Stream<BytesValue> keysPagedQuery(CacheRequestHolder<PageRequest, ?> holder, long cTransferThreshold) {
        try {
            return PagedQueryHelper.pagedQuery(holder, true, cTransferThreshold);
        }
        catch (Throwable t) {
            throw ErrorsHelper.ensureStatusRuntimeException(t);
        }
    }

    static Stream<EntryResult> entryPagedQuery(CacheRequestHolder<PageRequest, ?> holder, long cTransferThreshold) {
        try {
            return PagedQueryHelper.pagedQuery(holder, false, cTransferThreshold);
        }
        catch (Throwable t) {
            throw ErrorsHelper.ensureStatusRuntimeException(t);
        }
    }

    private static <T> Stream<T> pagedQuery(CacheRequestHolder<PageRequest, ?> holder, boolean fKeysOnly, long cTransferThreshold) {
        Set set;
        NamedCache<Binary, Binary> cache = holder.getCache();
        ByteString cookie = holder.getRequest().getCookie();
        CacheService service = cache.getCacheService();
        Object[] oaCookieData = PagedQueryHelper.decodeCookie((Service)service, cookie);
        PartitionSet parts = (PartitionSet)oaCookieData[0];
        int cBatch = (Integer)oaCookieData[1];
        int cPart = parts.getPartitionCount();
        Filter filter = Filters.always();
        if (cBatch == 0) {
            set = PagedQueryHelper.query(cache, (Filter<Binary>)filter, fKeysOnly, parts, 1, null);
            int cb = PagedQueryHelper.calculateBinarySize(set, fKeysOnly);
            cBatch = PagedQueryHelper.calculateBatchSize(cPart, cb, cTransferThreshold);
            if (cBatch > 1 && cPart > 1) {
                set = PagedQueryHelper.query(cache, (Filter<Binary>)filter, fKeysOnly, parts, cBatch - 1, set);
            }
        } else {
            set = PagedQueryHelper.query(cache, (Filter<Binary>)filter, fKeysOnly, parts, cBatch, null);
        }
        ByteString newCookie = PagedQueryHelper.encodeCookie(parts, cBatch);
        if (fKeysOnly) {
            return Stream.concat(Stream.of(BytesValue.of((ByteString)newCookie)), set.stream().map(bin -> BinaryHelper.toBytesValue((Binary)holder.convertUp((Binary)bin))));
        }
        EntryResult first = EntryResult.newBuilder().setCookie(newCookie).build();
        return Stream.concat(Stream.of(first), set.stream().map(holder::toEntryResult));
    }

    private static int calculateBinarySize(Collection col, boolean fKeysOnly) {
        int size = 0;
        if (col != null) {
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                if (fKeysOnly) {
                    size += ((Binary)iter.next()).length();
                    continue;
                }
                Map.Entry entry = (Map.Entry)iter.next();
                size += ((Binary)entry.getKey()).length();
                size += ((Binary)entry.getValue()).length();
            }
        }
        return size;
    }

    private static int calculateBatchSize(int cPart, int cb, long transferThreshold) {
        int cBatch = cb == 0 ? cPart : (int)(transferThreshold / (long)cb);
        cBatch = Math.max(cBatch, 1);
        cBatch = Math.min(cBatch, cPart);
        return cBatch;
    }

    private static Set query(NamedCache<Binary, Binary> cache, Filter<Binary> filter, boolean keysOnly, PartitionSet partsRemain, int cBatch, Set setResult) {
        Set set;
        PartitionSet partsBatch = PagedQueryHelper.removePartitionBatch(cache.getCacheService(), partsRemain, cBatch);
        filter = new PartitionedFilter(filter, partsBatch);
        Set set2 = set = keysOnly ? cache.keySet((Filter)filter) : cache.entrySet((Filter)filter);
        if (setResult == null || setResult.isEmpty()) {
            setResult = set;
        } else if (!set.isEmpty()) {
            Object[] aoOld = setResult.toArray();
            Object[] aoNew = set.toArray();
            int cOld = aoOld.length;
            int cNew = aoNew.length;
            int cAll = cOld + cNew;
            Object[] aoAll = new Object[cAll];
            System.arraycopy(aoOld, 0, aoAll, 0, cOld);
            System.arraycopy(aoNew, 0, aoAll, cOld, cNew);
            setResult = new ImmutableArrayList(aoAll);
        }
        return setResult;
    }

    private static PartitionSet removePartitionBatch(CacheService service, PartitionSet partsRemain, int cBatch) {
        PartitionSet partsBatch;
        int cPartsAll = partsRemain.getPartitionCount();
        int cPartsRemain = partsRemain.cardinality();
        if (cPartsRemain <= cBatch) {
            partsBatch = new PartitionSet(partsRemain);
            partsRemain.clear();
        } else {
            partsBatch = new PartitionSet(cPartsAll);
            if (service instanceof PartitionedService) {
                int c;
                PartitionedService svcPartitioned = (PartitionedService)service;
                for (int cBatchLeft = cBatch; !partsRemain.isEmpty() && cBatchLeft > 0; cBatchLeft -= c) {
                    int nPart = partsRemain.rnd();
                    Member member = null;
                    for (int i = 0; i < cPartsRemain && (member = svcPartitioned.getPartitionOwner(nPart)) == null; ++i) {
                        nPart = partsRemain.next(nPart);
                    }
                    if (member == null) break;
                    PartitionSet parts = svcPartitioned.getOwnedPartitions(member);
                    parts.retain(partsRemain);
                    for (c = parts.cardinality(); c > cBatchLeft; --c) {
                        parts.removeNext(0);
                    }
                    partsBatch.add(parts);
                    partsRemain.remove(parts);
                }
            }
            if (partsBatch.isEmpty()) {
                int nPart = partsRemain.rnd();
                while (--cBatch >= 0 && (nPart = partsRemain.removeNext(nPart)) >= 0) {
                    partsBatch.add(nPart);
                }
            }
        }
        return partsBatch;
    }

    static Object[] decodeCookie(Service service, ByteString cookie) {
        int nPage;
        PartitionSet parts;
        if (cookie == null || cookie.isEmpty()) {
            if (!(service instanceof PartitionedService)) {
                throw Status.FAILED_PRECONDITION.withDescription("Service is not a PartitionedService").asRuntimeException();
            }
            int cParts = ((PartitionedService)service).getPartitionCount();
            PartitionSet parts2 = new PartitionSet(cParts);
            parts2.fill();
            return new Object[]{parts2, 0};
        }
        try {
            ReadBuffer.BufferInput in = BinaryHelper.toReadBuffer((ByteString)cookie).getBufferInput();
            parts = new PartitionSet();
            parts.readExternal((DataInput)in);
            nPage = in.readPackedInt();
        }
        catch (IOException e) {
            throw ErrorsHelper.ensureStatusRuntimeException(e, "error decoding cookie");
        }
        return new Object[]{parts, nPage};
    }

    static ByteString encodeCookie(PartitionSet parts, int page) {
        if (parts.isEmpty()) {
            return BinaryHelper.EMPTY_BYTE_STRING;
        }
        WriteBuffer.BufferOutput out = new BinaryWriteBuffer(64).getBufferOutput();
        try {
            parts.writeExternal((DataOutput)out);
            out.writePackedInt(page);
        }
        catch (IOException e) {
            throw ErrorsHelper.ensureStatusRuntimeException(e, "error encoding cookie");
        }
        return UnsafeByteOperations.unsafeWrap((ByteBuffer)out.getBuffer().getReadBuffer().toByteBuffer());
    }
}

