/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy;

import com.oracle.coherence.grpc.proxy.TracingDaemonPool;
import com.tangosol.coherence.component.util.DaemonPool;
import com.tangosol.internal.util.DaemonPoolDependencies;
import com.tangosol.internal.util.Daemons;
import com.tangosol.internal.util.DefaultDaemonPoolDependencies;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.management.AnnotatedStandardMBean;
import com.tangosol.net.management.Registry;
import com.tangosol.net.management.annotation.Description;
import com.tangosol.net.management.annotation.MetricsValue;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Controllable;
import io.helidon.config.Config;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;

public class DaemonPoolExecutor
implements Executor,
Controllable {
    static final String CONFIG_THREAD_COUNT = "thread_count";
    static final String CONFIG_THREAD_COUNT_MIN = "thread_count_min";
    static final String CONFIG_THREAD_COUNT_MAX = "thread_count_max";
    protected final TracingDaemonPool f_pool;
    protected final Supplier<Registry> f_registrySupplier;

    protected DaemonPoolExecutor(com.tangosol.internal.util.DaemonPool pool, Supplier<Registry> registrySupplier) {
        this.f_pool = new TracingDaemonPool(pool);
        this.f_registrySupplier = registrySupplier;
    }

    protected static DaemonPoolExecutor create() {
        return DaemonPoolExecutor.create(Config.empty());
    }

    protected static DaemonPoolExecutor create(Config config) {
        return DaemonPoolExecutor.builder(config).build();
    }

    protected static Builder builder() {
        return DaemonPoolExecutor.builder(Config.empty());
    }

    protected static Builder builder(Config config) {
        return new Builder(config);
    }

    @Override
    public void execute(Runnable command) {
        this.f_pool.add(command);
    }

    public void configure(XmlElement xmlElement) {
        this.f_pool.configure(xmlElement);
    }

    public void start() {
        this.f_pool.start();
        this.registerMBean();
    }

    public boolean isRunning() {
        return this.f_pool.isRunning();
    }

    boolean isStuck() {
        return this.f_pool.isStuck();
    }

    public void shutdown() {
        this.f_pool.shutdown();
        this.unregisterMBean();
    }

    public void stop() {
        this.f_pool.stop();
        this.unregisterMBean();
    }

    public ClassLoader getContextClassLoader() {
        return this.f_pool.getContextClassLoader();
    }

    public void setContextClassLoader(ClassLoader loader) {
        this.f_pool.setContextClassLoader(loader);
    }

    protected void registerMBean() {
        try {
            Registry registry = this.f_registrySupplier.get();
            if (registry != null) {
                DaemonPoolManagement mBean = new DaemonPoolManagement(this.f_pool.getDelegate());
                String globalName = registry.ensureGlobalName("type=DaemonPool,name=" + this.f_pool.getDependencies().getName());
                registry.register(globalName, (Object)new AnnotatedStandardMBean((Object)mBean, DaemonPoolManagementMBean.class));
            }
        }
        catch (Throwable t) {
            CacheFactory.err((Throwable)t);
        }
    }

    protected void unregisterMBean() {
        Registry registry = this.f_registrySupplier.get();
        if (registry != null) {
            String globalName = registry.ensureGlobalName("type=DaemonPool,name=" + this.f_pool.getDependencies().getName());
            registry.unregister(globalName);
        }
    }

    protected static class DaemonPoolManagement
    implements DaemonPoolManagementMBean {
        protected final DaemonPool pool;

        protected DaemonPoolManagement(com.tangosol.internal.util.DaemonPool pool) {
            this.pool = (DaemonPool)pool;
        }

        @Override
        public int getBacklog() {
            return this.pool.getBacklog();
        }

        @Override
        public int getDaemonCountMax() {
            return this.pool.getDaemonCountMax();
        }

        @Override
        public void setDaemonCountMax(int count) {
            this.pool.setDaemonCountMax(count);
        }

        @Override
        public int getDaemonCountMin() {
            return this.pool.getDaemonCountMin();
        }

        @Override
        public void setDaemonCountMin(int count) {
            this.pool.setDaemonCountMin(count);
        }

        @Override
        public int getDaemonCount() {
            return this.pool.getDaemonCount();
        }

        @Override
        public int getAbandonedCount() {
            return this.pool.getStatsAbandonedCount();
        }

        @Override
        public long getActiveMillis() {
            return this.pool.getStatsActiveMillis();
        }

        @Override
        public int getHungCount() {
            return this.pool.getStatsHungCount();
        }

        @Override
        public long getHungDuration() {
            return this.pool.getStatsHungDuration();
        }

        @Override
        public long getLastResetMillis() {
            return this.pool.getStatsLastResetMillis();
        }

        @Override
        public long getLastResizeMillis() {
            return this.pool.getStatsLastResizeMillis();
        }

        @Override
        public long getTaskAddCount() {
            return this.pool.getStatsTaskAddCount().longValue();
        }

        @Override
        public long getTaskCount() {
            return this.pool.getStatsTaskCount();
        }

        @Override
        public int getMaxBacklog() {
            return this.pool.getStatsMaxBacklog();
        }

        @Override
        public int getTimeoutCount() {
            return this.pool.getStatsTimeoutCount();
        }

        @Override
        public long getTaskTimeout() {
            return this.pool.getTaskTimeout();
        }

        @Override
        public void resetStatistics() {
            this.pool.resetStats();
        }
    }

    public static interface DaemonPoolManagementMBean {
        @MetricsValue(value="backlog")
        @Description(value="The number of tasks that have been added to the pool, but not yet scheduled for execution")
        public int getBacklog();

        @MetricsValue(value="max_daemon_count")
        @Description(value="The maximum number of Daemon threads that could exist")
        public int getDaemonCountMax();

        public void setDaemonCountMax(int var1);

        @MetricsValue(value="min_daemon_count")
        @Description(value="The minimum number of Daemon threads that should exist")
        public int getDaemonCountMin();

        public void setDaemonCountMin(int var1);

        @MetricsValue(value="daemon_count")
        @Description(value="The number of Daemon threads that exist")
        public int getDaemonCount();

        @MetricsValue(value="abandoned_count")
        @Description(value="The total number of abandoned Daemon threads")
        public int getAbandonedCount();

        public long getActiveMillis();

        @MetricsValue(value="hung_count")
        @Description(value="The total number of currently executing hung tasks")
        public int getHungCount();

        @MetricsValue(value="hung_duration")
        @Description(value="The longest currently executing hung task duration (in milliseconds)")
        public long getHungDuration();

        public long getLastResetMillis();

        public long getLastResizeMillis();

        @MetricsValue(value="task_added_count")
        @Description(value="The total number of tasks added to the pool since the last time the statistics were reset")
        public long getTaskAddCount();

        @MetricsValue(value="task_count")
        @Description(value="The total number of tasks executed by Daemon threads since the last time the statistics were reset")
        public long getTaskCount();

        @MetricsValue(value="max_backlog_count")
        @Description(value="The maximum backlog value since the last time the statistics were reset")
        public int getMaxBacklog();

        @MetricsValue(value="timeout_count")
        @Description(value="The total number of timed-out tasks since the last time the statistics were reset")
        public int getTimeoutCount();

        public long getTaskTimeout();

        public void resetStatistics();
    }

    public static class Builder
    implements io.helidon.common.Builder<DaemonPoolExecutor> {
        private final Config f_config;
        private Optional<String> m_optName = Optional.empty();
        private Optional<Function<DaemonPoolDependencies, com.tangosol.internal.util.DaemonPool>> m_optSupplier = Optional.empty();
        private Supplier<Registry> m_registry = () -> CacheFactory.ensureCluster().getManagement();

        protected Builder(Config config) {
            this.f_config = config;
        }

        public Builder name(String name) {
            this.m_optName = Optional.ofNullable(name);
            return this;
        }

        public Builder supplier(Function<DaemonPoolDependencies, com.tangosol.internal.util.DaemonPool> supplier) {
            this.m_optSupplier = Optional.ofNullable(supplier);
            return this;
        }

        public Builder registry(Supplier<Registry> supplier) {
            this.m_registry = supplier;
            return this;
        }

        public Builder registry(Registry registry) {
            return this.registry(() -> registry);
        }

        public DaemonPoolExecutor build() {
            DefaultDaemonPoolDependencies dependencies = new DefaultDaemonPoolDependencies();
            dependencies.setThreadCount(1);
            this.m_optName.ifPresent(arg_0 -> ((DefaultDaemonPoolDependencies)dependencies).setName(arg_0));
            this.f_config.get(DaemonPoolExecutor.CONFIG_THREAD_COUNT).asInt().ifPresent(arg_0 -> ((DefaultDaemonPoolDependencies)dependencies).setThreadCount(arg_0));
            this.f_config.get(DaemonPoolExecutor.CONFIG_THREAD_COUNT_MIN).asInt().ifPresent(arg_0 -> ((DefaultDaemonPoolDependencies)dependencies).setThreadCountMin(arg_0));
            this.f_config.get(DaemonPoolExecutor.CONFIG_THREAD_COUNT_MAX).asInt().ifPresent(arg_0 -> ((DefaultDaemonPoolDependencies)dependencies).setThreadCountMax(arg_0));
            com.tangosol.internal.util.DaemonPool pool = this.m_optSupplier.orElse(Daemons::newDaemonPool).apply((DaemonPoolDependencies)dependencies);
            return new DaemonPoolExecutor(pool, this.m_registry);
        }
    }
}

