/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy.helidon;

import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Empty;
import com.google.protobuf.Int32Value;
import com.oracle.coherence.grpc.AddIndexRequest;
import com.oracle.coherence.grpc.AggregateRequest;
import com.oracle.coherence.grpc.BinaryHelper;
import com.oracle.coherence.grpc.CacheRequestHolder;
import com.oracle.coherence.grpc.ContainsEntryRequest;
import com.oracle.coherence.grpc.ContainsKeyRequest;
import com.oracle.coherence.grpc.ContainsValueRequest;
import com.oracle.coherence.grpc.Entry;
import com.oracle.coherence.grpc.EntryResult;
import com.oracle.coherence.grpc.EntrySetRequest;
import com.oracle.coherence.grpc.ErrorsHelper;
import com.oracle.coherence.grpc.GetAllRequest;
import com.oracle.coherence.grpc.GetRequest;
import com.oracle.coherence.grpc.InvokeAllRequest;
import com.oracle.coherence.grpc.InvokeRequest;
import com.oracle.coherence.grpc.IsEmptyRequest;
import com.oracle.coherence.grpc.IsReadyRequest;
import com.oracle.coherence.grpc.KeySetRequest;
import com.oracle.coherence.grpc.OptionalValue;
import com.oracle.coherence.grpc.PageRequest;
import com.oracle.coherence.grpc.PutAllRequest;
import com.oracle.coherence.grpc.PutIfAbsentRequest;
import com.oracle.coherence.grpc.PutRequest;
import com.oracle.coherence.grpc.RemoveIndexRequest;
import com.oracle.coherence.grpc.RemoveMappingRequest;
import com.oracle.coherence.grpc.RemoveRequest;
import com.oracle.coherence.grpc.ReplaceMappingRequest;
import com.oracle.coherence.grpc.ReplaceRequest;
import com.oracle.coherence.grpc.RequestHolder;
import com.oracle.coherence.grpc.SafeStreamObserver;
import com.oracle.coherence.grpc.SizeRequest;
import com.oracle.coherence.grpc.TruncateRequest;
import com.oracle.coherence.grpc.ValuesRequest;
import com.oracle.coherence.grpc.proxy.common.BaseNamedCacheServiceImpl;
import com.oracle.coherence.grpc.proxy.common.NamedCacheService;
import com.oracle.coherence.grpc.proxy.common.PagedQueryHelper;
import com.oracle.coherence.grpc.proxy.common.ResponseHandlers;
import com.tangosol.internal.util.processor.BinaryProcessors;
import com.tangosol.internal.util.processor.CacheProcessors;
import com.tangosol.io.Serializer;
import com.tangosol.net.AsyncNamedCache;
import com.tangosol.net.NamedCache;
import com.tangosol.net.PartitionedService;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.Filters;
import com.tangosol.util.InvocableMap;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HelidonNamedCacheService
extends BaseNamedCacheServiceImpl
implements NamedCacheService {
    public HelidonNamedCacheService(NamedCacheService.Dependencies dependencies) {
        super(dependencies);
    }

    public static HelidonNamedCacheService newInstance(NamedCacheService.Dependencies deps) {
        return new HelidonNamedCacheService(deps);
    }

    public void addIndex(AddIndexRequest request, StreamObserver<Empty> observer) {
        Throwable err = null;
        try {
            CacheRequestHolder holder = this.createRequestHolder(request, request.getScope(), request.getCache(), request.getFormat());
            this.addIndex(holder);
        }
        catch (Throwable e) {
            err = e;
        }
        ResponseHandlers.handleUnary((Object)Empty.getDefaultInstance(), (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver(observer));
    }

    public void aggregate(AggregateRequest request, StreamObserver<BytesValue> observer) {
        StreamObserver safeObserver = SafeStreamObserver.ensureSafeObserver(observer);
        ByteString processorBytes = request.getAggregator();
        if (processorBytes.isEmpty()) {
            safeObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("the request does not contain a serialized ValueExtractor").asRuntimeException());
        } else {
            try {
                if (request.getKeysCount() != 0) {
                    this.aggregateWithKeys(request, this.f_executor).handleAsync((result, err) -> ResponseHandlers.handleUnary((Object)result, (Throwable)err, (StreamObserver)safeObserver), this.f_executor).toCompletableFuture().join();
                } else {
                    this.aggregateWithFilter(request, this.f_executor).handleAsync((result, err) -> ResponseHandlers.handleUnary((Object)result, (Throwable)err, (StreamObserver)safeObserver), this.f_executor).toCompletableFuture().join();
                }
            }
            catch (Throwable t) {
                safeObserver.onError((Throwable)ErrorsHelper.ensureStatusRuntimeException((Throwable)t));
            }
        }
    }

    public void containsEntry(ContainsEntryRequest request, StreamObserver<BoolValue> observer) {
        BoolValue result = null;
        Throwable error = null;
        try {
            CacheRequestHolder holder = this.createRequestHolder(request, request.getScope(), request.getCache(), request.getFormat());
            Binary key = holder.convertKeyDown(request.getKey());
            Binary value = holder.convertDown(request.getValue());
            InvocableMap.EntryProcessor processor = this.castProcessor((InvocableMap.EntryProcessor)new BinaryProcessors.BinaryContainsValueProcessor(value));
            Binary binary = (Binary)holder.getCache().invoke((Object)key, processor);
            result = this.toBoolValue(binary, holder.getCacheSerializer());
        }
        catch (Throwable e) {
            error = e;
        }
        ResponseHandlers.handleUnary(result, (Throwable)error, (StreamObserver)SafeStreamObserver.ensureSafeObserver(observer));
    }

    public void containsKey(ContainsKeyRequest request, StreamObserver<BoolValue> observer) {
        BoolValue result = null;
        Throwable error = null;
        try {
            CacheRequestHolder holder = this.createRequestHolder(request, request.getScope(), request.getCache(), request.getFormat());
            Binary key = holder.convertKeyDown(request.getKey());
            boolean fResult = holder.getCache().containsKey((Object)key);
            result = BoolValue.of((boolean)fResult);
        }
        catch (Throwable e) {
            error = e;
        }
        ResponseHandlers.handleUnary(result, (Throwable)error, (StreamObserver)SafeStreamObserver.ensureSafeObserver(observer));
    }

    public void containsValue(ContainsValueRequest request, StreamObserver<BoolValue> observer) {
        BoolValue result = null;
        Throwable error = null;
        try {
            CacheRequestHolder holder = this.createRequestHolder(request, request.getScope(), request.getCache(), request.getFormat());
            Binary value = holder.convertDown(request.getValue());
            boolean fPresent = holder.getCache().containsValue((Object)value);
            result = BoolValue.of((boolean)fPresent);
        }
        catch (Throwable e) {
            error = e;
        }
        ResponseHandlers.handleUnary(result, (Throwable)error, (StreamObserver)SafeStreamObserver.ensureSafeObserver(observer));
    }

    public void entrySet(EntrySetRequest request, StreamObserver<Entry> observer) {
        StreamObserver safeObserver = SafeStreamObserver.ensureSafeObserver(observer);
        try {
            CacheRequestHolder holder = this.createRequestHolder(request, request.getScope(), request.getCache(), request.getFormat());
            Serializer serializer = holder.getSerializer();
            Filter filter = this.ensureFilter(request.getFilter(), serializer);
            Comparator comparator = this.deserializeComparator(request.getComparator(), serializer);
            if (comparator == null) {
                holder.getAsyncCache().entrySet(filter, holder.entryConsumer(safeObserver)).join();
                safeObserver.onCompleted();
            } else {
                Set entries = holder.getCache().entrySet(filter, comparator);
                ResponseHandlers.handleStreamOfEntries((RequestHolder)holder, entries.stream(), (StreamObserver)safeObserver);
            }
        }
        catch (Throwable t) {
            safeObserver.onError((Throwable)ErrorsHelper.ensureStatusRuntimeException((Throwable)t));
        }
    }

    public void get(GetRequest request, StreamObserver<OptionalValue> observer) {
        OptionalValue result = null;
        Throwable error = null;
        try {
            CacheRequestHolder holder = this.createRequestHolder(request, request.getScope(), request.getCache(), request.getFormat());
            Binary key = holder.convertKeyDown(((GetRequest)holder.getRequest()).getKey());
            Binary binary = (Binary)holder.getCache().get((Object)key);
            result = holder.toOptionalValue(binary);
        }
        catch (Throwable e) {
            error = e;
        }
        ResponseHandlers.handleUnary(result, (Throwable)error, (StreamObserver)SafeStreamObserver.ensureSafeObserver(observer));
    }

    public void getAll(GetAllRequest request, StreamObserver<Entry> observer) {
        StreamObserver safeObserver = SafeStreamObserver.ensureSafeObserver(observer);
        try {
            List listKey = request.getKeyList();
            if (!listKey.isEmpty()) {
                CacheRequestHolder holder = this.createRequestHolder(request, request.getScope(), request.getCache(), request.getFormat());
                Consumer callback = holder.entryConsumer(observer);
                List<Binary> listKeys = listKey.stream().map(arg_0 -> ((CacheRequestHolder)holder).convertKeyDown(arg_0)).toList();
                holder.getAsyncCache().invokeAll(listKeys, BinaryProcessors.get(), callback).join();
            }
            safeObserver.onCompleted();
        }
        catch (Throwable e) {
            safeObserver.onError(e);
        }
    }

    public void invoke(InvokeRequest request, StreamObserver<BytesValue> observer) {
        BytesValue result = null;
        Throwable error = null;
        try {
            ByteString processorBytes = request.getProcessor();
            if (!processorBytes.isEmpty()) {
                CacheRequestHolder holder = this.createRequestHolder(request, request.getScope(), request.getCache(), request.getFormat());
                Binary key = holder.convertKeyDown(request.getKey());
                InvocableMap.EntryProcessor processor = (InvocableMap.EntryProcessor)BinaryHelper.fromByteString((ByteString)request.getProcessor(), (Serializer)holder.getSerializer());
                Binary binary = (Binary)holder.getCache().invoke((Object)key, processor);
                result = holder.toBytesValue(binary);
            } else {
                error = Status.INVALID_ARGUMENT.withDescription("the request does not contain a serialized entry processor").asRuntimeException();
            }
        }
        catch (Throwable e) {
            error = e;
        }
        ResponseHandlers.handleUnary(result, (Throwable)error, (StreamObserver)SafeStreamObserver.ensureSafeObserver(observer));
    }

    public void invokeAll(InvokeAllRequest request, StreamObserver<Entry> observer) {
        StreamObserver safeObserver = SafeStreamObserver.ensureSafeObserver(observer);
        try {
            ByteString processorBytes = request.getProcessor();
            if (processorBytes.isEmpty()) {
                StatusRuntimeException error = Status.INVALID_ARGUMENT.withDescription("the request does not contain a serialized entry processor").asRuntimeException();
                safeObserver.onError((Throwable)error);
            } else {
                CacheRequestHolder holder = this.createRequestHolder(request, request.getScope(), request.getCache(), request.getFormat());
                if (request.getKeysCount() != 0) {
                    this.invokeAllWithKeys((CacheRequestHolder<InvokeAllRequest, Void>)holder, (StreamObserver<Entry>)safeObserver);
                } else {
                    this.invokeAllWithFilter((CacheRequestHolder<InvokeAllRequest, Void>)holder, (StreamObserver<Entry>)safeObserver);
                }
            }
        }
        catch (Throwable e) {
            safeObserver.onError(e);
        }
    }

    protected void invokeAllWithKeys(CacheRequestHolder<InvokeAllRequest, Void> holder, StreamObserver<Entry> observer) {
        Throwable error = null;
        try {
            InvokeAllRequest request = (InvokeAllRequest)holder.getRequest();
            List keys = request.getKeysList().stream().map(arg_0 -> holder.convertKeyDown(arg_0)).collect(Collectors.toList());
            InvocableMap.EntryProcessor processor = (InvocableMap.EntryProcessor)BinaryHelper.fromByteString((ByteString)request.getProcessor(), (Serializer)holder.getSerializer());
            Consumer callback = holder.entryConsumer(observer);
            holder.getAsyncCache().invokeAll(keys, processor, callback).join();
        }
        catch (Throwable e) {
            error = e;
        }
        ResponseHandlers.handleErrorOrComplete((Throwable)error, observer);
    }

    protected void invokeAllWithFilter(CacheRequestHolder<InvokeAllRequest, Void> holder, StreamObserver<Entry> observer) {
        Throwable error = null;
        try {
            InvokeAllRequest request = (InvokeAllRequest)holder.getRequest();
            ByteString filterBytes = request.getFilter();
            Filter filter = filterBytes.isEmpty() ? Filters.always() : (Filter)BinaryHelper.fromByteString((ByteString)filterBytes, (Serializer)holder.getSerializer());
            ByteString processorBytes = request.getProcessor();
            InvocableMap.EntryProcessor processor = (InvocableMap.EntryProcessor)BinaryHelper.fromByteString((ByteString)processorBytes, (Serializer)holder.getSerializer());
            Consumer callback = holder.entryConsumer(observer);
            holder.getAsyncCache().invokeAll(filter, processor, callback).join();
        }
        catch (Throwable e) {
            error = e;
        }
        ResponseHandlers.handleErrorOrComplete((Throwable)error, observer);
    }

    public void isEmpty(IsEmptyRequest request, StreamObserver<BoolValue> observer) {
        BoolValue result = null;
        Throwable error = null;
        try {
            NamedCache cache = this.getCache(request.getScope(), request.getCache(), true);
            result = BoolValue.of((boolean)cache.isEmpty());
        }
        catch (Throwable e) {
            error = e;
        }
        ResponseHandlers.handleUnary(result, (Throwable)error, (StreamObserver)SafeStreamObserver.ensureSafeObserver(observer));
    }

    public void isReady(IsReadyRequest request, StreamObserver<BoolValue> observer) {
        BoolValue result = null;
        Throwable error = null;
        try {
            NamedCache cache = this.getCache(request.getScope(), request.getCache(), true);
            result = BoolValue.of((boolean)cache.isReady());
        }
        catch (Throwable e) {
            error = e;
        }
        ResponseHandlers.handleUnary(result, (Throwable)error, (StreamObserver)SafeStreamObserver.ensureSafeObserver(observer));
    }

    public void keySet(KeySetRequest request, StreamObserver<BytesValue> observer) {
        StreamObserver safeObserver = SafeStreamObserver.ensureSafeObserver(observer);
        Throwable error = null;
        try {
            CacheRequestHolder holder = this.createRequestHolder(request, request.getScope(), request.getCache(), request.getFormat());
            Serializer serializer = holder.getSerializer();
            Filter filter = this.ensureFilter(request.getFilter(), serializer);
            Consumer callback = holder.binaryConsumer(safeObserver);
            holder.getAsyncCache().keySet(filter, callback).join();
        }
        catch (Throwable t) {
            error = t;
        }
        ResponseHandlers.handleErrorOrComplete((Throwable)error, (StreamObserver)safeObserver);
    }

    public void nextKeySetPage(PageRequest request, StreamObserver<BytesValue> observer) {
        Stream stream = null;
        Throwable error = null;
        try {
            CacheRequestHolder holder = this.createRequestHolder(request, request.getScope(), request.getCache(), request.getFormat());
            stream = PagedQueryHelper.keysPagedQuery((CacheRequestHolder)holder, (long)this.getTransferThreshold());
        }
        catch (Throwable e) {
            error = e;
        }
        ResponseHandlers.handleStream(stream, (Throwable)error, (StreamObserver)SafeStreamObserver.ensureSafeObserver(observer));
    }

    public void nextEntrySetPage(PageRequest request, StreamObserver<EntryResult> observer) {
        Stream stream = null;
        Throwable error = null;
        try {
            CacheRequestHolder holder = this.createRequestHolder(request, request.getScope(), request.getCache(), request.getFormat());
            stream = PagedQueryHelper.entryPagedQuery((CacheRequestHolder)holder, (long)this.getTransferThreshold());
        }
        catch (Throwable e) {
            error = e;
        }
        ResponseHandlers.handleStream(stream, (Throwable)error, (StreamObserver)SafeStreamObserver.ensureSafeObserver(observer));
    }

    public void put(PutRequest request, StreamObserver<BytesValue> observer) {
        BytesValue result = null;
        Throwable error = null;
        try {
            CacheRequestHolder holder = this.createRequestHolder(request, request.getScope(), request.getCache(), request.getFormat());
            Binary key = holder.convertKeyDown(request.getKey());
            Binary value = holder.convertDown(request.getValue());
            Binary binary = (Binary)holder.getCache().put((Object)key, (Object)value, request.getTtl());
            result = holder.toBytesValue(binary);
        }
        catch (Throwable e) {
            error = e;
        }
        ResponseHandlers.handleUnary(result, (Throwable)error, (StreamObserver)SafeStreamObserver.ensureSafeObserver(observer));
    }

    public void putAll(PutAllRequest request, StreamObserver<Empty> observer) {
        Throwable error = null;
        try {
            CacheRequestHolder holder = this.createRequestHolder(request, request.getScope(), request.getCache(), request.getFormat());
            if (request.getEntryCount() > 0) {
                HashMap<Binary, Binary> map = new HashMap<Binary, Binary>();
                for (Entry entry : request.getEntryList()) {
                    Binary key = holder.convertKeyDown(entry.getKey());
                    Binary value = holder.convertDown(entry.getValue());
                    map.put(key, value);
                }
                NamedCache cache = holder.getCache();
                if (cache.getCacheService() instanceof PartitionedService) {
                    this.partitionedPutAll(holder, map).toCompletableFuture().join();
                } else {
                    cache.invokeAll(map.keySet(), BinaryProcessors.putAll(map, (long)request.getTtl()));
                }
            }
        }
        catch (Throwable e) {
            error = e;
        }
        ResponseHandlers.handleUnary((Object)Empty.getDefaultInstance(), (Throwable)error, (StreamObserver)SafeStreamObserver.ensureSafeObserver(observer));
    }

    public void putIfAbsent(PutIfAbsentRequest request, StreamObserver<BytesValue> observer) {
        BytesValue result = null;
        Throwable error = null;
        try {
            CacheRequestHolder holder = this.createRequestHolder(request, request.getScope(), request.getCache(), request.getFormat());
            Binary key = holder.convertKeyDown(request.getKey());
            Binary value = holder.convertDown(() -> ((PutIfAbsentRequest)request).getValue());
            Binary binary = (Binary)holder.getCache().invoke((Object)key, BinaryProcessors.putIfAbsent((Binary)value, (long)request.getTtl()));
            binary = (Binary)holder.fromBinary(binary);
            result = holder.toBytesValue(binary);
        }
        catch (Throwable e) {
            error = e;
        }
        ResponseHandlers.handleUnary(result, (Throwable)error, (StreamObserver)SafeStreamObserver.ensureSafeObserver(observer));
    }

    public void remove(RemoveRequest request, StreamObserver<BytesValue> observer) {
        BytesValue result = null;
        Throwable error = null;
        try {
            CacheRequestHolder holder = this.createRequestHolder(request, request.getScope(), request.getCache(), request.getFormat());
            Binary key = holder.convertKeyDown(request.getKey());
            Binary binary = (Binary)holder.getCache().remove((Object)key);
            result = holder.toBytesValue(binary);
        }
        catch (Throwable e) {
            error = e;
        }
        ResponseHandlers.handleUnary(result, (Throwable)error, (StreamObserver)SafeStreamObserver.ensureSafeObserver(observer));
    }

    public void removeIndex(RemoveIndexRequest request, StreamObserver<Empty> observer) {
        Empty result = null;
        Throwable error = null;
        try {
            CacheRequestHolder holder = this.createRequestHolder(request, request.getScope(), request.getCache(), request.getFormat());
            result = this.removeIndex(holder);
        }
        catch (Throwable e) {
            error = e;
        }
        ResponseHandlers.handleUnary(result, (Throwable)error, (StreamObserver)SafeStreamObserver.ensureSafeObserver(observer));
    }

    public void removeMapping(RemoveMappingRequest request, StreamObserver<BoolValue> observer) {
        BoolValue result = null;
        Throwable error = null;
        try {
            CacheRequestHolder holder = this.createRequestHolder(request, request.getScope(), request.getCache(), request.getFormat());
            Binary key = holder.convertKeyDown(request.getKey());
            Object value = BinaryHelper.fromByteString((ByteString)request.getValue(), (Serializer)holder.getSerializer());
            NamedCache cache = holder.getCache();
            Binary binary = (Binary)cache.invoke((Object)key, CacheProcessors.remove((Object)value));
            result = this.toBoolValue(binary, cache.getCacheService().getSerializer());
        }
        catch (Throwable e) {
            error = e;
        }
        ResponseHandlers.handleUnary(result, (Throwable)error, (StreamObserver)SafeStreamObserver.ensureSafeObserver(observer));
    }

    public void replace(ReplaceRequest request, StreamObserver<BytesValue> observer) {
        BytesValue result = null;
        Throwable error = null;
        try {
            CacheRequestHolder holder = this.createRequestHolder(request, request.getScope(), request.getCache(), request.getFormat());
            NamedCache cache = holder.getCache();
            Binary key = holder.convertKeyDown(request.getKey());
            Binary value = holder.convertDown(request.getValue());
            Binary binary = (Binary)cache.invoke((Object)key, this.castProcessor((InvocableMap.EntryProcessor)new BinaryProcessors.BinaryReplaceProcessor(value)));
            binary = (Binary)ExternalizableHelper.fromBinary((Binary)binary, (Serializer)cache.getCacheService().getSerializer());
            result = holder.toBytesValue(binary);
        }
        catch (Throwable e) {
            error = e;
        }
        ResponseHandlers.handleUnary(result, (Throwable)error, (StreamObserver)SafeStreamObserver.ensureSafeObserver(observer));
    }

    public void replaceMapping(ReplaceMappingRequest request, StreamObserver<BoolValue> observer) {
        BoolValue result = null;
        Throwable error = null;
        try {
            CacheRequestHolder holder = this.createRequestHolder(request, request.getScope(), request.getCache(), request.getFormat());
            Binary key = holder.convertKeyDown(request.getKey());
            Binary prevValue = holder.convertDown(request.getPreviousValue());
            Binary newValue = holder.convertDown(request.getNewValue());
            BinaryProcessors.BinaryReplaceMappingProcessor processor = new BinaryProcessors.BinaryReplaceMappingProcessor(prevValue, newValue);
            Binary binary = (Binary)holder.getCache().invoke((Object)key, this.castProcessor((InvocableMap.EntryProcessor)processor));
            result = this.toBoolValue(binary, holder.getCacheSerializer());
        }
        catch (Throwable e) {
            error = e;
        }
        ResponseHandlers.handleUnary(result, (Throwable)error, (StreamObserver)SafeStreamObserver.ensureSafeObserver(observer));
    }

    public void size(SizeRequest request, StreamObserver<Int32Value> observer) {
        Int32Value result = null;
        Throwable error = null;
        try {
            int size = this.getCache(request.getScope(), request.getCache(), true).size();
            result = Int32Value.of((int)size);
        }
        catch (Throwable e) {
            error = e;
        }
        ResponseHandlers.handleUnary(result, (Throwable)error, (StreamObserver)SafeStreamObserver.ensureSafeObserver(observer));
    }

    public void truncate(TruncateRequest request, StreamObserver<Empty> observer) {
        Throwable error = null;
        try {
            this.getCache(request.getScope(), request.getCache(), true).truncate();
        }
        catch (Throwable e) {
            error = e;
        }
        ResponseHandlers.handleUnary((Object)Empty.getDefaultInstance(), (Throwable)error, (StreamObserver)SafeStreamObserver.ensureSafeObserver(observer));
    }

    public void values(ValuesRequest request, StreamObserver<BytesValue> observer) {
        StreamObserver safeObserver = SafeStreamObserver.ensureSafeObserver(observer);
        Throwable error = null;
        try {
            CacheRequestHolder holder = this.createRequestHolder(request, request.getScope(), request.getCache(), request.getFormat());
            Serializer serializer = holder.getSerializer();
            Filter filter = this.ensureFilter(request.getFilter(), serializer);
            Comparator comparator = this.deserializeComparator(request.getComparator(), serializer);
            AsyncNamedCache cache = holder.getAsyncCache();
            if (comparator == null) {
                Consumer callback = holder.binaryConsumer(safeObserver);
                cache.values(filter, callback).join();
            } else {
                Collection col = holder.getCache().values(filter, comparator);
                col.stream().map(arg_0 -> ((CacheRequestHolder)holder).toBytesValue(arg_0)).forEach(arg_0 -> ((StreamObserver)safeObserver).onNext(arg_0));
            }
        }
        catch (Throwable e) {
            error = e;
        }
        ResponseHandlers.handleErrorOrComplete((Throwable)error, (StreamObserver)safeObserver);
    }
}

