/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy.common.v0;

import com.google.protobuf.BytesValue;
import com.google.protobuf.Int32Value;
import com.oracle.coherence.grpc.BinaryHelper;
import com.oracle.coherence.grpc.ErrorsHelper;
import com.oracle.coherence.grpc.SafeStreamObserver;
import com.oracle.coherence.grpc.messages.cache.v0.Entry;
import com.oracle.coherence.grpc.v0.RequestHolder;
import com.tangosol.util.Binary;
import io.grpc.stub.StreamObserver;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ResponseHandlers {
    public static final Void VOID = null;

    public static <R> Void handleUnary(R result, StreamObserver<R> observer) {
        return ResponseHandlers.handleUnary(result, null, observer);
    }

    public static <R> Void handleUnary(R result, Throwable err, StreamObserver<R> observer) {
        if (err != null) {
            observer.onError((Throwable)ErrorsHelper.ensureStatusRuntimeException((Throwable)err));
        } else {
            observer.onNext(result);
            observer.onCompleted();
        }
        return null;
    }

    public static Void handleMapOfEntries(RequestHolder<?, Map<Binary, Binary>> holder, Throwable err, StreamObserver<Entry> observer) {
        if (err == null) {
            ResponseHandlers.handleStreamOfEntries(holder, ((Map)holder.getResult()).entrySet().stream(), observer);
        } else {
            observer.onError((Throwable)ErrorsHelper.ensureStatusRuntimeException((Throwable)err));
        }
        return VOID;
    }

    public static Void handleSetOfEntries(RequestHolder<?, Set<Map.Entry<Binary, Binary>>> holder, Throwable err, StreamObserver<Entry> observer) {
        if (err == null) {
            ResponseHandlers.handleStreamOfEntries(holder, ((Set)holder.getResult()).stream(), observer);
        } else {
            observer.onError((Throwable)ErrorsHelper.ensureStatusRuntimeException((Throwable)err));
        }
        return VOID;
    }

    public static void handleStreamOfEntries(RequestHolder<?, ?> holder, Stream<Map.Entry<Binary, Binary>> entries, StreamObserver<Entry> observer) {
        try {
            entries.forEach(entry -> observer.onNext((Object)holder.toEntry((Binary)entry.getKey(), (Binary)entry.getValue())));
            observer.onCompleted();
        }
        catch (Throwable thrown) {
            observer.onError((Throwable)ErrorsHelper.ensureStatusRuntimeException((Throwable)thrown));
        }
    }

    public static Void handleStream(RequestHolder<?, ? extends Iterable<Binary>> holder, Throwable err, StreamObserver<BytesValue> observer) {
        if (err == null) {
            try {
                Iterable iterable = (Iterable)holder.getResult();
                Stream<BytesValue> stream = StreamSupport.stream(iterable.spliterator(), false).map(bin -> BinaryHelper.toBytesValue((Binary)holder.convertUp(bin)));
                ResponseHandlers.stream(observer, stream);
            }
            catch (Throwable t) {
                observer.onError((Throwable)ErrorsHelper.ensureStatusRuntimeException((Throwable)t));
            }
        } else {
            observer.onError((Throwable)ErrorsHelper.ensureStatusRuntimeException((Throwable)err));
        }
        return VOID;
    }

    public static <Resp> Void handleStream(Iterable<Resp> iterable, Throwable err, StreamObserver<Resp> observer) {
        return ResponseHandlers.handleStream(StreamSupport.stream(iterable.spliterator(), false), err, observer);
    }

    public static <Resp> Void handleStream(Stream<Resp> stream, Throwable err, StreamObserver<Resp> observer) {
        if (err == null) {
            try {
                ResponseHandlers.stream(observer, stream);
            }
            catch (Throwable t) {
                observer.onError((Throwable)ErrorsHelper.ensureStatusRuntimeException((Throwable)t));
            }
        } else {
            observer.onError((Throwable)ErrorsHelper.ensureStatusRuntimeException((Throwable)err));
        }
        return VOID;
    }

    private static <T> void stream(StreamObserver<T> observer, Stream<? extends T> stream) {
        ResponseHandlers.stream(observer, () -> stream);
    }

    private static <T> void stream(StreamObserver<T> observer, Supplier<Stream<? extends T>> supplier) {
        StreamObserver safe = SafeStreamObserver.ensureSafeObserver(observer);
        Throwable thrown = null;
        try {
            supplier.get().forEach(arg_0 -> ((StreamObserver)safe).onNext(arg_0));
        }
        catch (Throwable t) {
            thrown = t;
        }
        if (thrown == null) {
            safe.onCompleted();
        } else {
            safe.onError(thrown);
        }
    }

    public static <Resp> Void handleError(Throwable err, StreamObserver<Resp> observer) {
        if (err != null) {
            observer.onError((Throwable)ErrorsHelper.ensureStatusRuntimeException((Throwable)err));
        }
        return VOID;
    }

    public static <Resp> Void handleErrorOrComplete(Throwable err, StreamObserver<Resp> observer) {
        if (err == null) {
            observer.onCompleted();
        } else {
            observer.onError((Throwable)ErrorsHelper.ensureStatusRuntimeException((Throwable)err));
        }
        return VOID;
    }

    public static <Resp> Resp handleError(Resp response, Throwable err) {
        if (err != null) {
            throw ErrorsHelper.ensureStatusRuntimeException((Throwable)err);
        }
        return response;
    }

    public static Int32Value toInt32Value(Object o) {
        if (o instanceof Int32Value) {
            return (Int32Value)o;
        }
        if (o instanceof Number) {
            return Int32Value.of((int)((Number)o).intValue());
        }
        return Int32Value.getDefaultInstance();
    }
}

