/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy.common;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.common.util.Duration;
import com.tangosol.coherence.config.Config;
import com.tangosol.internal.net.metrics.Meter;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.net.management.AnnotatedStandardMBean;
import com.tangosol.net.management.Registry;
import com.tangosol.net.management.annotation.Description;
import com.tangosol.net.management.annotation.MetricsLabels;
import com.tangosol.net.management.annotation.MetricsScope;
import com.tangosol.net.management.annotation.MetricsTag;
import com.tangosol.net.management.annotation.MetricsValue;
import com.tangosol.net.metrics.MBeanMetric;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.UID;
import io.grpc.Grpc;
import io.grpc.ServerCall;
import java.net.SocketAddress;
import java.util.Date;
import java.util.Map;
import java.util.function.Supplier;
import javax.management.NotCompliantMBeanException;

public class GrpcConnectionMetrics {
    public static final String PROP_CONNECTION_TTL = "coherence.grpc.metric.connection.ttl";
    private static final Duration DEFAULT_CONNECTION_TTL = new Duration(5, Duration.Magnitude.MINUTE);
    public static final String MBEAN_TYPE = "type=GrpcConnection";
    public static final String MBEAN_PREFIX = "type=GrpcConnection,uid=";
    private final Map<SocketAddress, ConnectionMetrics> f_cacheConnections;
    private Supplier<Registry> m_registry;

    private GrpcConnectionMetrics() {
        Duration ttl = Config.getDuration((String)PROP_CONNECTION_TTL, (Duration)DEFAULT_CONNECTION_TTL);
        LocalCache cache = new LocalCache(Integer.MAX_VALUE, (int)ttl.as(Duration.Magnitude.MILLI));
        cache.addMapListener((MapListener)new Listener());
        this.f_cacheConnections = cache;
        this.m_registry = () -> CacheFactory.getCluster().getManagement();
    }

    public static GrpcConnectionMetrics getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void register(ServerCall<?, ?> call) {
        SocketAddress address = (SocketAddress)call.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR);
        if (address != null) {
            ConnectionMetrics metrics = this.f_cacheConnections.computeIfAbsent(address, k -> new ConnectionMetrics(address));
            metrics.mark();
        }
    }

    void setRegistry(Supplier<Registry> registry) {
        if (registry != null) {
            this.m_registry = registry;
        }
    }

    int getConnectionCount() {
        return this.f_cacheConnections.size();
    }

    private class Listener
    implements MapListener<SocketAddress, ConnectionMetrics> {
        private Listener() {
        }

        public void entryInserted(MapEvent<SocketAddress, ConnectionMetrics> evt) {
            try {
                ConnectionMetrics mBean = (ConnectionMetrics)evt.getNewValue();
                Registry registry = GrpcConnectionMetrics.this.m_registry.get();
                String sName = registry.ensureGlobalName(GrpcConnectionMetrics.MBEAN_PREFIX + mBean.getUID());
                if (registry.isRegistered(sName)) {
                    registry.unregister(sName);
                }
                registry.register(sName, (Object)new AnnotatedStandardMBean((Object)mBean, ConnectionMetricsMBean.class));
            }
            catch (NotCompliantMBeanException e) {
                Logger.err((Throwable)e);
            }
        }

        public void entryUpdated(MapEvent<SocketAddress, ConnectionMetrics> evt) {
        }

        public void entryDeleted(MapEvent<SocketAddress, ConnectionMetrics> evt) {
            String sName;
            ConnectionMetrics mBean = (ConnectionMetrics)evt.getOldValue();
            Registry registry = GrpcConnectionMetrics.this.m_registry.get();
            if (registry.isRegistered(sName = registry.ensureGlobalName(GrpcConnectionMetrics.MBEAN_PREFIX + mBean.getUID()))) {
                registry.unregister(sName);
            }
        }
    }

    private static class SingletonHolder {
        private static final GrpcConnectionMetrics INSTANCE = new GrpcConnectionMetrics();

        private SingletonHolder() {
        }
    }

    static class ConnectionMetrics
    implements ConnectionMetricsMBean {
        private final String f_sUid;
        private final SocketAddress f_address;
        private final Date f_timestamp;
        private final Meter f_meter;

        ConnectionMetrics(SocketAddress address) {
            this.f_address = address;
            this.f_sUid = new UID().toString();
            this.f_timestamp = new Date();
            this.f_meter = new Meter();
        }

        @Override
        public String getAddress() {
            return this.f_address.toString();
        }

        @Override
        public String getUID() {
            return this.f_sUid;
        }

        @Override
        public Date getTimestamp() {
            return this.f_timestamp;
        }

        @Override
        public long getRequestCount() {
            return this.f_meter.getCount();
        }

        @Override
        public double getRequestCountMeanRate() {
            return this.f_meter.getOneMinuteRate();
        }

        @Override
        public double getRequestCountOneMinuteRate() {
            return this.f_meter.getOneMinuteRate();
        }

        @Override
        public double getRequestCountFiveMinuteRate() {
            return this.f_meter.getFiveMinuteRate();
        }

        @Override
        public double getRequestCountFifteenMinuteRate() {
            return this.f_meter.getFifteenMinuteRate();
        }

        void mark() {
            this.f_meter.mark();
        }
    }

    @MetricsScope(value=MBeanMetric.Scope.VENDOR)
    public static interface ConnectionMetricsMBean {
        @Description(value="The UID of the connection")
        public String getUID();

        @MetricsTag(value="RemoteAddress")
        @Description(value="The remote address of the connection")
        public String getAddress();

        @Description(value="The time that the connection was opened")
        public Date getTimestamp();

        @MetricsValue(value="RequestCount")
        @Description(value="The number of requests made by this connection")
        public long getRequestCount();

        @MetricsValue(value="RequestRate")
        @MetricsLabels(value={"quantile", "mean"})
        @Description(value="The mean rate of requests made by this connection")
        public double getRequestCountMeanRate();

        @MetricsValue(value="RequestRate")
        @MetricsLabels(value={"quantile", "1min"})
        @Description(value="The 1 minute rate of requests made by this connection")
        public double getRequestCountOneMinuteRate();

        @MetricsValue(value="RequestRate")
        @MetricsLabels(value={"quantile", "5min"})
        @Description(value="The 5 minute rate of requests made by this connection")
        public double getRequestCountFiveMinuteRate();

        @MetricsValue(value="RequestRate")
        @MetricsLabels(value={"quantile", "15min"})
        @Description(value="The 15 minute rate of requests made by this connection")
        public double getRequestCountFifteenMinuteRate();
    }
}

