/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy.common;

import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.grpc.proxy.common.BindableGrpcProxyService;
import com.oracle.coherence.grpc.proxy.common.BindableServiceFactory;
import com.oracle.coherence.grpc.proxy.common.GrpcMetricsInterceptor;
import com.oracle.coherence.grpc.proxy.common.GrpcServiceDependencies;
import com.oracle.coherence.grpc.proxy.common.ProxyServiceGrpcImpl;
import com.oracle.coherence.grpc.proxy.common.ProxyServiceInterceptor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.GrpcAcceptor;
import com.tangosol.internal.net.service.peer.acceptor.DefaultGrpcAcceptorDependencies;
import com.tangosol.internal.net.service.peer.acceptor.GrpcAcceptorDependencies;
import com.tangosol.net.grpc.GrpcAcceptorController;
import com.tangosol.net.messaging.ConnectionAcceptor;
import io.grpc.BindableService;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.protobuf.services.ChannelzService;
import io.grpc.protobuf.services.HealthStatusManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class BaseGrpcAcceptorController
implements GrpcAcceptorController {
    protected GrpcAcceptorDependencies m_dependencies;
    private List<BindableGrpcProxyService> m_listServices;
    private HealthStatusManager m_healthStatusManager;
    private volatile boolean m_fRunning;
    private GrpcAcceptor m_acceptor;
    private final Lock f_lock = new ReentrantLock();

    public final void start() {
        if (this.m_fRunning) {
            return;
        }
        this.f_lock.lock();
        try {
            if (this.m_fRunning) {
                return;
            }
            this.m_healthStatusManager = new HealthStatusManager();
            GrpcServiceDependencies.DefaultDependencies defaultDeps = new GrpcServiceDependencies.DefaultDependencies();
            defaultDeps.setAcceptor(this.m_acceptor);
            GrpcAcceptorDependencies dependencies = this.getDependencies();
            GrpcServiceDependencies serviceDeps = this.createServiceDeps(defaultDeps);
            List<ServerServiceDefinition> listService = this.ensureServices(serviceDeps);
            List<String> listName = listService.stream().map(s -> s.getServiceDescriptor().getName()).toList();
            ArrayList<BindableService> listBindable = new ArrayList<BindableService>();
            listBindable.add((BindableService)ChannelzService.newInstance((int)dependencies.getChannelzPageSize()));
            listBindable.add(this.m_healthStatusManager.getHealthService());
            this.startInternal(listService, listBindable);
            this.m_healthStatusManager.setStatus("$GRPC:GrpcProxy", HealthCheckResponse.ServingStatus.SERVING);
            listName.forEach(s -> this.m_healthStatusManager.setStatus(s, HealthCheckResponse.ServingStatus.SERVING));
            this.m_fRunning = true;
        }
        catch (IOException e) {
            throw Exceptions.ensureRuntimeException((Throwable)e, (String)"Failed to start gRPC server");
        }
        finally {
            this.f_lock.unlock();
        }
    }

    protected abstract GrpcServiceDependencies createServiceDeps(GrpcServiceDependencies var1);

    protected abstract void startInternal(List<ServerServiceDefinition> var1, List<BindableService> var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        if (this.m_fRunning) {
            this.f_lock.lock();
            try {
                if (this.m_fRunning) {
                    this.m_fRunning = false;
                    this.m_healthStatusManager.enterTerminalState();
                    this.m_healthStatusManager = null;
                    List<BindableGrpcProxyService> list = this.m_listServices;
                    if (list != null) {
                        for (BindableGrpcProxyService service : list) {
                            try {
                                service.close();
                            }
                            catch (Exception e) {
                                Logger.err((Throwable)e);
                            }
                        }
                    }
                    this.stopInternal();
                    this.m_listServices = null;
                }
            }
            finally {
                this.f_lock.unlock();
            }
        }
    }

    protected abstract void stopInternal();

    public boolean isRunning() {
        return this.m_fRunning;
    }

    public void setDependencies(GrpcAcceptorDependencies deps) {
        this.m_dependencies = deps;
    }

    public GrpcAcceptorDependencies getDependencies() {
        GrpcAcceptorDependencies deps = this.m_dependencies;
        if (deps == null) {
            deps = this.m_dependencies = new DefaultGrpcAcceptorDependencies();
        }
        return deps;
    }

    public String getLocalAddress() {
        return this.m_dependencies.getLocalAddress();
    }

    public void setAcceptor(ConnectionAcceptor acceptor) {
        this.m_acceptor = (GrpcAcceptor)acceptor;
    }

    public List<BindableGrpcProxyService> getBindableServices() {
        return this.m_listServices;
    }

    protected List<ServerServiceDefinition> ensureServices(GrpcServiceDependencies serviceDeps) {
        List<BindableGrpcProxyService> list = this.loadServices(serviceDeps);
        return list.stream().map(this::applyInterceptors).toList();
    }

    private List<BindableGrpcProxyService> loadServices(GrpcServiceDependencies serviceDeps) {
        List<BindableGrpcProxyService> list = this.m_listServices;
        if (list == null) {
            this.f_lock.lock();
            try {
                list = this.m_listServices;
                if (list == null) {
                    list = this.m_listServices = BindableServiceFactory.discoverServices(serviceDeps);
                }
            }
            finally {
                this.f_lock.unlock();
            }
        }
        return list;
    }

    public ProxyServiceGrpcImpl getProxyService() {
        List<BindableGrpcProxyService> list = this.m_listServices;
        if (list == null) {
            throw new IllegalStateException("gRPC services not yet initialized");
        }
        return list.stream().filter(s -> s instanceof ProxyServiceGrpcImpl).map(ProxyServiceGrpcImpl.class::cast).findFirst().orElseThrow(() -> new IllegalStateException("ProxyServiceGrpcImpl not found"));
    }

    protected ServerServiceDefinition applyInterceptors(BindableGrpcProxyService service) {
        GrpcMetricsInterceptor metricsInterceptor = new GrpcMetricsInterceptor(service.getMetrics());
        ProxyServiceInterceptor proxyInterceptor = new ProxyServiceInterceptor();
        return ServerInterceptors.intercept((BindableService)service, (ServerInterceptor[])new ServerInterceptor[]{metricsInterceptor, proxyInterceptor});
    }
}

