/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy.common;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.grpc.proxy.common.BaseProxyProtocol;
import com.tangosol.coherence.component.net.extend.message.GrpcMessageWrapper;
import com.tangosol.coherence.component.net.extend.message.response.GrpcResponse;
import com.tangosol.coherence.component.net.extend.messageFactory.GrpcMessageFactory;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.grpcAcceptor.GrpcChannel;
import com.tangosol.io.Serializer;
import com.tangosol.net.messaging.Channel;
import com.tangosol.net.messaging.Message;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;

public abstract class BaseExtendProxyProtocol<Req extends com.google.protobuf.Message, Resp extends com.google.protobuf.Message>
extends BaseProxyProtocol<Req, Resp> {
    protected boolean m_fClosed;

    @Override
    public void close() {
        f_lock.lock();
        try {
            this.m_fClosed = true;
            this.m_destroyedIds.clear();
        }
        finally {
            f_lock.unlock();
        }
        super.close();
    }

    @Override
    protected void onRequestInternal(Req request, StreamObserver<Resp> observer) {
        try {
            GrpcMessageWrapper message;
            int proxyId = this.getProxyId(request);
            GrpcChannel channel = this.m_serviceProxy.getGrpcChannel();
            Serializer serializer = this.getSerializer();
            if (proxyId == 0) {
                GrpcMessageFactory factory = (GrpcMessageFactory)channel.getMessageFactory();
                message = factory.createRequestMessage(request, serializer);
                message.setChannel((Channel)channel);
            } else {
                GrpcChannel subChannel = channel.getSubChannel(proxyId);
                if (subChannel == null) {
                    throw new IllegalArgumentException("Invalid proxy id " + proxyId + " request=" + String.valueOf(request));
                }
                channel = subChannel;
                GrpcMessageFactory factory = (GrpcMessageFactory)subChannel.getMessageFactory();
                message = factory.createRequestMessage(request, serializer);
                message.setChannel((Channel)subChannel);
            }
            GrpcResponse response = message.getResponse();
            response.setProxyId(proxyId);
            response.setStreamObserver(observer);
            response.setSerializer(serializer);
            channel.receive((Message)message);
        }
        catch (Throwable t) {
            Logger.err((String)"Failed to process request", (Throwable)t);
            observer.onError((Throwable)Status.INTERNAL.withDescription("Failed to process request").withCause(t).asRuntimeException());
        }
    }

    protected abstract int getProxyId(Req var1);
}

