/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy.common;

import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.grpc.proxy.common.DaemonPoolExecutor;
import com.oracle.coherence.grpc.proxy.common.GrpcProxyMetricsMBean;
import com.tangosol.internal.net.metrics.Histogram;
import com.tangosol.internal.net.metrics.Meter;
import com.tangosol.internal.net.metrics.Snapshot;
import com.tangosol.net.management.AnnotatedStandardMBean;
import com.tangosol.net.management.Registry;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.management.NotCompliantMBeanException;

public class GrpcProxyMetrics
implements GrpcProxyMetricsMBean {
    public static final long MIN_SNAPSHOT_REFRESH = 250L;
    private final String f_sMBeanName;
    private final DaemonPoolExecutor.DaemonPoolManagement f_poolManagement;
    private final Histogram f_requestHistogram;
    private final Histogram f_messageHistogram;
    private final Meter f_meterSuccess;
    private final Meter f_meterError;
    private final Meter f_meterSent;
    private final Meter f_meterReceived;
    private Snapshot m_requestSnapshot;
    private volatile long m_nLastRequestSnapshot;
    private Snapshot m_messageSnapshot;
    private volatile long m_nLastMessageSnapshot;

    public GrpcProxyMetrics(String sName, DaemonPoolExecutor.DaemonPoolManagement poolManagement) {
        Objects.requireNonNull(sName);
        this.f_sMBeanName = sName;
        this.f_poolManagement = poolManagement;
        this.f_requestHistogram = new Histogram();
        this.f_messageHistogram = new Histogram();
        this.f_meterSuccess = new Meter();
        this.f_meterError = new Meter();
        this.f_meterSent = new Meter();
        this.f_meterReceived = new Meter();
    }

    public void addRequestDuration(long nanos) {
        this.f_requestHistogram.update(TimeUnit.NANOSECONDS.toMillis(nanos));
    }

    public void addMessageDuration(long nanos) {
        this.f_messageHistogram.update(TimeUnit.NANOSECONDS.toMillis(nanos));
    }

    public void markSuccess() {
        this.f_meterSuccess.mark();
    }

    public void markError() {
        this.f_meterError.mark();
    }

    public void markSent() {
        this.f_meterSent.mark();
    }

    public void markReceived() {
        this.f_meterReceived.mark();
    }

    @Override
    public long getSuccessfulRequestCount() {
        return this.f_meterSuccess.getCount();
    }

    @Override
    public double getSuccessfulRequestFifteenMinuteRate() {
        return this.f_meterSuccess.getFifteenMinuteRate();
    }

    @Override
    public double getSuccessfulRequestFiveMinuteRate() {
        return this.f_meterSuccess.getFiveMinuteRate();
    }

    @Override
    public double getSuccessfulRequestOneMinuteRate() {
        return this.f_meterSuccess.getOneMinuteRate();
    }

    @Override
    public double getSuccessfulRequestMeanRate() {
        return this.f_meterSuccess.getMeanRate();
    }

    @Override
    public long getErrorRequestCount() {
        return this.f_meterError.getCount();
    }

    @Override
    public double getErrorRequestFifteenMinuteRate() {
        return this.f_meterError.getFifteenMinuteRate();
    }

    @Override
    public double getErrorRequestFiveMinuteRate() {
        return this.f_meterError.getFiveMinuteRate();
    }

    @Override
    public double getErrorRequestOneMinuteRate() {
        return this.f_meterError.getOneMinuteRate();
    }

    @Override
    public double getErrorRequestMeanRate() {
        return this.f_meterError.getMeanRate();
    }

    @Override
    public double getRequestDuration75thPercentile() {
        return this.ensureRequestSnapshot().get75thPercentile();
    }

    @Override
    public double getRequestDuration95thPercentile() {
        return this.ensureRequestSnapshot().get95thPercentile();
    }

    @Override
    public double getRequestDuration98thPercentile() {
        return this.ensureRequestSnapshot().get98thPercentile();
    }

    @Override
    public double getRequestDuration99thPercentile() {
        return this.ensureRequestSnapshot().get99thPercentile();
    }

    @Override
    public double getRequestDuration999thPercentile() {
        return this.ensureRequestSnapshot().get999thPercentile();
    }

    @Override
    public double getRequestDurationMax() {
        return this.ensureRequestSnapshot().getMax();
    }

    @Override
    public double getRequestDurationMean() {
        return this.ensureRequestSnapshot().getMean();
    }

    @Override
    public double getRequestDurationMin() {
        return this.ensureRequestSnapshot().getMin();
    }

    @Override
    public double getRequestDurationStdDev() {
        return this.ensureRequestSnapshot().getStdDev();
    }

    @Override
    public double getMessageDuration75thPercentile() {
        return this.ensureMessageSnapshot().get75thPercentile();
    }

    @Override
    public double getMessageDuration95thPercentile() {
        return this.ensureMessageSnapshot().get95thPercentile();
    }

    @Override
    public double getMessageDuration98thPercentile() {
        return this.ensureMessageSnapshot().get98thPercentile();
    }

    @Override
    public double getMessageDuration99thPercentile() {
        return this.ensureMessageSnapshot().get99thPercentile();
    }

    @Override
    public double getMessageDuration999thPercentile() {
        return this.ensureMessageSnapshot().get999thPercentile();
    }

    @Override
    public double getMessageDurationMax() {
        return this.ensureMessageSnapshot().getMax();
    }

    @Override
    public double getMessageDurationMean() {
        return this.ensureMessageSnapshot().getMean();
    }

    @Override
    public double getMessageDurationMin() {
        return this.ensureMessageSnapshot().getMin();
    }

    @Override
    public double getMessageDurationStdDev() {
        return this.ensureMessageSnapshot().getStdDev();
    }

    @Override
    public long getMessagesReceivedCount() {
        return this.f_meterReceived.getCount();
    }

    @Override
    public double getMessagesReceivedFifteenMinuteRate() {
        return this.f_meterReceived.getFifteenMinuteRate();
    }

    @Override
    public double getMessagesReceivedFiveMinuteRate() {
        return this.f_meterReceived.getFiveMinuteRate();
    }

    @Override
    public double getMessagesReceivedOneMinuteRate() {
        return this.f_meterReceived.getOneMinuteRate();
    }

    @Override
    public double getMessagesReceivedMeanRate() {
        return this.f_meterReceived.getMeanRate();
    }

    @Override
    public long getResponsesSentCount() {
        return this.f_meterSent.getCount();
    }

    @Override
    public double getResponsesSentFifteenMinuteRate() {
        return this.f_meterSent.getFifteenMinuteRate();
    }

    @Override
    public double getResponsesSentFiveMinuteRate() {
        return this.f_meterSent.getFiveMinuteRate();
    }

    @Override
    public double getResponsesSentOneMinuteRate() {
        return this.f_meterSent.getOneMinuteRate();
    }

    @Override
    public double getResponsesSentMeanRate() {
        return this.f_meterSent.getMeanRate();
    }

    @Override
    public int getTaskBacklog() {
        return this.f_poolManagement == null ? 0 : this.f_poolManagement.getBacklog();
    }

    @Override
    public int getDaemonCountMax() {
        return this.f_poolManagement == null ? 0 : this.f_poolManagement.getDaemonCountMax();
    }

    @Override
    public void setDaemonCountMax(int count) {
        if (this.f_poolManagement != null) {
            this.f_poolManagement.setDaemonCountMax(count);
        }
    }

    @Override
    public int getDaemonCountMin() {
        return this.f_poolManagement == null ? 0 : this.f_poolManagement.getDaemonCountMin();
    }

    @Override
    public void setDaemonCountMin(int count) {
        if (this.f_poolManagement != null) {
            this.f_poolManagement.setDaemonCountMin(count);
        }
    }

    @Override
    public int getDaemonCount() {
        return this.f_poolManagement == null ? 0 : this.f_poolManagement.getDaemonCount();
    }

    @Override
    public int getAbandonedThreadCount() {
        return this.f_poolManagement == null ? 0 : this.f_poolManagement.getAbandonedCount();
    }

    @Override
    public long getTaskActiveMillis() {
        return this.f_poolManagement == null ? 0L : this.f_poolManagement.getActiveMillis();
    }

    @Override
    public int getHungTaskCount() {
        return this.f_poolManagement == null ? 0 : this.f_poolManagement.getHungCount();
    }

    @Override
    public long getHungTaskDuration() {
        return this.f_poolManagement == null ? 0L : this.f_poolManagement.getHungDuration();
    }

    @Override
    public long getLastResetMillis() {
        return this.f_poolManagement == null ? 0L : this.f_poolManagement.getLastResetMillis();
    }

    @Override
    public long getLastResizeMillis() {
        return this.f_poolManagement == null ? 0L : this.f_poolManagement.getLastResizeMillis();
    }

    @Override
    public long getTaskAddCount() {
        return this.f_poolManagement == null ? 0L : this.f_poolManagement.getTaskAddCount();
    }

    @Override
    public long getTaskCount() {
        return this.f_poolManagement == null ? 0L : this.f_poolManagement.getTaskCount();
    }

    @Override
    public int getMaxTaskBacklog() {
        return this.f_poolManagement == null ? 0 : this.f_poolManagement.getMaxBacklog();
    }

    @Override
    public int getTaskTimeoutCount() {
        return this.f_poolManagement == null ? 0 : this.f_poolManagement.getTimeoutCount();
    }

    @Override
    public long getTaskTimeout() {
        return this.f_poolManagement == null ? 0L : this.f_poolManagement.getTaskTimeout();
    }

    public void registerMBean(Registry registry) {
        try {
            String globalName = registry.ensureGlobalName(this.f_sMBeanName);
            registry.register(globalName, (Object)new AnnotatedStandardMBean((Object)this, GrpcProxyMetricsMBean.class));
        }
        catch (NotCompliantMBeanException e) {
            throw Exceptions.ensureRuntimeException((Throwable)e);
        }
    }

    Snapshot ensureRequestSnapshot() {
        long nLastSnapshot = this.m_nLastRequestSnapshot;
        long nNow = System.currentTimeMillis();
        long nTime = nNow - nLastSnapshot;
        if (this.m_requestSnapshot == null || nTime > 250L) {
            this.m_requestSnapshot = this.f_requestHistogram.getSnapshot();
            this.m_nLastRequestSnapshot = nNow;
        }
        return this.m_requestSnapshot;
    }

    Snapshot ensureMessageSnapshot() {
        long nLastSnapshot = this.m_nLastMessageSnapshot;
        long nNow = System.currentTimeMillis();
        long nTime = nNow - nLastSnapshot;
        if (this.m_messageSnapshot == null || nTime > 250L) {
            this.m_messageSnapshot = this.f_messageHistogram.getSnapshot();
            this.m_nLastMessageSnapshot = nNow;
        }
        return this.m_messageSnapshot;
    }
}

