/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.client.common.topics;

import com.oracle.coherence.grpc.client.common.topics.GrpcRemoteTopicService;
import com.tangosol.net.events.EventDispatcher;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.net.events.internal.AbstractEventDispatcher;
import com.tangosol.net.events.partition.cache.PartitionedCacheDispatcher;
import com.tangosol.net.events.topics.TopicLifecycleEvent;
import com.tangosol.net.events.topics.TopicLifecycleEventDispatcher;
import com.tangosol.net.topic.NamedTopic;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class GrpcTopicLifecycleEventDispatcher
extends AbstractEventDispatcher
implements TopicLifecycleEventDispatcher {
    protected static final Set<Enum> EVENT_TYPES = new HashSet<Enum>();
    private final String f_sTopicName;
    private final GrpcRemoteTopicService f_service;

    public GrpcTopicLifecycleEventDispatcher(String sTopicName, GrpcRemoteTopicService service) {
        super(EVENT_TYPES);
        this.f_sTopicName = sTopicName;
        this.f_service = Objects.requireNonNull(service);
    }

    public String getTopicName() {
        return this.f_sTopicName;
    }

    public String getServiceName() {
        return this.f_service == null ? "" : this.f_service.getInfo().getServiceName();
    }

    public String getScopeName() {
        return this.f_service == null ? "$SYS" : this.f_service.getScopeName();
    }

    public void dispatchTopicCreated(NamedTopic<?> topic) {
        this.dispatchTopicEvent(TopicLifecycleEvent.Type.CREATED, topic);
    }

    public void dispatchTopicDestroyed(NamedTopic<?> topic) {
        this.dispatchTopicEvent(TopicLifecycleEvent.Type.DESTROYED, topic);
    }

    public GrpcRemoteTopicService getService() {
        return this.f_service;
    }

    protected void dispatchTopicEvent(TopicLifecycleEvent.Type eventType, NamedTopic<?> topic) {
        List list = (List)this.getInterceptorMap().get(eventType);
        if (list != null) {
            new GrpcTopicLifecycleEvent(this, eventType, topic).dispatch(list);
        }
    }

    static {
        EVENT_TYPES.addAll(Arrays.asList(TopicLifecycleEvent.Type.values()));
    }

    protected static class GrpcTopicLifecycleEvent
    extends AbstractEvent<TopicLifecycleEvent.Type>
    implements TopicLifecycleEvent {
        private final NamedTopic<?> f_topic;

        protected GrpcTopicLifecycleEvent(GrpcTopicLifecycleEventDispatcher dispatcher, TopicLifecycleEvent.Type eventType, NamedTopic<?> topic) {
            super(dispatcher, eventType);
            this.f_topic = topic;
        }

        protected String getDescription() {
            return super.getDescription() + ", Session=" + this.getSessionName() + ", Scope=" + this.getScopeName() + ", Topic=" + this.getTopicName();
        }

        public String getTopicName() {
            return this.f_topic.getName();
        }

        public String getServiceName() {
            return this.f_topic.getService().getInfo().getServiceName();
        }

        public String getScopeName() {
            return this.getEventDispatcher().getScopeName();
        }

        public String getSessionName() {
            GrpcTopicLifecycleEventDispatcher dispatcher = (GrpcTopicLifecycleEventDispatcher)this.getEventDispatcher();
            GrpcRemoteTopicService topicService = dispatcher.getService();
            String sName = (String)topicService.getTopicBackingMapManager().getCacheFactory().getResourceRegistry().getResource(String.class, "$SESSION$");
            return sName == null ? "" : sName;
        }

        public TopicLifecycleEventDispatcher getEventDispatcher() {
            return (TopicLifecycleEventDispatcher)this.m_dispatcher;
        }

        public PartitionedCacheDispatcher getDispatcher() {
            return null;
        }

        protected void dispatch(Collection<? extends EventInterceptor<?>> colIter) {
            super.dispatch(colIter);
        }
    }

    protected static abstract class AbstractEvent<T extends Enum<T>>
    extends com.tangosol.net.events.internal.AbstractEvent<T> {
        public AbstractEvent(GrpcTopicLifecycleEventDispatcher dispatcher, T eventType) {
            super((EventDispatcher)dispatcher, eventType);
        }
    }
}

