/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.client.common;

import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Empty;
import com.google.protobuf.Int32Value;
import com.oracle.coherence.grpc.MaybeByteString;
import com.oracle.coherence.grpc.client.common.AsyncNamedCacheClient;
import com.oracle.coherence.grpc.client.common.ClientProtocol;
import com.oracle.coherence.grpc.client.common.GrpcConnection;
import com.oracle.coherence.grpc.client.common.v0.NamedCacheClientChannel_V0;
import com.oracle.coherence.grpc.client.common.v1.NamedCacheClientChannel_V1;
import com.tangosol.net.cache.CacheEvent;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;

public interface NamedCacheClientChannel
extends ClientProtocol {
    public static NamedCacheClientChannel createProtocol(AsyncNamedCacheClient.Dependencies dependencies, GrpcConnection connection) {
        int nVersion = connection.getProtocolVersion();
        if (nVersion >= 1) {
            return new NamedCacheClientChannel_V1(dependencies, connection);
        }
        return new NamedCacheClientChannel_V0(dependencies, connection);
    }

    public AsyncNamedCacheClient.Dependencies getDependencies();

    public CompletableFuture<Void> addIndex(ByteString var1, boolean var2, ByteString var3);

    public CompletableFuture<Void> addMapListener(ByteString var1, boolean var2, boolean var3, boolean var4);

    public CompletableFuture<Void> addMapListener(ByteString var1, long var2, boolean var4, ByteString var5, boolean var6);

    public CompletableFuture<BytesValue> aggregate(List<ByteString> var1, ByteString var2, long var3);

    public CompletableFuture<BytesValue> aggregate(ByteString var1, ByteString var2, long var3);

    public CompletableFuture<Void> clear();

    public CompletionStage<BoolValue> containsEntry(ByteString var1, ByteString var2);

    public CompletionStage<BoolValue> containsKey(ByteString var1);

    public CompletionStage<BoolValue> containsValue(ByteString var1);

    public CompletableFuture<Void> destroy();

    public CompletableFuture<Map<ByteString, ByteString>> entrySet(ByteString var1);

    public CompletableFuture<Map<ByteString, ByteString>> entrySet(ByteString var1, ByteString var2);

    public CompletionStage<MaybeByteString> get(ByteString var1);

    public Stream<Map.Entry<ByteString, ByteString>> getAll(Iterable<ByteString> var1);

    public EntrySetPage getEntriesPage(ByteString var1);

    public Stream<BytesValue> getKeysPage(ByteString var1);

    public CompletionStage<BytesValue> invoke(ByteString var1, ByteString var2, long var3);

    public CompletableFuture<Map<ByteString, ByteString>> invokeAll(Collection<ByteString> var1, ByteString var2, long var3);

    public CompletableFuture<Map<ByteString, ByteString>> invokeAll(ByteString var1, ByteString var2);

    public CompletableFuture<Void> invokeAll(Collection<ByteString> var1, ByteString var2, Consumer<Map.Entry<ByteString, ByteString>> var3);

    public CompletableFuture<Void> invokeAll(ByteString var1, ByteString var2, Consumer<Map.Entry<ByteString, ByteString>> var3);

    public CompletableFuture<Void> invokeAll(ByteString var1, ByteString var2, BiConsumer<ByteString, ByteString> var3);

    public CompletableFuture<Void> invokeAll(Collection<ByteString> var1, ByteString var2, BiConsumer<ByteString, ByteString> var3);

    public CompletionStage<BoolValue> isEmpty();

    public CompletionStage<BoolValue> isReady();

    public CompletableFuture<Empty> putAll(Map<ByteString, ByteString> var1, long var2);

    public CompletionStage<BytesValue> putIfAbsent(ByteString var1, ByteString var2);

    public CompletionStage<BytesValue> put(ByteString var1, ByteString var2, long var3);

    public CompletionStage<BytesValue> remove(ByteString var1);

    public CompletionStage<BoolValue> remove(ByteString var1, ByteString var2);

    public CompletionStage<Empty> removeIndex(ByteString var1);

    public CompletableFuture<Void> removeMapListener(ByteString var1, boolean var2);

    public CompletableFuture<Void> removeMapListener(ByteString var1, long var2, ByteString var4);

    public CompletionStage<BytesValue> replace(ByteString var1, ByteString var2);

    public CompletionStage<BoolValue> replaceMapping(ByteString var1, ByteString var2, ByteString var3);

    public void setEventDispatcher(EventDispatcher var1);

    public CompletionStage<Int32Value> size();

    public CompletionStage<Empty> truncate();

    public record EntrySetPage(ByteString cookie, List<Map.Entry<ByteString, ByteString>> entries) {
        public boolean isEmpty() {
            return this.entries.isEmpty();
        }
    }

    public static interface EventDispatcher {
        public void dispatch(List<Long> var1, int var2, ByteString var3, ByteString var4, ByteString var5, boolean var6, boolean var7, CacheEvent.TransformationState var8);

        public void onDestroy();

        public void onTruncate();

        public void incrementListeners();

        public void decrementListeners();
    }
}

