/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.client.common;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.grpc.client.common.GrpcConnection;
import com.tangosol.util.Listeners;
import java.util.EventListener;

public abstract class BaseGrpcConnection
implements GrpcConnection {
    private final Listeners f_connectionListeners = new Listeners();

    @Override
    public void addConnectionListener(GrpcConnection.ConnectionListener listener) {
        this.f_connectionListeners.add((EventListener)listener);
    }

    @Override
    public void removeConnectionListener(GrpcConnection.ConnectionListener listener) {
        this.f_connectionListeners.remove((EventListener)listener);
    }

    protected void dispatchConnected() {
        this.dispatchConnectionEvent(GrpcConnection.ConnectionEvent.Type.Connected);
    }

    protected void dispatchDisconnected() {
        this.dispatchConnectionEvent(GrpcConnection.ConnectionEvent.Type.Disconnected);
    }

    protected void dispatchConnectionEvent(GrpcConnection.ConnectionEvent.Type type) {
        EventListener[] listeners;
        GrpcConnection.ConnectionEvent event = new GrpcConnection.ConnectionEvent(this, type);
        for (EventListener listener : listeners = this.f_connectionListeners.listeners()) {
            try {
                ((GrpcConnection.ConnectionListener)listener).onConnectionEvent(event);
            }
            catch (Throwable t) {
                Logger.err((String)("Caught exception dispatching connection event to " + String.valueOf(listener)), (Throwable)t);
            }
        }
    }
}

