/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.discovery;

import com.tangosol.discovery.NSLookup;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Arrays;

class Connection
implements Closeable {
    private static final int MULTIPLEXED_SOCKET = 1522655232;
    private static final int NAMESERVICE_SUBPORT = 3;
    private static final byte[] CONN_OPEN = new byte[]{0, 1, 2, 0, 66, 0, 1, 14, 0, 0, 66, -90, -74, -97, -34, -78, 81, 1, 65, -29, -13, -28, -35, 15, 2, 65, -113, -10, -70, -103, 1, 3, 65, -8, -76, -27, -14, 4, 4, 65, -60, -2, -36, -11, 5, 5, 65, -41, -50, -61, -115, 7, 6, 65, -37, -119, -36, -43, 10, 64, 2, 110, 3, 93, 78, 87, 2, 17, 77, 101, 115, 115, 97, 103, 105, 110, 103, 80, 114, 111, 116, 111, 99, 111, 108, 2, 65, 2, 65, 2, 19, 78, 97, 109, 101, 83, 101, 114, 118, 105, 99, 101, 80, 114, 111, 116, 111, 99, 111, 108, 2, 65, 1, 65, 1, 5, -96, 2, 0, 0, 14, 0, 0, 66, -82, -119, -98, -34, -78, 81, 1, 65, -127, -128, -128, -16, 15, 5, 65, -104, -97, -127, -128, 8, 6, 65, -109, -98, 1, 64, 1, 106, 2, 110, 3, 106, 4, 113, 5, 113, 6, 78, 8, 67, 108, 117, 115, 116, 101, 114, 66, 9, 78, 9, 108, 111, 99, 97, 108, 104, 111, 115, 116, 10, 78, 5, 50, 48, 50, 51, 51, 12, 78, 16, 67, 111, 104, 101, 114, 101, 110, 99, 101, 67, 111, 110, 115, 111, 108, 101, 64, 64};
    private static final byte[] CHANNEL_OPEN = new byte[]{0, 11, 2, 0, 66, 1, 1, 78, 19, 78, 97, 109, 101, 83, 101, 114, 118, 105, 99, 101, 80, 114, 111, 116, 111, 99, 111, 108, 2, 78, 11, 78, 97, 109, 101, 83, 101, 114, 118, 105, 99, 101, 64};
    private static final byte[] NS_LOOKUP_REQ_ID = new byte[]{1, 1, 0, 66, 0, 1, 78};
    private static final byte REQ_END_MARKER = 64;
    final Socket socket = new Socket();
    final DataOutputStream outStream;
    final DataInputStream inStream;
    final byte[] abChan;

    protected Connection(SocketAddress socketAddr, int cTimeOutMillis) throws IOException {
        this.socket.setTcpNoDelay(true);
        this.socket.setSoTimeout(cTimeOutMillis);
        this.socket.connect(socketAddr, cTimeOutMillis);
        this.outStream = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
        this.inStream = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
        this.outStream.writeInt(1522655232);
        this.outStream.writeInt(3);
        NSLookup.write(this.outStream, CONN_OPEN);
        NSLookup.write(this.outStream, CHANNEL_OPEN);
        this.outStream.flush();
        NSLookup.read(this.inStream);
        byte[] aChanResponse = NSLookup.read(this.inStream);
        int cbChanId = aChanResponse.length - 9;
        this.abChan = Arrays.copyOfRange(aChanResponse, 8, 8 + cbChanId);
    }

    public static Connection open(String sCluster, SocketAddress socketAddr, int cTimeOutMillis) throws IOException {
        Connection connection = null;
        do {
            connection = new Connection(socketAddr, cTimeOutMillis);
            if (sCluster == null || sCluster.equals(connection.lookup("Cluster/name"))) continue;
            String sPort = connection.lookup("NameService/string/Cluster/foreign/" + sCluster + "/NameService/localPort");
            connection.close();
            connection = null;
            if (sPort == null) {
                throw new IOException((String)(sCluster == null ? "no cluster could be located" : "cluster '" + sCluster + "' could not be located"));
            }
            socketAddr = new InetSocketAddress(((InetSocketAddress)socketAddr).getAddress(), (int)Integer.valueOf(sPort));
        } while (connection == null);
        return connection;
    }

    public String lookup(String sName) throws IOException {
        DataInputStream stream = this.lookupRaw(sName);
        return stream == null ? null : NSLookup.readString(stream);
    }

    public DataInputStream lookupRaw(String sName) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream reqStream = new DataOutputStream(baos);
        reqStream.write(this.abChan);
        reqStream.write(NS_LOOKUP_REQ_ID, 0, NS_LOOKUP_REQ_ID.length);
        byte[] abName = sName.getBytes("utf-8");
        NSLookup.writePackedInt(reqStream, abName.length);
        reqStream.write(abName, 0, abName.length);
        reqStream.write(64);
        reqStream.flush();
        NSLookup.write(this.outStream, baos.toByteArray());
        this.outStream.flush();
        byte[] aResponse = NSLookup.read(this.inStream);
        int nLen = aResponse.length;
        int nMinLen = this.abChan.length + 1;
        if (nLen <= nMinLen) {
            throw new EOFException("protocol error");
        }
        if (nLen == nMinLen + 7) {
            return null;
        }
        return new DataInputStream(new ByteArrayInputStream(aResponse, nMinLen, nLen - nMinLen - 1));
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }
}

