/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor.internal;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.concurrent.config.ConcurrentConfiguration;
import com.oracle.coherence.concurrent.executor.ClusteredExecutorService;
import com.oracle.coherence.concurrent.executor.internal.ExecutorTrace;
import com.oracle.coherence.concurrent.executor.internal.Hook;
import com.oracle.coherence.concurrent.executor.util.Caches;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.Member;
import com.tangosol.net.NamedCache;
import com.tangosol.net.events.Event;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.net.events.SessionLifecycleEvent;
import com.tangosol.net.events.application.LifecycleEvent;
import com.tangosol.util.Base;
import com.tangosol.util.ResourceRegistry;

public class LifecycleEventInterceptor
implements EventInterceptor<Event<?>> {
    protected boolean m_fClosed;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onEvent(Event<?> event) {
        ExecutorTrace.log(() -> String.format("LifecycleEventInterceptor received event with type: %s", event.getType()));
        if (event.getType() == LifecycleEvent.Type.ACTIVATED) {
            this.m_fClosed = false;
            LifecycleEvent lifecycleEvent = (LifecycleEvent)event;
            try {
                Member member = CacheFactory.getCluster().getLocalMember();
                ConfigurableCacheFactory configurableCacheFactory = lifecycleEvent.getConfigurableCacheFactory();
                NamedCache cache = Caches.assignments(configurableCacheFactory);
                if (cache != null && cache.isActive()) {
                    CacheService service = cache.getCacheService();
                    if (service != null && service.isRunning()) {
                        Logger.info(() -> String.format("Establishing Executor for Member [%s] with the ClusteredExecutorService", member.getId()));
                        ClusteredExecutorService clusteredExecutorService = new ClusteredExecutorService(service);
                        ResourceRegistry ccfRegistry = configurableCacheFactory.getResourceRegistry();
                        ccfRegistry.registerResource(ClusteredExecutorService.class, ClusteredExecutorService.class.getSimpleName(), (Object)clusteredExecutorService);
                        ConcurrentConfiguration configuration = ConcurrentConfiguration.get();
                        configuration.setExecutorService(clusteredExecutorService);
                        return;
                    }
                    if (!Logger.isEnabled((int)2)) return;
                    String sMsg = "Unable to establishing Executor for Member [%s] with the ClusteredExecutorService; the cache service does not exist or is not running.";
                    Logger.warn((String)String.format(sMsg, member.getId()));
                    return;
                }
                if (!Logger.isEnabled((int)2)) return;
                String sMsg = "Unable to establishing Executor for Member [%s] with the ClusteredExecutorService; the cache does not exist or is not active.";
                Logger.warn((String)String.format(sMsg, member.getId()));
                return;
            }
            catch (Exception e) {
                ExecutorTrace.throwing(LifecycleEventInterceptor.class, "onEvent", e, new Object[0]);
                throw Base.ensureRuntimeException((Throwable)e);
            }
        } else {
            if (event.getType() != LifecycleEvent.Type.DISPOSING && event.getType() != SessionLifecycleEvent.Type.STOPPING || this.m_fClosed) return;
            this.m_fClosed = true;
            ResourceRegistry registry = this.getRegistry(event);
            ClusteredExecutorService clusteredExecutorService = (ClusteredExecutorService)registry.getResource(ClusteredExecutorService.class, ClusteredExecutorService.class.getSimpleName());
            if (clusteredExecutorService != null) {
                clusteredExecutorService.shutdownNow();
            }
            Hook.runShutdownHooks(registry);
            ConcurrentConfiguration.get().reset();
        }
    }

    protected ResourceRegistry getRegistry(Event<?> event) {
        if (event instanceof LifecycleEvent) {
            return ((LifecycleEvent)event).getConfigurableCacheFactory().getResourceRegistry();
        }
        return ((SessionLifecycleEvent)event).getSession().getResourceRegistry();
    }
}

