/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor.internal;

import com.oracle.coherence.concurrent.executor.ComposableContinuation;
import com.oracle.coherence.concurrent.executor.ContinuationService;
import com.oracle.coherence.concurrent.executor.PortableAbstractProcessor;
import com.oracle.coherence.concurrent.executor.internal.Cause;
import com.oracle.coherence.concurrent.executor.internal.ClusterMemberAware;
import com.oracle.coherence.concurrent.executor.internal.ExecutorTrace;
import com.oracle.coherence.concurrent.executor.internal.Hook;
import com.oracle.coherence.concurrent.executor.internal.Leased;
import com.oracle.coherence.concurrent.executor.internal.LiveObject;
import com.oracle.coherence.concurrent.executor.util.Caches;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.Member;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberListener;
import com.tangosol.net.cache.CacheEvent;
import com.tangosol.net.events.Event;
import com.tangosol.net.events.EventDispatcher;
import com.tangosol.net.events.EventDispatcherAwareInterceptor;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.net.events.partition.PartitionedServiceDispatcher;
import com.tangosol.net.events.partition.TransactionEvent;
import com.tangosol.net.events.partition.TransferEvent;
import com.tangosol.net.events.partition.cache.EntryEvent;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.DaemonThreadFactory;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.SafeHashSet;
import com.tangosol.util.UID;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class LiveObjectEventInterceptor
implements EventDispatcherAwareInterceptor,
MemberListener {
    public static long LEASE_INSPECTION_DELAY_MS = 10000L;
    protected CacheService m_cacheService;
    protected final ScheduledExecutorService f_executorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DaemonThreadFactory("LiveObjectThread-"));
    protected final ContinuationService<Object> f_continuationService = new ContinuationService((ThreadFactory)new DaemonThreadFactory("ContinuationService-"));
    protected final ConcurrentHashMap<Object, Long> f_mapLeaseExpiryTimes = new ConcurrentHashMap();
    protected final ConcurrentHashMap<UID, Set<Object>> f_mapMemberAwareObjects = new ConcurrentHashMap();

    public LiveObjectEventInterceptor() {
        this.f_executorService.scheduleAtFixedRate(new LeaseInspectorRunnable(), LEASE_INSPECTION_DELAY_MS, LEASE_INSPECTION_DELAY_MS, TimeUnit.MILLISECONDS);
    }

    public void onEvent(Event event) {
        Set setBinaryEntries = Collections.emptySet();
        Set<BinaryEntry> setAssignments = Collections.emptySet();
        Set<BinaryEntry> setTasks = Collections.emptySet();
        Cause cause = Cause.REGULAR;
        if (event instanceof TransactionEvent) {
            setBinaryEntries = ((TransactionEvent)event).getEntrySet();
        } else if (event instanceof TransferEvent) {
            setBinaryEntries = (Set)((TransferEvent)event).getEntries().get("executor-executors");
            if (setBinaryEntries == null) {
                setBinaryEntries = Collections.emptySet();
            }
            if ((setAssignments = (Set<BinaryEntry>)((TransferEvent)event).getEntries().get(Caches.ASSIGNMENTS_CACHE_NAME)) == null) {
                setAssignments = Collections.emptySet();
            }
            if ((setTasks = (Set<BinaryEntry>)((TransferEvent)event).getEntries().get(Caches.TASKS_CACHE_NAME)) == null) {
                setTasks = Collections.emptySet();
            }
            cause = Cause.PARTITIONING;
        }
        for (BinaryEntry binaryEntry : setBinaryEntries) {
            this.processEntry(event, binaryEntry, cause);
        }
        for (BinaryEntry binaryEntry : setAssignments) {
            this.processEntry(event, binaryEntry, cause);
        }
        for (BinaryEntry binaryEntry : setTasks) {
            this.processEntry(event, binaryEntry, cause);
        }
    }

    public void introduceEventDispatcher(String sIdentifier, EventDispatcher dispatcher) {
        if (dispatcher instanceof PartitionedServiceDispatcher) {
            this.m_cacheService = (CacheService)((PartitionedServiceDispatcher)dispatcher).getService();
            this.m_cacheService.addMemberListener((MemberListener)this);
            dispatcher.addEventInterceptor(sIdentifier, (EventInterceptor)this);
            Hook.addShutdownHook(this.m_cacheService.getBackingMapManager().getCacheFactory().getResourceRegistry(), () -> {
                this.f_executorService.shutdown();
                this.f_continuationService.shutdown();
            });
        }
    }

    public CacheService getCacheService() {
        return this.m_cacheService;
    }

    protected void processEntry(Event event, BinaryEntry binaryEntry, Cause cause) {
        Object oKey = binaryEntry.getKey();
        EntryEvent.Type type = EntryEvent.Type.INSERTING;
        boolean fTransfer = event instanceof TransferEvent;
        boolean fTransaction = event instanceof TransactionEvent;
        if (fTransfer) {
            TransferEvent.Type transType = (TransferEvent.Type)((TransferEvent)event).getType();
            if (transType == TransferEvent.Type.ARRIVED || transType == TransferEvent.Type.RECOVERED) {
                type = EntryEvent.Type.INSERTED;
            } else if (transType == TransferEvent.Type.DEPARTING) {
                type = EntryEvent.Type.REMOVED;
            }
        } else if (fTransaction && ((TransactionEvent)event).getType() == TransactionEvent.Type.COMMITTED) {
            type = binaryEntry.getOriginalValue() == null ? EntryEvent.Type.INSERTED : (binaryEntry.getValue() == null ? EntryEvent.Type.REMOVED : EntryEvent.Type.UPDATED);
        }
        BackingMapManagerContext context = binaryEntry.getContext();
        if (context.isKeyOwned((Object)binaryEntry.getBinaryKey())) {
            cause = this.isDecorationRemoved(binaryEntry, 2) ? Cause.STORE_COMPLETED : (event instanceof CacheEvent && ((CacheEvent)event).isSynthetic() ? Cause.EVICTION : Cause.REGULAR);
        }
        switch (type) {
            case INSERTED: {
                UID uid;
                Object oValue = binaryEntry.getValue();
                if (oValue instanceof Leased) {
                    this.f_mapLeaseExpiryTimes.put(oKey, ((Leased)oValue).getLeaseExpiryTime());
                }
                if (oValue instanceof ClusterMemberAware && (uid = ((ClusterMemberAware)oValue).getUid()) != null) {
                    boolean fMemberFound = false;
                    for (Member member : CacheFactory.getCluster().getMemberSet()) {
                        if (!member.getUid().equals((Object)uid)) continue;
                        fMemberFound = true;
                        break;
                    }
                    if (fMemberFound) {
                        SafeHashSet set = this.f_mapMemberAwareObjects.get(uid);
                        ExecutorTrace.log(() -> String.format("Adding [%s] into ClusterMemberAware table for UID [%s].", oKey, uid));
                        if (set == null) {
                            set = new SafeHashSet();
                            this.f_mapMemberAwareObjects.put(uid, (Set<Object>)set);
                        }
                        set.add((Object)oKey);
                    } else {
                        ExecutorTrace.log(() -> String.format("Member with UID [%s] has left the cluster.  Invoking MemberLeft event on [%s].", uid, oKey));
                        this.f_executorService.submit(new MemberEventRunnable(3, Collections.singleton(oKey)));
                    }
                }
                if (!(oValue instanceof LiveObject)) break;
                ComposableContinuation continuation = fTransfer ? ((LiveObject)oValue).onInserted((CacheService)((TransferEvent)event).getDispatcher().getService(), (InvocableMap.Entry)binaryEntry, cause) : (fTransaction ? ((LiveObject)oValue).onInserted((CacheService)((TransactionEvent)event).getDispatcher().getService(), (InvocableMap.Entry)binaryEntry, cause) : null);
                this.f_continuationService.submit(continuation, binaryEntry.getKey());
                break;
            }
            case UPDATED: {
                Object oValue = binaryEntry.getValue();
                if (oValue instanceof Leased) {
                    this.f_mapLeaseExpiryTimes.put(oKey, ((Leased)oValue).getLeaseExpiryTime());
                }
                if (!(oValue instanceof LiveObject)) break;
                ComposableContinuation continuation = fTransfer ? ((LiveObject)oValue).onUpdated((CacheService)((TransferEvent)event).getDispatcher().getService(), (InvocableMap.Entry)binaryEntry, cause) : (fTransaction ? ((LiveObject)oValue).onUpdated((CacheService)((TransactionEvent)event).getDispatcher().getService(), (InvocableMap.Entry)binaryEntry, cause) : null);
                this.f_continuationService.submit(continuation, binaryEntry.getKey());
                break;
            }
            case REMOVED: {
                UID uid;
                Object oValue = binaryEntry.getOriginalValue();
                if (oValue instanceof Leased) {
                    this.f_mapLeaseExpiryTimes.remove(oKey);
                }
                if (oValue instanceof ClusterMemberAware && (uid = ((ClusterMemberAware)oValue).getUid()) != null) {
                    Set<Object> set = this.f_mapMemberAwareObjects.get(uid);
                    ExecutorTrace.log(() -> String.format("Removing [%s] from ClusterMemberAware table for UID [%s].", oKey, uid));
                    if (set != null) {
                        set.remove(oKey);
                        if (set.isEmpty()) {
                            this.f_mapMemberAwareObjects.remove(uid);
                        }
                    }
                }
                if (!(oValue instanceof LiveObject)) break;
                ComposableContinuation continuation = fTransfer ? ((LiveObject)oValue).onDeleted((CacheService)((TransferEvent)event).getDispatcher().getService(), (InvocableMap.Entry)binaryEntry, cause) : (fTransaction ? ((LiveObject)oValue).onDeleted((CacheService)((TransactionEvent)event).getDispatcher().getService(), (InvocableMap.Entry)binaryEntry, cause) : null);
                this.f_continuationService.submit(continuation, binaryEntry.getKey());
            }
        }
    }

    private void onMemberEvent(MemberEvent event) {
        Set<Object> set = this.f_mapMemberAwareObjects.get(event.getMember().getUid());
        if (set != null) {
            this.f_executorService.submit(new MemberEventRunnable(event.getId(), set));
        }
    }

    protected boolean isDecorationRemoved(BinaryEntry binEntry, int nDecorationId) {
        Binary binOldValue = binEntry.getOriginalBinaryValue();
        Binary binNewValue = binEntry.getBinaryValue();
        BackingMapManagerContext context = binEntry.getBackingMapContext().getManagerContext();
        return binOldValue != null && context.isInternalValueDecorated((Object)binOldValue, nDecorationId) && !context.isInternalValueDecorated((Object)binNewValue, nDecorationId);
    }

    public void memberJoined(MemberEvent memberEvent) {
        this.onMemberEvent(memberEvent);
    }

    public void memberLeaving(MemberEvent memberEvent) {
        this.onMemberEvent(memberEvent);
    }

    public void memberLeft(MemberEvent memberEvent) {
        this.onMemberEvent(memberEvent);
    }

    class LeaseInspectorRunnable
    implements Runnable {
        LeaseInspectorRunnable() {
        }

        @Override
        public void run() {
            long ldtCurrentTime = CacheFactory.getSafeTimeMillis();
            String sCacheName = "executor-executors";
            ExecutorTrace.log(() -> String.format("Commenced Inspecting Lease Expiry Times for [%s].", sCacheName));
            for (Object oKey : LiveObjectEventInterceptor.this.f_mapLeaseExpiryTimes.keySet()) {
                Long ldtExpiryTime = LiveObjectEventInterceptor.this.f_mapLeaseExpiryTimes.get(oKey);
                if (ldtExpiryTime != null && ldtExpiryTime <= ldtCurrentTime) {
                    ExecutorTrace.log(() -> String.format("Lease for [%s] has expired for [%s].", oKey, sCacheName));
                    boolean updated = (Boolean)LiveObjectEventInterceptor.this.getCacheService().ensureCache(sCacheName, null).invoke(oKey, (InvocableMap.EntryProcessor)new ExpiredProcessor());
                    if (updated) continue;
                    ExecutorTrace.log(() -> String.format("Removing Lease for [%s] as the lease could not be updated.", oKey));
                    LiveObjectEventInterceptor.this.f_mapLeaseExpiryTimes.remove(oKey);
                    continue;
                }
                ExecutorTrace.log(() -> String.format("Lease for [%s] is valid for [%s].", oKey, sCacheName));
            }
            ExecutorTrace.log(() -> String.format("Completed Inspecting Lease Expiry Times for [%s].", sCacheName));
        }
    }

    class MemberEventRunnable
    implements Runnable {
        protected final int f_nId;
        protected final Set<Object> f_setMemberAware;

        MemberEventRunnable(int nId, Set<Object> setMemberAware) {
            this.f_nId = nId;
            this.f_setMemberAware = setMemberAware;
        }

        @Override
        public void run() {
            Caches.executors(LiveObjectEventInterceptor.this.getCacheService()).invokeAll(this.f_setMemberAware, (InvocableMap.EntryProcessor)new MemberAwareProcessor(this.f_nId));
        }
    }

    public static class MemberAwareProcessor
    extends PortableAbstractProcessor<String, ClusterMemberAware, Boolean> {
        protected int m_nId;

        public MemberAwareProcessor() {
        }

        public MemberAwareProcessor(int nId) {
            this.m_nId = nId;
        }

        public Boolean process(InvocableMap.Entry entry) {
            if (entry.isPresent() && entry.getValue() instanceof ClusterMemberAware) {
                ClusterMemberAware memberAware = (ClusterMemberAware)entry.getValue();
                boolean fSubmit = false;
                switch (this.m_nId) {
                    case 1: {
                        fSubmit = memberAware.onMemberJoined();
                        break;
                    }
                    case 2: {
                        fSubmit = memberAware.onMemberLeaving();
                        break;
                    }
                    case 3: {
                        fSubmit = memberAware.onMemberLeft();
                    }
                }
                if (fSubmit) {
                    entry.setValue((Object)memberAware);
                }
                return true;
            }
            if (!entry.isPresent()) {
                ExecutorTrace.log(() -> String.format("MemberAwareProcessor can't call [%s] as it is not present.", entry.getKey()));
            } else {
                ExecutorTrace.log(() -> String.format("MemberAwareProcessor can't call [%s] as it does not implement ClusterMemberAware.", entry.getKey()));
            }
            return false;
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_nId = in.readInt(0);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeInt(0, this.m_nId);
        }
    }

    public static class ExpiredProcessor
    extends PortableAbstractProcessor<String, Leased, Boolean> {
        public Boolean process(InvocableMap.Entry entry) {
            if (entry.isPresent() && entry.getValue() instanceof Leased) {
                Leased leased = (Leased)entry.getValue();
                if (leased.onLeaseExpiry()) {
                    entry.setValue((Object)leased);
                }
                return true;
            }
            ExecutorTrace.log(() -> String.format("ExpiredProcessor can't expire [%s] as it is not present.", entry.getKey()));
            return false;
        }
    }
}

