/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor.management;

import com.tangosol.net.management.annotation.Description;
import com.tangosol.net.management.annotation.MetricsScope;
import com.tangosol.net.management.annotation.MetricsTag;
import com.tangosol.net.management.annotation.MetricsValue;
import com.tangosol.net.metrics.MBeanMetric;

@MetricsScope(value=MBeanMetric.Scope.VENDOR)
@Description(value="Provides Executor statistics.")
public interface ExecutorMBean {
    public static final String EXECUTOR_TYPE = "type=Executor";
    public static final String EXECUTOR_NAME = ",name=";

    @Description(value="Reset the statistics.")
    public void resetStatistics();

    @Description(value="The member id where the executor is running.")
    @MetricsTag(value="memberId")
    public String getMemberId();

    @Description(value="The logical name of this executor.")
    public String getName();

    @Description(value="The unique ID of this executor.")
    public String getId();

    @Description(value="The description of this executor.")
    public String getDescription();

    @Description(value="The location where the executor is running.")
    public String getLocation();

    @Description(value="The state of the executor.")
    public String getState();

    @Description(value="The State of the executor. The value of 1 (JOINING) indicates executor is joining the orchestration.The value of 2 (RUNNING) indicates executor is accepting and executing tasks.The value of 3 (CLOSING_GRACEFULLY) has commenced graceful closing. No new tasks will be accepted, but existing ones will run to completion.The value of 4 (CLOSING) indicates Executor has commenced closing.The value of 5 indicates CLOSED.The value of 6 indicates executor is REJECTING tasks.")
    @MetricsValue
    public int getStateCode();

    @Description(value="The completed tasks count.")
    @MetricsValue
    public long getTasksCompletedCount();

    @Description(value="The tasks rejected count.")
    @MetricsValue
    public long getTasksRejectedCount();

    @Description(value="The in progress tasks count.")
    @MetricsValue
    public long getTasksInProgressCount();

    @Description(value="Indicate the executor traceLogging is enabled (true) or not (false).")
    public boolean isTraceLogging();

    @Description(value="Set the trace to true to enable executor trace logging; false to disable executor trace logging.")
    public void setTraceLogging(boolean var1);
}

