/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor.subscribers;

import com.oracle.coherence.concurrent.executor.Task;
import com.oracle.coherence.concurrent.executor.internal.ExecutorTrace;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class RecordingSubscriber<T>
implements Task.Subscriber<T> {
    protected final AtomicBoolean f_fUsed;
    protected final AtomicBoolean f_fCompleted = new AtomicBoolean(false);
    protected final AtomicBoolean f_fErrored = new AtomicBoolean(false);
    protected final AtomicReference<Throwable> f_throwable = new AtomicReference();
    protected final CopyOnWriteArrayList<T> f_listItems = new CopyOnWriteArrayList();
    protected final AtomicReference<Task.Subscription<? extends T>> f_subscription = new AtomicReference();

    public RecordingSubscriber() {
        this.f_fUsed = new AtomicBoolean(false);
    }

    @Override
    public void onComplete() {
        ExecutorTrace.entering(RecordingSubscriber.class, "onComplete", new Object[0]);
        this.f_fCompleted.compareAndSet(false, true);
        this.f_subscription.set(null);
        ExecutorTrace.exiting(RecordingSubscriber.class, "onComplete");
    }

    @Override
    public void onError(Throwable throwable) {
        ExecutorTrace.entering(RecordingSubscriber.class, "onError", throwable);
        this.f_fErrored.compareAndSet(false, true);
        this.f_subscription.set(null);
        this.f_throwable.set(throwable);
        ExecutorTrace.exiting(RecordingSubscriber.class, "onError");
    }

    @Override
    public void onNext(T item) {
        ExecutorTrace.entering(RecordingSubscriber.class, "onNext", item);
        this.f_listItems.add(item);
        ExecutorTrace.exiting(RecordingSubscriber.class, "onNext");
    }

    @Override
    public void onSubscribe(Task.Subscription<? extends T> subscription) {
        block4: {
            ExecutorTrace.entering(RecordingSubscriber.class, "onSubscribe", subscription);
            try {
                if (this.f_fUsed.compareAndSet(false, true)) {
                    this.f_subscription.set(subscription);
                    break block4;
                }
                throw new UnsupportedOperationException("RecordingSubscriber reuse is not supported.");
            }
            finally {
                ExecutorTrace.exiting(RecordingSubscriber.class, "onSubscribe");
            }
        }
    }

    public boolean isError() {
        return this.f_fErrored.get();
    }

    public boolean isCompleted() {
        return this.f_fCompleted.get();
    }

    public boolean isSubscribed() {
        return this.f_subscription.get() != null;
    }

    public boolean received(T item) {
        return this.f_listItems.contains(item);
    }

    public T getFirst() {
        return this.f_listItems.get(0);
    }

    public T getLast() {
        int size = this.f_listItems.size();
        return size == 0 ? null : (T)this.f_listItems.get(size - 1);
    }

    public int size() {
        return this.f_listItems.size();
    }

    public Throwable getThrowable() {
        return this.f_throwable.get();
    }
}

