/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor.tasks.internal;

import com.oracle.coherence.concurrent.executor.Task;
import com.oracle.coherence.concurrent.executor.tasks.internal.CallableTask;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.Callable;

public class ScheduledCallableTask<T>
extends CallableTask<T>
implements Callable<T> {
    protected long m_ldtSubmitNanos;
    protected Duration m_ltdInitialDelay;

    public ScheduledCallableTask() {
    }

    public ScheduledCallableTask(Callable<T> callable, Duration initialDelay) {
        super(callable);
        this.m_ldtSubmitNanos = System.nanoTime();
        this.m_ltdInitialDelay = initialDelay;
    }

    public Duration getInitialDelay() {
        return this.m_ltdInitialDelay;
    }

    @Override
    public T execute(Task.Context<T> context) throws Exception {
        long currentNanos;
        long executeNanos = this.m_ldtSubmitNanos + (this.m_ltdInitialDelay == null ? 0L : this.m_ltdInitialDelay.toNanos());
        if (executeNanos > (currentNanos = System.nanoTime())) {
            throw Task.Yield.atLeast(Duration.ofNanos(executeNanos - currentNanos));
        }
        return this.getCallable().call();
    }

    @Override
    public T call() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        this.m_ldtSubmitNanos = ExternalizableHelper.readLong((DataInput)in);
        long seconds = ExternalizableHelper.readLong((DataInput)in);
        if (seconds > 0L) {
            this.m_ltdInitialDelay = Duration.ofSeconds(seconds);
        }
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.m_ldtSubmitNanos);
        ExternalizableHelper.writeLong((DataOutput)out, (long)(this.m_ltdInitialDelay == null ? 0L : this.m_ltdInitialDelay.getSeconds()));
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        super.readExternal(in);
        this.m_ldtSubmitNanos = in.readLong(1);
        long seconds = in.readLong(2);
        if (seconds > 0L) {
            this.m_ltdInitialDelay = Duration.ofSeconds(seconds);
        }
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        super.writeExternal(out);
        out.writeLong(1, this.m_ldtSubmitNanos);
        out.writeLong(2, this.m_ltdInitialDelay == null ? 0L : this.m_ltdInitialDelay.getSeconds());
    }

    @Override
    public String toString() {
        return "ScheduledCallableTask{callable=" + this.m_callable + ", execution-time-nanos=" + this.m_ldtSubmitNanos + ", initial-delay=" + this.m_ltdInitialDelay + "}";
    }
}

