/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.config.builders;

import com.oracle.coherence.concurrent.config.NamedExecutorService;
import com.oracle.coherence.concurrent.config.builders.AbstractExecutorWithFactoryBuilder;
import com.tangosol.coherence.config.ParameterList;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.ParameterResolver;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;

public class FixedBuilder
extends AbstractExecutorWithFactoryBuilder<NamedExecutorService> {
    protected Expression<Integer> m_threadCount;

    public NamedExecutorService realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
        String sName = (String)this.m_name.evaluate(resolver);
        int cThreadCount = (Integer)this.m_threadCount.evaluate(resolver);
        ThreadFactory factory = this.m_bldr == null ? null : (ThreadFactory)this.m_bldr.realize(resolver, loader, listParameters);
        Supplier<ExecutorService> supplier = factory == null ? () -> Executors.newFixedThreadPool(cThreadCount) : () -> Executors.newFixedThreadPool(cThreadCount, factory);
        NamedExecutorService service = new NamedExecutorService(sName, this.description(cThreadCount, factory), supplier);
        this.register(service);
        return service;
    }

    @Injectable(value="thread-count")
    public void setThreadCount(Expression<Integer> threadCount) {
        this.m_threadCount = threadCount;
    }

    protected String description(int cThreadCount, ThreadFactory factory) {
        String sFactory = factory == null ? "default" : factory.getClass().getName();
        return String.format("FixedThreadPool(ThreadCount=%s, ThreadFactory=%s)", cThreadCount, sFactory);
    }
}

