/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor.function;

import com.oracle.coherence.concurrent.executor.Result;
import com.oracle.coherence.concurrent.executor.TaskExecutorService;
import com.oracle.coherence.concurrent.executor.function.PortablePredicate;
import com.oracle.coherence.concurrent.executor.options.Role;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.function.Remote;
import java.io.IOException;

public final class Predicates {
    private Predicates() {
    }

    public static <T> Remote.Predicate<T> always() {
        return AlwaysPredicate.get();
    }

    public static <T> Remote.Predicate<T> anything() {
        return AlwaysPredicate.get();
    }

    public static <T> Remote.Predicate<T> never() {
        return NeverPredicate.get();
    }

    public static <T> Remote.Predicate<T> nullValue() {
        return NullValuePredicate.get();
    }

    public static <T> Remote.Predicate<T> notNullValue() {
        return Predicates.not(NullValuePredicate.get());
    }

    public static <T> Remote.Predicate<T> equalTo(T value) {
        return new EqualToPredicate<T>(value);
    }

    public static <T> Remote.Predicate<T> is(T value) {
        return new EqualToPredicate<T>(value);
    }

    public static <T> Remote.Predicate<T> is(Remote.Predicate<T> predicate) {
        return predicate;
    }

    public static <T> Remote.Predicate<T> not(Remote.Predicate<T> predicate) {
        return new NegatePredicate<T>(predicate);
    }

    public static <T> Remote.Predicate<Result<T>> available() {
        return IsValuePredicate.get();
    }

    public static Remote.Predicate<TaskExecutorService.ExecutorInfo> role(String pattern) {
        return new RolePredicate(pattern);
    }

    public static Remote.Predicate<TaskExecutorService.ExecutorInfo> has(TaskExecutorService.Registration.Option option) {
        return new OptionPredicate(option);
    }

    public static <T> Remote.Predicate<Result<T>> onException() {
        return new ThrowablePredicate();
    }

    public static <T> Remote.Predicate<Result<T>> onException(Throwable throwable) {
        return new ThrowablePredicate(throwable);
    }

    public static class ThrowablePredicate<T>
    implements PortablePredicate<Result<T>> {
        protected Throwable m_throwable;

        public ThrowablePredicate() {
        }

        public ThrowablePredicate(Throwable throwable) {
            this.m_throwable = throwable;
        }

        public boolean test(Result<T> result) {
            if (this.m_throwable == null || result == null) {
                return result != null && result.isThrowable();
            }
            Throwable given = null;
            try {
                result.get();
            }
            catch (Throwable throwable) {
                given = throwable;
            }
            return given != null && given.toString().equals(this.m_throwable.toString());
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_throwable = (Throwable)in.readObject(0);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeObject(0, (Object)this.m_throwable);
        }
    }

    public static class RolePredicate
    implements PortablePredicate<TaskExecutorService.ExecutorInfo> {
        protected String m_sPattern;

        public RolePredicate() {
        }

        public RolePredicate(String sPattern) {
            this.m_sPattern = sPattern;
        }

        public boolean test(TaskExecutorService.ExecutorInfo executorInfo) {
            Role role = executorInfo.getOption(Role.class, null);
            return role != null && role.getName().matches(this.m_sPattern);
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_sPattern = in.readString(0);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeString(0, this.m_sPattern);
        }
    }

    public static class OptionPredicate
    implements PortablePredicate<TaskExecutorService.ExecutorInfo> {
        protected TaskExecutorService.Registration.Option m_option;

        public OptionPredicate() {
        }

        public OptionPredicate(TaskExecutorService.Registration.Option option) {
            this.m_option = option;
        }

        public boolean test(TaskExecutorService.ExecutorInfo executorInfo) {
            Object option = executorInfo.getOption(this.m_option.getClass(), null);
            return this.m_option == null && option == null || this.m_option != null && this.m_option.equals(option);
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_option = (TaskExecutorService.Registration.Option)in.readObject(0);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeObject(0, (Object)this.m_option);
        }
    }

    public static class NullValuePredicate
    implements PortablePredicate {
        protected static final NullValuePredicate INSTANCE = new NullValuePredicate();

        public boolean test(Object o) {
            return o == null;
        }

        public static NullValuePredicate get() {
            return INSTANCE;
        }
    }

    public static class NeverPredicate
    implements PortablePredicate {
        protected static final NeverPredicate INSTANCE = new NeverPredicate();

        public static NeverPredicate get() {
            return INSTANCE;
        }

        public boolean test(Object o) {
            return false;
        }
    }

    public static class NegatePredicate<T>
    implements PortablePredicate<T> {
        private Remote.Predicate<T> m_predicate;

        public NegatePredicate() {
        }

        public NegatePredicate(Remote.Predicate<T> predicate) {
            this.m_predicate = predicate;
        }

        public boolean test(T t) {
            return !this.m_predicate.test(t);
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_predicate = (Remote.Predicate)in.readObject(0);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeObject(0, this.m_predicate);
        }
    }

    public static class IsValuePredicate<T>
    implements PortablePredicate<Result<T>> {
        protected static final IsValuePredicate INSTANCE = new IsValuePredicate();

        public boolean test(Result<T> result) {
            return result != null && result.isValue();
        }

        public static <T> IsValuePredicate<T> get() {
            return INSTANCE;
        }
    }

    public static class EqualToPredicate<T>
    implements PortablePredicate<T> {
        protected T m_value;

        public EqualToPredicate() {
        }

        public boolean test(T t) {
            return this.m_value == null && t == null || this.m_value != null && this.m_value.equals(t);
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_value = in.readObject(0);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeObject(0, this.m_value);
        }

        public EqualToPredicate(T value) {
            this.m_value = value;
        }
    }

    public static class AlwaysPredicate
    implements PortablePredicate {
        protected static final AlwaysPredicate INSTANCE = new AlwaysPredicate();

        public static <T> Remote.Predicate<T> get() {
            return INSTANCE;
        }

        public boolean test(Object o) {
            return true;
        }
    }
}

