/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent;

import com.oracle.coherence.concurrent.CountDownLatch;
import com.oracle.coherence.concurrent.Latches;
import com.oracle.coherence.concurrent.internal.LatchCounter;
import com.tangosol.net.NamedMap;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.function.Remote;
import com.tangosol.util.listener.SimpleMapListener;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class RemoteCountDownLatch
implements CountDownLatch {
    private final Sync f_sync;
    private final long f_initialCount;

    public RemoteCountDownLatch(String sName, int count, NamedMap<String, LatchCounter> latches) {
        if (count < 0) {
            throw new IllegalArgumentException("count < 0");
        }
        this.f_sync = new Sync(sName, latches);
        this.f_initialCount = count;
        latches.addMapListener((MapListener)new SimpleMapListener().addDeleteHandler(this::onDelete), (Object)sName, false);
    }

    @Override
    public void await() throws InterruptedException {
        this.f_sync.acquireSharedInterruptibly(1);
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.f_sync.tryAcquireSharedNanos(1, unit.toNanos(timeout));
    }

    @Override
    public void countDown() {
        this.f_sync.releaseShared(1);
    }

    @Override
    public long getCount() {
        return this.f_sync.getCount();
    }

    public long getInitialCount() {
        return this.f_initialCount;
    }

    public String toString() {
        return "RemoteCountDownLatch{count = " + this.f_sync.getCount() + ", initialCount = " + this.f_initialCount + "}";
    }

    protected void signalLocalThreads() {
        this.f_sync.releaseShared(0);
    }

    private void onDelete(MapEvent<? extends String, ? extends LatchCounter> event) {
        String sName = (String)event.getKey();
        Latches.removeCountDownLatch(sName);
        this.signalLocalThreads();
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        private final String f_sName;
        private final NamedMap<String, LatchCounter> f_latches;

        Sync(String sName, NamedMap<String, LatchCounter> latches) {
            this.f_sName = sName;
            this.f_latches = latches;
        }

        public long getCount() {
            return (Long)this.f_latches.invoke((Object)this.f_sName, (InvocableMap.EntryProcessor & Serializable)e -> e.isPresent() ? ((LatchCounter)e.getValue()).getCount() : 0L);
        }

        @Override
        protected int tryAcquireShared(int acquires) {
            if (this.f_latches.compute((Object)this.f_sName, (Remote.BiFunction & Serializable)(k, v) -> {
                if (v == null || v.getCount() == 0L) {
                    return null;
                }
                return v;
            }) == null) {
                return 1;
            }
            return -1;
        }

        @Override
        protected boolean tryReleaseShared(int releases) {
            int count = ((Number)this.f_latches.invoke((Object)this.f_sName, (InvocableMap.EntryProcessor & Serializable)entry -> {
                if (entry.isPresent()) {
                    LatchCounter value = (LatchCounter)entry.getValue();
                    long currentCount = value.getCount();
                    if (releases == 0) {
                        return currentCount;
                    }
                    if (currentCount == 1L) {
                        entry.remove(false);
                    } else {
                        value.countDown();
                        entry.setValue((Object)value);
                    }
                    return currentCount;
                }
                return 0;
            })).intValue();
            if (releases == 0) {
                return count == 0;
            }
            return count == 1;
        }
    }
}

