/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.locks.internal;

import com.oracle.coherence.concurrent.locks.LockOwner;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.Member;
import com.tangosol.net.ServiceInfo;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.UID;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;

public class ExclusiveLockHolder
implements ExternalizableLite,
PortableObject {
    private LockOwner m_lockOwner;

    public boolean isLocked() {
        return this.m_lockOwner != null;
    }

    public boolean isLockedBy(LockOwner owner) {
        return this.isLocked() && this.m_lockOwner.equals(owner);
    }

    public boolean isLockedByMember(UID memberId) {
        return this.isLocked() && this.m_lockOwner.getMemberId().equals((Object)memberId);
    }

    public boolean lock(LockOwner owner) {
        if (this.isLockedBy(owner)) {
            return true;
        }
        if (this.isLocked()) {
            return false;
        }
        this.m_lockOwner = owner;
        return true;
    }

    public boolean unlock(LockOwner owner) {
        if (this.isLockedBy(owner)) {
            this.m_lockOwner = null;
            return true;
        }
        return false;
    }

    public LockOwner getOwner() {
        return this.m_lockOwner;
    }

    protected boolean removeLocksFor(UID memberId) {
        if (this.isLockedByMember(memberId)) {
            this.m_lockOwner = null;
            return true;
        }
        return false;
    }

    protected boolean retainLocksFor(Set<UID> setMemberIds) {
        if (this.isLocked() && !setMemberIds.contains(this.m_lockOwner.getMemberId())) {
            this.m_lockOwner = null;
            return true;
        }
        return false;
    }

    public String toString() {
        return "ExclusiveLockHolder{locked=" + this.isLocked() + ", owner=" + this.getOwner() + "}";
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_lockOwner = (LockOwner)ExternalizableHelper.readObject((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.m_lockOwner);
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_lockOwner = (LockOwner)in.readObject(0);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, (Object)this.m_lockOwner);
    }

    public static class RemoveLocks
    implements InvocableMap.EntryProcessor<String, ExclusiveLockHolder, Void>,
    ExternalizableLite,
    PortableObject {
        protected UID m_memberId;

        public RemoveLocks() {
        }

        public RemoveLocks(UID memberId) {
            this.m_memberId = memberId;
        }

        public Void process(InvocableMap.Entry<String, ExclusiveLockHolder> entry) {
            ExclusiveLockHolder holder = (ExclusiveLockHolder)entry.getValue();
            if (this.m_memberId == null) {
                ServiceInfo info = ((BinaryEntry)entry).getContext().getCacheService().getInfo();
                Set setServiceMembers = info.getServiceMembers();
                Set<UID> setValidMemberIds = setServiceMembers.stream().map(Member::getUid).collect(Collectors.toSet());
                if (holder.retainLocksFor(setValidMemberIds)) {
                    entry.setValue((Object)holder);
                }
            } else if (holder.removeLocksFor(this.m_memberId)) {
                entry.setValue((Object)holder);
            }
            return null;
        }

        public void readExternal(DataInput in) throws IOException {
            this.m_memberId = (UID)ExternalizableHelper.readObject((DataInput)in);
        }

        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeObject((DataOutput)out, (Object)this.m_memberId);
        }

        public void readExternal(PofReader in) throws IOException {
            this.m_memberId = (UID)in.readObject(0);
        }

        public void writeExternal(PofWriter out) throws IOException {
            out.writeObject(0, (Object)this.m_memberId);
        }
    }
}

